/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.util;

import java.dyn.LinkagePermission;
import java.lang.reflect.Modifier;

public class VerifyAccess {
    private VerifyAccess() {
    }

    public static Class<?> isAccessible(Class<?> clazz, int n, boolean bl, Class<?> clazz2) {
        if (!VerifyAccess.isAccessible(clazz, clazz2)) {
            return null;
        }
        Class clazz3 = Object.class;
        if (!bl && !Modifier.isStatic(n)) {
            clazz3 = clazz2;
        }
        if (Modifier.isPublic(n)) {
            return clazz3;
        }
        if (Modifier.isPrivate(n)) {
            return VerifyAccess.isSamePackageMember(clazz, clazz2) ? clazz3 : null;
        }
        if (VerifyAccess.isSamePackage(clazz, clazz2)) {
            return clazz3;
        }
        if (Modifier.isProtected(n) && clazz.isAssignableFrom(clazz2)) {
            return clazz3;
        }
        return null;
    }

    public static boolean isAccessible(Class<?> clazz, Class<?> clazz2) {
        int n = clazz.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        return VerifyAccess.isSamePackage(clazz2, clazz);
    }

    public static boolean isSamePackage(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (!VerifyAccess.loadersAreRelated(clazz.getClassLoader(), clazz2.getClassLoader())) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        if (n != string2.lastIndexOf(46)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSamePackageMember(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (!VerifyAccess.isSamePackage(clazz, clazz2)) {
            return false;
        }
        return VerifyAccess.getOutermostEnclosingClass(clazz) == VerifyAccess.getOutermostEnclosingClass(clazz2);
    }

    private static Class<?> getOutermostEnclosingClass(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<?> clazz3 = clazz;
        while ((clazz3 = clazz3.getEnclosingClass()) != null) {
            clazz2 = clazz3;
        }
        return clazz2;
    }

    private static boolean loadersAreRelated(ClassLoader classLoader, ClassLoader classLoader2) {
        ClassLoader classLoader3;
        if (classLoader == classLoader2 || classLoader == null || classLoader2 == null) {
            return true;
        }
        for (classLoader3 = classLoader; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader2) continue;
            return true;
        }
        for (classLoader3 = classLoader2; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader) continue;
            return true;
        }
        return false;
    }

    public static void checkBootstrapPrivilege(Class clazz, Class clazz2, String string) {
        if (clazz == null) {
            return;
        }
        if (clazz == clazz2) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (VerifyAccess.isSamePackage(clazz, clazz2)) {
            return;
        }
        securityManager.checkPermission(new LinkagePermission(string, clazz));
    }
}

