/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.management.AttributeValueExp;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class QueryParser {
    private static final Token END = new Token("<end of string>");
    private static final Token LPAR = new Token("(");
    private static final Token RPAR = new Token(")");
    private static final Token COMMA = new Token(",");
    private static final Token DOT = new Token(".");
    private static final Token SHARP = new Token("#");
    private static final Token PLUS = new Token("+");
    private static final Token MINUS = new Token("-");
    private static final Token TIMES = new Token("*");
    private static final Token DIVIDE = new Token("/");
    private static final Token LT = new Token("<");
    private static final Token GT = new Token(">");
    private static final Token LE = new Token("<=");
    private static final Token GE = new Token(">=");
    private static final Token NE = new Token("<>");
    private static final Token EQ = new Token("=");
    private static final Token NOT = new Id("NOT");
    private static final Token INSTANCEOF = new Id("INSTANCEOF");
    private static final Token FALSE = new Id("FALSE");
    private static final Token TRUE = new Id("TRUE");
    private static final Token BETWEEN = new Id("BETWEEN");
    private static final Token AND = new Id("AND");
    private static final Token OR = new Id("OR");
    private static final Token IN = new Id("IN");
    private static final Token LIKE = new Id("LIKE");
    private static final Token CLASS = new Id("CLASS");
    private static final Set<String> idKeywords = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final List<Token> tokens = new ArrayList<Token>();
    private int tokenI;
    private static final Token[] relations;
    private static final Token[] betweenLikeIn;

    public static String quoteId(String string) {
        if (string.contains("\"") || idKeywords.contains(string)) {
            return '\"' + string.replace("\"", "\"\"") + '\"';
        }
        return string;
    }

    private static double parseDoubleCheckOverflow(String string) {
        double d = Double.parseDouble(string);
        if (Double.isInfinite(d)) {
            throw new NumberFormatException("Overflow: " + string);
        }
        if (d == 0.0) {
            String string2 = string;
            int n = string.indexOf(101);
            if (n > 0) {
                string2 = string.substring(0, n);
            }
            if (!(string2 = string2.replace("0", "").replace(".", "")).equals("")) {
                throw new NumberFormatException("Underflow: " + string);
            }
        }
        return d;
    }

    QueryParser(String string) {
        Token token;
        Tokenizer tokenizer = new Tokenizer(string);
        while ((token = tokenizer.nextToken()) != null) {
            this.tokens.add(token);
        }
        this.tokens.add(END);
    }

    private Token current() {
        return this.tokens.get(this.tokenI);
    }

    private boolean skip(Token token) {
        if (token.equals(this.current())) {
            ++this.tokenI;
            return true;
        }
        return false;
    }

    private int skipOne(Token ... tokenArray) {
        for (int i = 0; i < tokenArray.length; ++i) {
            if (!this.skip(tokenArray[i])) continue;
            return i;
        }
        return -1;
    }

    private void expect(Token token) {
        if (!this.skip(token)) {
            throw new IllegalArgumentException("Expected " + token + ", found " + this.current());
        }
    }

    private void next() {
        ++this.tokenI;
    }

    QueryExp parseQuery() {
        QueryExp queryExp = this.query();
        if (this.current() != END) {
            throw new IllegalArgumentException("Junk at end of query: " + this.current());
        }
        return queryExp;
    }

    private QueryExp query() {
        QueryExp queryExp = this.andquery();
        while (this.skip(OR)) {
            queryExp = Query.or(queryExp, this.andquery());
        }
        return queryExp;
    }

    private QueryExp andquery() {
        QueryExp queryExp = this.predicate();
        while (this.skip(AND)) {
            queryExp = Query.and(queryExp, this.predicate());
        }
        return queryExp;
    }

    private QueryExp predicate() {
        if (this.skip(LPAR)) {
            int n = this.tokenI - 1;
            try {
                QueryExp queryExp = this.query();
                this.expect(RPAR);
                return queryExp;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.tokenI = n;
            }
        }
        if (this.skip(NOT)) {
            return Query.not(this.predicate());
        }
        if (this.skip(INSTANCEOF)) {
            return Query.isInstanceOf(this.stringvalue());
        }
        if (this.skip(LIKE)) {
            StringValueExp stringValueExp = this.stringvalue();
            String string = stringValueExp.getValue();
            try {
                return new ObjectName(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException("Bad ObjectName pattern after LIKE: '" + string + "'", malformedObjectNameException);
            }
        }
        ValueExp valueExp = this.value();
        return this.predrhs(valueExp);
    }

    private QueryExp predrhs(ValueExp valueExp) {
        QueryExp queryExp;
        Token token = this.current();
        int n = this.skipOne(relations);
        if (n >= 0) {
            ValueExp valueExp2 = this.value();
            switch (n) {
                case 0: {
                    return Query.eq(valueExp, valueExp2);
                }
                case 1: {
                    return Query.lt(valueExp, valueExp2);
                }
                case 2: {
                    return Query.gt(valueExp, valueExp2);
                }
                case 3: {
                    return Query.leq(valueExp, valueExp2);
                }
                case 4: {
                    return Query.geq(valueExp, valueExp2);
                }
                case 5: {
                    return Query.not(Query.eq(valueExp, valueExp2));
                }
            }
            throw new AssertionError();
        }
        boolean bl = this.skip(NOT);
        n = this.skipOne(betweenLikeIn);
        if (n < 0) {
            throw new IllegalArgumentException("Expected relation at " + token);
        }
        switch (n) {
            case 0: {
                ValueExp valueExp3 = this.value();
                this.expect(AND);
                ValueExp valueExp4 = this.value();
                queryExp = Query.between(valueExp, valueExp3, valueExp4);
                break;
            }
            case 1: {
                if (!(valueExp instanceof AttributeValueExp)) {
                    throw new IllegalArgumentException("Left-hand side of LIKE must be an attribute");
                }
                AttributeValueExp attributeValueExp = (AttributeValueExp)valueExp;
                StringValueExp stringValueExp = this.stringvalue();
                queryExp = Query.match(attributeValueExp, stringValueExp);
                break;
            }
            case 2: {
                this.expect(LPAR);
                ArrayList<ValueExp> arrayList = new ArrayList<ValueExp>();
                arrayList.add(this.value());
                while (this.skip(COMMA)) {
                    arrayList.add(this.value());
                }
                this.expect(RPAR);
                queryExp = Query.in(valueExp, arrayList.toArray(new ValueExp[arrayList.size()]));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (bl) {
            queryExp = Query.not(queryExp);
        }
        return queryExp;
    }

    private ValueExp value() {
        int n;
        ValueExp valueExp = this.factor();
        while ((n = this.skipOne(PLUS, MINUS)) >= 0) {
            ValueExp valueExp2 = this.factor();
            if (n == 0) {
                valueExp = Query.plus(valueExp, valueExp2);
                continue;
            }
            valueExp = Query.minus(valueExp, valueExp2);
        }
        return valueExp;
    }

    private ValueExp factor() {
        int n;
        ValueExp valueExp = this.term();
        while ((n = this.skipOne(TIMES, DIVIDE)) >= 0) {
            ValueExp valueExp2 = this.term();
            if (n == 0) {
                valueExp = Query.times(valueExp, valueExp2);
                continue;
            }
            valueExp = Query.div(valueExp, valueExp2);
        }
        return valueExp;
    }

    private ValueExp term() {
        boolean bl = false;
        int n = 1;
        if (this.skip(PLUS)) {
            bl = true;
        } else if (this.skip(MINUS)) {
            bl = true;
            n = -1;
        }
        Token token = this.current();
        this.next();
        if (token instanceof DoubleLit) {
            return Query.value((double)n * ((DoubleLit)token).number);
        }
        if (token instanceof LongLit) {
            long l = ((LongLit)token).number;
            if (l == Long.MIN_VALUE && n != -1) {
                throw new IllegalArgumentException("Illegal positive integer: " + l);
            }
            return Query.value((long)n * l);
        }
        if (bl) {
            throw new IllegalArgumentException("Expected number after + or -");
        }
        if (token == LPAR) {
            ValueExp valueExp = this.value();
            this.expect(RPAR);
            return valueExp;
        }
        if (token.equals(FALSE) || token.equals(TRUE)) {
            return Query.value(token.equals(TRUE));
        }
        if (token.equals(CLASS)) {
            return Query.classattr();
        }
        if (token instanceof StringLit) {
            return Query.value(token.string);
        }
        if (!(token instanceof Id) && !(token instanceof QuotedId)) {
            throw new IllegalArgumentException("Unexpected token " + token);
        }
        String string = this.name(token);
        if (this.skip(SHARP)) {
            Token token2 = this.current();
            this.next();
            String string2 = this.name(token2);
            return Query.attr(string, string2);
        }
        return Query.attr(string);
    }

    private String name(Token token) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (!(token instanceof Id) && !(token instanceof QuotedId)) {
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            stringBuilder.append(token.string);
            if (this.current() != DOT) break;
            stringBuilder.append('.');
            this.next();
            token = this.current();
            this.next();
        }
        return stringBuilder.toString();
    }

    private StringValueExp stringvalue() {
        Token token = this.current();
        this.next();
        if (!(token instanceof StringLit)) {
            throw new IllegalArgumentException("Expected string: " + token);
        }
        return Query.value(token.string);
    }

    static {
        for (Token token : new Token[]{NOT, INSTANCEOF, FALSE, TRUE, LIKE, CLASS}) {
            idKeywords.add(token.string);
        }
        relations = new Token[]{EQ, LT, GT, LE, GE, NE};
        betweenLikeIn = new Token[]{BETWEEN, LIKE, IN};
    }

    private static class Tokenizer {
        private final String s;
        private final int len;
        private int i = 0;

        Tokenizer(String string) {
            this.s = string;
            this.len = string.length();
        }

        private int thisChar() {
            if (this.i == this.len) {
                return -1;
            }
            return this.s.codePointAt(this.i);
        }

        private void advance() {
            this.i += Character.charCount(this.thisChar());
        }

        private int thisCharAdvance() {
            int n = this.thisChar();
            this.advance();
            return n;
        }

        Token nextToken() {
            int n;
            do {
                if (this.i != this.len) continue;
                return null;
            } while (Character.isWhitespace(n = this.thisCharAdvance()));
            switch (n) {
                case 40: {
                    return LPAR;
                }
                case 41: {
                    return RPAR;
                }
                case 44: {
                    return COMMA;
                }
                case 46: {
                    return DOT;
                }
                case 35: {
                    return SHARP;
                }
                case 42: {
                    return TIMES;
                }
                case 47: {
                    return DIVIDE;
                }
                case 61: {
                    return EQ;
                }
                case 45: {
                    return MINUS;
                }
                case 43: {
                    return PLUS;
                }
                case 62: {
                    if (this.thisChar() == 61) {
                        this.advance();
                        return GE;
                    }
                    return GT;
                }
                case 60: {
                    n = this.thisChar();
                    switch (n) {
                        case 61: {
                            this.advance();
                            return LE;
                        }
                        case 62: {
                            this.advance();
                            return NE;
                        }
                    }
                    return LT;
                }
                case 33: {
                    if (this.thisCharAdvance() != 61) {
                        throw new IllegalArgumentException("'!' must be followed by '='");
                    }
                    return NE;
                }
                case 34: 
                case 39: {
                    int n2 = n;
                    StringBuilder stringBuilder = new StringBuilder();
                    while (true) {
                        if ((n = this.thisChar()) != n2) {
                            if (n < 0) {
                                throw new IllegalArgumentException("Unterminated string constant");
                            }
                            stringBuilder.appendCodePoint(this.thisCharAdvance());
                            continue;
                        }
                        this.advance();
                        if (this.thisChar() != n2) break;
                        stringBuilder.appendCodePoint(n2);
                        this.advance();
                    }
                    if (n2 == 39) {
                        return new StringLit(stringBuilder.toString());
                    }
                    return new QuotedId(stringBuilder.toString());
                }
            }
            if (Character.isDigit(n) || n == 46) {
                StringBuilder stringBuilder = new StringBuilder();
                int n3 = -1;
                while (true) {
                    stringBuilder.appendCodePoint(n);
                    n = Character.toLowerCase(this.thisChar());
                    if (n == 43 || n == 45 ? n3 != 101 : !Character.isDigit(n) && n != 46 && n != 101) break;
                    n3 = n;
                    this.advance();
                }
                String string = stringBuilder.toString();
                if (string.indexOf(46) >= 0 || string.indexOf(101) >= 0) {
                    double d = QueryParser.parseDoubleCheckOverflow(string);
                    return new DoubleLit(d);
                }
                long l = -Long.parseLong("-" + string);
                return new LongLit(l);
            }
            if (!Character.isJavaIdentifierStart(n)) {
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder);
                formatter.format("Bad character: %c (%04x)", n, n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                stringBuilder.appendCodePoint(n);
                n = this.thisChar();
                if (!Character.isJavaIdentifierPart(n)) break;
                this.advance();
            }
            return new Id(stringBuilder.toString());
        }
    }

    private static class DoubleLit
    extends Token {
        double number;

        DoubleLit(double d) {
            super(Double.toString(d));
            this.number = d;
        }
    }

    private static class LongLit
    extends Token {
        long number;

        LongLit(long l) {
            super(Long.toString(l));
            this.number = l;
        }
    }

    private static class StringLit
    extends Token {
        StringLit(String string) {
            super(string);
        }

        @Override
        public String toString() {
            return '\'' + this.string.replace("'", "''") + '\'';
        }
    }

    private static class QuotedId
    extends Token {
        QuotedId(String string) {
            super(string);
        }

        @Override
        public String toString() {
            return '\"' + this.string.replace("\"", "\"\"") + '\"';
        }
    }

    private static class Id
    extends Token {
        Id(String string) {
            super(string);
        }

        public boolean equals(Object object) {
            return object instanceof Id && ((Id)object).toString().equalsIgnoreCase(this.toString());
        }
    }

    private static class Token {
        final String string;

        Token(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

