/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 8188218128353913216L;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n);
        }
        this.init(this.capacity(n));
    }

    private int capacity(int n) {
        int n2;
        int n3 = 3 * n / 2;
        if (n3 > 0x20000000 || n3 < 0) {
            n2 = 0x20000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    private void init(int n) {
        this.threshold = n * 2 / 3;
        this.table = new Object[2 * n];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n) {
        int n2 = System.identityHashCode(object);
        return (n2 << 1) - (n2 << 8) & n - 1;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 2 < n2 ? n + 2 : 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return (V)objectArray[n2 + 1];
    }

    @Override
    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        for (int i = 1; i < objectArray.length; i += 2) {
            if (objectArray[i] != object || objectArray[i - 1] == null) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        Object object4;
        while ((object4 = objectArray[n2]) != object3) {
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return objectArray[n2 + 1] == object2;
    }

    @Override
    public V put(K k, V v) {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while ((object = objectArray[n2]) != null) {
            if (object == object2) {
                Object object3 = objectArray[n2 + 1];
                objectArray[n2 + 1] = v;
                return (V)object3;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        ++this.modCount;
        objectArray[n2] = object2;
        objectArray[n2 + 1] = v;
        if (++this.size >= this.threshold) {
            this.resize(n);
        }
        return null;
    }

    private void resize(int n) {
        int n2 = n * 2;
        Object[] objectArray = this.table;
        int n3 = objectArray.length;
        if (n3 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n3 >= n2) {
            return;
        }
        Object[] objectArray2 = new Object[n2];
        this.threshold = n2 / 3;
        for (int i = 0; i < n3; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = objectArray[i + 1];
            objectArray[i] = null;
            objectArray[i + 1] = null;
            int n4 = IdentityHashMap.hash(object, n2);
            while (objectArray2[n4] != null) {
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
            objectArray2[n4] = object;
            objectArray2[n4 + 1] = object2;
        }
        this.table = objectArray2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while (true) {
            Object object3;
            if ((object3 = objectArray[n2]) == object2) {
                ++this.modCount;
                --this.size;
                Object object4 = objectArray[n2 + 1];
                objectArray[n2 + 1] = null;
                objectArray[n2] = null;
                this.closeDeletion(n2);
                return (V)object4;
            }
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        while (true) {
            Object object4;
            if ((object4 = objectArray[n2]) == object3) {
                if (objectArray[n2 + 1] != object2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                objectArray[n2] = null;
                objectArray[n2 + 1] = null;
                this.closeDeletion(n2);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private void closeDeletion(int n) {
        Object object;
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.nextKeyIndex(n, n2);
        while ((object = objectArray[n3]) != null) {
            int n4 = IdentityHashMap.hash(object, n2);
            if (n3 < n4 && (n4 <= n || n <= n3) || n4 <= n && n <= n3) {
                objectArray[n] = object;
                objectArray[n + 1] = objectArray[n3 + 1];
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                n = n3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)object;
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object2 = objectArray[i];
                if (object2 == null || this.containsMapping(object2, objectArray[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = IdentityHashMap.unmaskNull(object);
            n += System.identityHashCode(object2) ^ System.identityHashCode(objectArray[i + 1]);
        }
        return n;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])this.table.clone();
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
            objectOutputStream.writeObject(objectArray[i + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.init(this.capacity(n * 4 / 3));
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    private void putForCreate(K k, V v) throws IOException {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while ((object = objectArray[n2]) != null) {
            if (object == object2) {
                throw new StreamCorruptedException();
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        objectArray[n2] = object2;
        objectArray[n2 + 1] = v;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[n];
            Iterator iterator = this.iterator();
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new AbstractMap.SimpleEntry(iterator.next());
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            Iterator iterator = this.iterator();
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new AbstractMap.SimpleEntry(iterator.next());
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return IdentityHashMap.this.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return IdentityHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = IdentityHashMap.this.size;
            IdentityHashMap.this.remove(object);
            return IdentityHashMap.this.size != n;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (Object k : this) {
                n += System.identityHashCode(k);
            }
            return n;
        }
    }

    private class EntryIterator
    extends IdentityHashMapIterator<Map.Entry<K, V>>
    implements Map.Entry<K, V> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextIndex();
            return this;
        }

        @Override
        public K getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return IdentityHashMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        @Override
        public V getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        @Override
        public V setValue(V v) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object object = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = v;
            if (this.traversalTable != IdentityHashMap.this.table) {
                IdentityHashMap.this.put(this.traversalTable[this.lastReturnedIndex], v);
            }
            return object;
        }

        @Override
        public boolean equals(Object object) {
            if (this.lastReturnedIndex < 0) {
                return super.equals(object);
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return entry.getKey() == this.getKey() && entry.getValue() == this.getValue();
        }

        @Override
        public int hashCode() {
            if (this.lastReturnedIndex < 0) {
                return super.hashCode();
            }
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        public String toString() {
            if (this.lastReturnedIndex < 0) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class ValueIterator
    extends IdentityHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class KeyIterator
    extends IdentityHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return IdentityHashMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private abstract class IdentityHashMapIterator<T>
    implements Iterator<T> {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] objectArray = this.traversalTable;
            for (int i = this.index; i < objectArray.length; i += 2) {
                Object object = objectArray[i];
                if (object == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = objectArray.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object object;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int n = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            this.index = n;
            this.indexValid = false;
            Object[] objectArray = this.traversalTable;
            int n2 = objectArray.length;
            int n3 = n;
            Object object2 = objectArray[n3];
            objectArray[n3] = null;
            objectArray[n3 + 1] = null;
            if (objectArray != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(object2);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            IdentityHashMap.this.size--;
            int n4 = IdentityHashMap.nextKeyIndex(n3, n2);
            while ((object = objectArray[n4]) != null) {
                int n5 = IdentityHashMap.hash(object, n2);
                if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                    if (n4 < n && n3 >= n && this.traversalTable == IdentityHashMap.this.table) {
                        int n6 = n2 - n;
                        Object[] objectArray2 = new Object[n6];
                        System.arraycopy(objectArray, n, objectArray2, 0, n6);
                        this.traversalTable = objectArray2;
                        this.index = 0;
                    }
                    objectArray[n3] = object;
                    objectArray[n3 + 1] = objectArray[n4 + 1];
                    objectArray[n4] = null;
                    objectArray[n4 + 1] = null;
                    n3 = n4;
                }
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
        }
    }
}

