/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class SimpleFileVisitor<T>
implements FileVisitor<T> {
    protected SimpleFileVisitor() {
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public FileVisitResult preVisitDirectory(T t) {
        SimpleFileVisitor.checkNotNull(t);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectoryFailed(T t, IOException iOException) {
        SimpleFileVisitor.checkNotNull(t);
        SimpleFileVisitor.checkNotNull(iOException);
        throw new IOError(iOException);
    }

    @Override
    public FileVisitResult visitFile(T t, BasicFileAttributes basicFileAttributes) {
        SimpleFileVisitor.checkNotNull(t);
        SimpleFileVisitor.checkNotNull(basicFileAttributes);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(T t, IOException iOException) {
        SimpleFileVisitor.checkNotNull(t);
        SimpleFileVisitor.checkNotNull(iOException);
        throw new IOError(iOException);
    }

    @Override
    public FileVisitResult postVisitDirectory(T t, IOException iOException) {
        SimpleFileVisitor.checkNotNull(t);
        if (iOException != null) {
            throw new IOError(iOException);
        }
        return FileVisitResult.CONTINUE;
    }
}

