/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.util.Arrays;
import sun.java2d.pipe.RenderingEngine;

public class BasicStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    float width;
    int join;
    int cap;
    float miterlimit;
    float[] dash;
    float dash_phase;

    public BasicStroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (n2 == 0) {
            if (f2 < 1.0f) {
                throw new IllegalArgumentException("miter limit < 1");
            }
        } else if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (fArray != null) {
            if (f3 < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean bl = true;
            for (int i = 0; i < fArray.length; ++i) {
                float f4 = fArray[i];
                if ((double)f4 > 0.0) {
                    bl = false;
                    continue;
                }
                if (!((double)f4 < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (bl) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = f;
        this.cap = n;
        this.join = n2;
        this.miterlimit = f2;
        if (fArray != null) {
            this.dash = (float[])fArray.clone();
        }
        this.dash_phase = f3;
    }

    public BasicStroke(float f, int n, int n2, float f2) {
        this(f, n, n2, f2, null, 0.0f);
    }

    public BasicStroke(float f, int n, int n2) {
        this(f, n, n2, 10.0f, null, 0.0f);
    }

    public BasicStroke(float f) {
        this(f, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        RenderingEngine renderingEngine = RenderingEngine.getInstance();
        return renderingEngine.createStrokedShape(shape, this.width, this.cap, this.join, this.miterlimit, this.dash, this.dash_phase);
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miterlimit;
    }

    public float[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.width);
        n = n * 31 + this.join;
        n = n * 31 + this.cap;
        n = n * 31 + Float.floatToIntBits(this.miterlimit);
        if (this.dash != null) {
            n = n * 31 + Float.floatToIntBits(this.dash_phase);
            for (int i = 0; i < this.dash.length; ++i) {
                n = n * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicStroke)) {
            return false;
        }
        BasicStroke basicStroke = (BasicStroke)object;
        if (this.width != basicStroke.width) {
            return false;
        }
        if (this.join != basicStroke.join) {
            return false;
        }
        if (this.cap != basicStroke.cap) {
            return false;
        }
        if (this.miterlimit != basicStroke.miterlimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dash_phase != basicStroke.dash_phase) {
                return false;
            }
            if (!Arrays.equals(this.dash, basicStroke.dash)) {
                return false;
            }
        } else if (basicStroke.dash != null) {
            return false;
        }
        return true;
    }
}

