/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.soap;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.message.DOMHeader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;

abstract class MUTube
extends AbstractFilterTubeImpl {
    private static final String MU_FAULT_DETAIL_LOCALPART = "NotUnderstood";
    private static final QName MU_HEADER_DETAIL = new QName(SOAPVersion.SOAP_12.nsUri, "NotUnderstood");
    protected static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.soap.decoder");
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "One or more mandatory SOAP header blocks not understood";
    protected final SOAPVersion soapVersion;
    private final AddressingVersion addressingVersion;

    protected MUTube(WSBinding binding, Tube next) {
        super(next);
        if (!(binding instanceof SOAPBinding)) {
            throw new WebServiceException("MUPipe should n't be used for bindings other than SOAP.");
        }
        this.soapVersion = binding.getSOAPVersion();
        this.addressingVersion = binding.getAddressingVersion();
    }

    protected MUTube(MUTube that, TubeCloner cloner) {
        super(that, cloner);
        this.soapVersion = that.soapVersion;
        this.addressingVersion = that.addressingVersion;
    }

    protected final Set<QName> getMisUnderstoodHeaders(HeaderList headers, Set<String> roles, Set<QName> knownHeaders) {
        HashSet<QName> notUnderstoodHeaders = null;
        this.understandAddressingHeaders(knownHeaders);
        for (int i = 0; i < headers.size(); ++i) {
            QName qName;
            Header header;
            if (headers.isUnderstood(i) || (header = headers.get(i)).isIgnorable(this.soapVersion, roles) || knownHeaders.contains(qName = new QName(header.getNamespaceURI(), header.getLocalPart()))) continue;
            logger.info("Element not understood=" + qName);
            if (notUnderstoodHeaders == null) {
                notUnderstoodHeaders = new HashSet<QName>();
            }
            notUnderstoodHeaders.add(qName);
        }
        return notUnderstoodHeaders;
    }

    private void understandAddressingHeaders(Set<QName> knownHeaders) {
        if (this.addressingVersion != null) {
            knownHeaders.add(this.addressingVersion.actionTag);
            knownHeaders.add(this.addressingVersion.faultToTag);
            knownHeaders.add(this.addressingVersion.fromTag);
            knownHeaders.add(this.addressingVersion.messageIDTag);
            knownHeaders.add(this.addressingVersion.relatesToTag);
            knownHeaders.add(this.addressingVersion.replyToTag);
            knownHeaders.add(this.addressingVersion.toTag);
        }
    }

    final SOAPFaultException createMUSOAPFaultException(Set<QName> notUnderstoodHeaders) {
        try {
            SOAPFault fault = this.createMUSOAPFault();
            this.setMUFaultString(fault, notUnderstoodHeaders);
            return new SOAPFaultException(fault);
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
    }

    final Message createMUSOAPFaultMessage(Set<QName> notUnderstoodHeaders) {
        try {
            SOAPFault fault = this.createMUSOAPFault();
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                this.setMUFaultString(fault, notUnderstoodHeaders);
            }
            Message muFaultMessage = Messages.create(fault);
            if (this.soapVersion == SOAPVersion.SOAP_12) {
                MUTube.addHeader(muFaultMessage, notUnderstoodHeaders);
            }
            return muFaultMessage;
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
    }

    private void setMUFaultString(SOAPFault fault, Set<QName> notUnderstoodHeaders) throws SOAPException {
        fault.setFaultString("MustUnderstand headers:" + notUnderstoodHeaders + " are not understood");
    }

    private static void addHeader(Message m, Set<QName> notUnderstoodHeaders) throws SOAPException {
        for (QName qname : notUnderstoodHeaders) {
            SOAPElement soapEl = SOAPVersion.SOAP_12.saajSoapFactory.createElement(MU_HEADER_DETAIL);
            soapEl.addNamespaceDeclaration("abc", qname.getNamespaceURI());
            soapEl.setAttribute("qname", "abc:" + qname.getLocalPart());
            DOMHeader<SOAPElement> header = new DOMHeader<SOAPElement>(soapEl);
            m.getHeaders().add(header);
        }
    }

    private SOAPFault createMUSOAPFault() throws SOAPException {
        return this.soapVersion.saajSoapFactory.createFault(MUST_UNDERSTAND_FAULT_MESSAGE_STRING, this.soapVersion.faultCodeMustUnderstand);
    }
}

