/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.LogicalMessageContextImpl;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.handler.XMLHandlerProcessor;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;

public class ServerLogicalHandlerTube
extends HandlerTube {
    private WSBinding binding;

    public ServerLogicalHandlerTube(WSBinding binding, WSDLPort port, Tube next) {
        super(next, port);
        this.binding = binding;
        this.setUpHandlersOnce();
    }

    public ServerLogicalHandlerTube(WSBinding binding, Tube next, HandlerTube cousinTube) {
        super(next, cousinTube);
        this.binding = binding;
        this.setUpHandlersOnce();
    }

    private ServerLogicalHandlerTube(ServerLogicalHandlerTube that, TubeCloner cloner) {
        super(that, cloner);
        this.binding = that.binding;
        this.handlers = that.handlers;
    }

    @Override
    protected void initiateClosing(MessageContext mc) {
        if (this.binding.getSOAPVersion() != null) {
            super.initiateClosing(mc);
        } else {
            this.close(mc);
            super.initiateClosing(mc);
        }
    }

    @Override
    public AbstractFilterTubeImpl copy(TubeCloner cloner) {
        return new ServerLogicalHandlerTube(this, cloner);
    }

    private void setUpHandlersOnce() {
        this.handlers = new ArrayList();
        List<LogicalHandler> logicalSnapShot = ((BindingImpl)this.binding).getHandlerConfig().getLogicalHandlers();
        if (!logicalSnapShot.isEmpty()) {
            this.handlers.addAll(logicalSnapShot);
        }
    }

    @Override
    void setUpProcessor() {
        if (!this.handlers.isEmpty()) {
            this.processor = this.binding.getSOAPVersion() == null ? new XMLHandlerProcessor(this, this.binding, this.handlers) : new SOAPHandlerProcessor(false, this, this.binding, this.handlers);
        }
    }

    @Override
    MessageUpdatableContext getContext(Packet packet) {
        return new LogicalMessageContextImpl(this.binding, packet);
    }

    @Override
    boolean callHandlersOnRequest(MessageUpdatableContext context, boolean isOneWay) {
        boolean handlerResult;
        try {
            handlerResult = this.processor.callHandlersRequest(HandlerProcessor.Direction.INBOUND, context, !isOneWay);
        }
        catch (RuntimeException re) {
            this.remedyActionTaken = true;
            throw re;
        }
        if (!handlerResult) {
            this.remedyActionTaken = true;
        }
        return handlerResult;
    }

    @Override
    void callHandlersOnResponse(MessageUpdatableContext context, boolean handleFault) {
        Map atts = (Map)context.get("javax.xml.ws.binding.attachments.outbound");
        AttachmentSet attSet = this.packet.getMessage().getAttachments();
        for (String cid : atts.keySet()) {
            DataHandlerAttachment att = new DataHandlerAttachment(cid, (DataHandler)atts.get(cid));
            attSet.add(att);
        }
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.OUTBOUND, context, handleFault);
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (RuntimeException re) {
            throw re;
        }
    }

    @Override
    void closeHandlers(MessageContext mc) {
        this.closeServersideHandlers(mc);
    }
}

