/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.handler.LogicalMessageImpl;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.message.EmptyMessageImpl;
import com.sun.xml.internal.ws.message.source.PayloadSourceMessage;
import javax.xml.transform.Source;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.handler.LogicalMessageContext;

class LogicalMessageContextImpl
extends MessageUpdatableContext
implements LogicalMessageContext {
    private LogicalMessageImpl lm;
    private WSBinding binding;

    public LogicalMessageContextImpl(WSBinding binding, Packet packet) {
        super(packet);
        this.binding = binding;
    }

    @Override
    public LogicalMessage getMessage() {
        if (this.lm == null) {
            this.lm = new LogicalMessageImpl(this.packet);
        }
        return this.lm;
    }

    @Override
    void setPacketMessage(Message newMessage) {
        if (newMessage != null) {
            this.packet.setMessage(newMessage);
            this.lm = null;
        }
    }

    @Override
    protected void updateMessage() {
        if (this.lm != null) {
            if (this.lm.isPayloadModifed()) {
                Message msg = this.packet.getMessage();
                HeaderList headers = msg.getHeaders();
                AttachmentSet attachments = msg.getAttachments();
                Source modifiedPayload = this.lm.getModifiedPayload();
                if (modifiedPayload == null) {
                    this.packet.setMessage(new EmptyMessageImpl(headers, attachments, this.binding.getSOAPVersion()));
                } else {
                    this.packet.setMessage(new PayloadSourceMessage(headers, modifiedPayload, attachments, this.binding.getSOAPVersion()));
                }
            }
            this.lm = null;
        }
    }
}

