/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Description;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ManagedOperation;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.MXBeanMappingFactory;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;

class MXBeanIntrospector
extends MBeanIntrospector<ConvertingMethod> {
    private static final Map<MXBeanMappingFactory, WeakReference<MXBeanIntrospector>> map = new WeakHashMap<MXBeanMappingFactory, WeakReference<MXBeanIntrospector>>();
    private final MBeanIntrospector.PerInterfaceMap<ConvertingMethod> perInterfaceMap = new MBeanIntrospector.PerInterfaceMap();
    private final MBeanIntrospector.MBeanInfoMap mbeanInfoMap = new MBeanIntrospector.MBeanInfoMap();
    private final MXBeanMappingFactory mappingFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MXBeanIntrospector getInstance(MXBeanMappingFactory mXBeanMappingFactory) {
        if (mXBeanMappingFactory == null) {
            mXBeanMappingFactory = MXBeanMappingFactory.DEFAULT;
        }
        Map<MXBeanMappingFactory, WeakReference<MXBeanIntrospector>> map = MXBeanIntrospector.map;
        synchronized (map) {
            MXBeanIntrospector mXBeanIntrospector;
            WeakReference<MXBeanIntrospector> weakReference = MXBeanIntrospector.map.get(mXBeanMappingFactory);
            if (weakReference != null && (mXBeanIntrospector = (MXBeanIntrospector)weakReference.get()) != null) {
                return mXBeanIntrospector;
            }
            mXBeanIntrospector = new MXBeanIntrospector(mXBeanMappingFactory);
            weakReference = new WeakReference<MXBeanIntrospector>(mXBeanIntrospector);
            MXBeanIntrospector.map.put(mXBeanMappingFactory, weakReference);
            return mXBeanIntrospector;
        }
    }

    private MXBeanIntrospector(MXBeanMappingFactory mXBeanMappingFactory) {
        this.mappingFactory = mXBeanMappingFactory;
    }

    @Override
    MBeanIntrospector.PerInterfaceMap<ConvertingMethod> getPerInterfaceMap() {
        return this.perInterfaceMap;
    }

    @Override
    MBeanIntrospector.MBeanInfoMap getMBeanInfoMap() {
        return this.mbeanInfoMap;
    }

    @Override
    MBeanAnalyzer<ConvertingMethod> getAnalyzer(Class<?> clazz) throws NotCompliantMBeanException {
        return MBeanAnalyzer.analyzer(clazz, this);
    }

    @Override
    boolean isMXBean() {
        return true;
    }

    @Override
    ConvertingMethod mFrom(Method method) {
        return ConvertingMethod.from(method, this.mappingFactory);
    }

    @Override
    String getName(ConvertingMethod convertingMethod) {
        return convertingMethod.getName();
    }

    @Override
    Type getGenericReturnType(ConvertingMethod convertingMethod) {
        return convertingMethod.getGenericReturnType();
    }

    @Override
    Type[] getGenericParameterTypes(ConvertingMethod convertingMethod) {
        return convertingMethod.getGenericParameterTypes();
    }

    @Override
    String[] getSignature(ConvertingMethod convertingMethod) {
        return convertingMethod.getOpenSignature();
    }

    @Override
    void checkMethod(ConvertingMethod convertingMethod) {
        convertingMethod.checkCallFromOpen();
    }

    @Override
    Object invokeM2(ConvertingMethod convertingMethod, Object object, Object[] objectArray, Object object2) throws InvocationTargetException, IllegalAccessException, MBeanException {
        return convertingMethod.invokeWithOpenReturn((MXBeanLookup)object2, object, objectArray);
    }

    @Override
    boolean validParameter(ConvertingMethod convertingMethod, Object object, int n, Object object2) {
        Object object3;
        if (object == null) {
            Type type = convertingMethod.getGenericParameterTypes()[n];
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        try {
            object3 = convertingMethod.fromOpenParameter((MXBeanLookup)object2, object, n);
        }
        catch (Exception exception) {
            return true;
        }
        return MXBeanIntrospector.isValidParameter(convertingMethod.getMethod(), object3, n);
    }

    @Override
    MBeanAttributeInfo getMBeanAttributeInfo(String string, ConvertingMethod convertingMethod, ConvertingMethod convertingMethod2) throws IntrospectionException {
        Type type;
        OpenType<?> openType;
        boolean bl = convertingMethod != null;
        boolean bl2 = convertingMethod2 != null;
        boolean bl3 = bl && this.getName(convertingMethod).startsWith("is");
        String string2 = this.getAttributeDescription(string, string, convertingMethod == null ? null : convertingMethod.getMethod(), convertingMethod2 == null ? null : convertingMethod2.getMethod());
        if (bl) {
            openType = convertingMethod.getOpenReturnType();
            type = convertingMethod.getGenericReturnType();
        } else {
            openType = convertingMethod2.getOpenParameterTypes()[0];
            type = convertingMethod2.getGenericParameterTypes()[0];
        }
        Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType, type);
        if (bl) {
            descriptor = ImmutableDescriptor.union(descriptor, convertingMethod.getDescriptor());
        }
        if (bl2) {
            descriptor = ImmutableDescriptor.union(descriptor, convertingMethod2.getDescriptor());
        }
        MBeanAttributeInfo mBeanAttributeInfo = MXBeanIntrospector.canUseOpenInfo(type) ? new OpenMBeanAttributeInfoSupport(string, string2, openType, bl, bl2, bl3, descriptor) : new MBeanAttributeInfo(string, MXBeanIntrospector.originalTypeString(type), string2, bl, bl2, bl3, descriptor);
        return mBeanAttributeInfo;
    }

    @Override
    MBeanOperationInfo getMBeanOperationInfo(String string, ConvertingMethod convertingMethod) {
        OpenMBeanParameterInfo[] openMBeanParameterInfoArray;
        Object object;
        Method method = convertingMethod.getMethod();
        String string2 = string;
        Description description = method.getAnnotation(Description.class);
        if (description != null) {
            string2 = description.value();
        }
        int n = 3;
        ManagedOperation managedOperation = method.getAnnotation(ManagedOperation.class);
        if (managedOperation != null) {
            n = managedOperation.impact().getCode();
        }
        OpenType<?> openType = convertingMethod.getOpenReturnType();
        Type type = convertingMethod.getGenericReturnType();
        OpenType<?>[] openTypeArray = convertingMethod.getOpenParameterTypes();
        Type[] typeArray = convertingMethod.getGenericParameterTypes();
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[openTypeArray.length];
        boolean bl = MXBeanIntrospector.canUseOpenInfo(type);
        boolean bl2 = true;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        for (int i = 0; i < openTypeArray.length; ++i) {
            MBeanParameterInfo mBeanParameterInfo;
            object = Introspector.nameForParameter(annotationArray[i]);
            if (object == null) {
                object = "p" + i;
            }
            if ((openMBeanParameterInfoArray = Introspector.descriptionForParameter(annotationArray[i])) == null) {
                openMBeanParameterInfoArray = object;
            }
            OpenType<?> openType2 = openTypeArray[i];
            Type type2 = typeArray[i];
            Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType2, type2);
            descriptor = ImmutableDescriptor.union(descriptor, Introspector.descriptorForAnnotations(annotationArray[i]));
            if (MXBeanIntrospector.canUseOpenInfo(type2)) {
                mBeanParameterInfo = new OpenMBeanParameterInfoSupport((String)object, (String)openMBeanParameterInfoArray, openType2, descriptor);
            } else {
                bl2 = false;
                mBeanParameterInfo = new MBeanParameterInfo((String)object, MXBeanIntrospector.originalTypeString(type2), (String)openMBeanParameterInfoArray, descriptor);
            }
            mBeanParameterInfoArray[i] = mBeanParameterInfo;
        }
        Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType, type);
        descriptor = ImmutableDescriptor.union(descriptor, Introspector.descriptorForElement(method, false));
        if (bl && bl2) {
            openMBeanParameterInfoArray = new OpenMBeanParameterInfo[mBeanParameterInfoArray.length];
            System.arraycopy(mBeanParameterInfoArray, 0, openMBeanParameterInfoArray, 0, mBeanParameterInfoArray.length);
            object = new OpenMBeanOperationInfoSupport(string, string2, openMBeanParameterInfoArray, openType, n, descriptor);
        } else {
            object = new MBeanOperationInfo(string, string2, mBeanParameterInfoArray, bl ? openType.getClassName() : MXBeanIntrospector.originalTypeString(type), n, descriptor);
        }
        return object;
    }

    @Override
    Descriptor getBasicMBeanDescriptor() {
        return new ImmutableDescriptor("mxbean=true", "immutableInfo=true");
    }

    @Override
    Descriptor getMBeanDescriptor(Class<?> clazz) {
        return ImmutableDescriptor.EMPTY_DESCRIPTOR;
    }

    @Override
    Descriptor getSpecificMBeanDescriptor() {
        if (this.mappingFactory == MXBeanMappingFactory.DEFAULT) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        return new ImmutableDescriptor("mxbeanMappingFactoryClass=" + this.mappingFactory.getClass().getName());
    }

    private static Descriptor typeDescriptor(OpenType<?> openType, Type type) {
        return new ImmutableDescriptor(new String[]{"openType", "originalType"}, new Object[]{openType, MXBeanIntrospector.originalTypeString(type)});
    }

    private static boolean canUseOpenInfo(Type type) {
        if (type instanceof GenericArrayType) {
            return MXBeanIntrospector.canUseOpenInfo(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return MXBeanIntrospector.canUseOpenInfo(((Class)type).getComponentType());
        }
        return !(type instanceof Class) || !((Class)type).isPrimitive();
    }

    private static String originalTypeString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return MXBeanIntrospector.typeName(type);
    }

    static String typeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return MXBeanIntrospector.typeName(clazz.getComponentType()) + "[]";
            }
            return clazz.getName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return MXBeanIntrospector.typeName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MXBeanIntrospector.typeName(parameterizedType.getRawType())).append("<");
            String string = "";
            for (Type type2 : parameterizedType.getActualTypeArguments()) {
                stringBuilder.append(string).append(MXBeanIntrospector.typeName(type2));
                string = ", ";
            }
            return stringBuilder.append(">").toString();
        }
        return "???";
    }
}

