/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.Big5;
import sun.nio.cs.ext.ExtendedCharsets;

public class Big5_Solaris
extends Charset
implements HistoricallyNamedCharset {
    public Big5_Solaris() {
        super("x-Big5-Solaris", ExtendedCharsets.aliasesFor("x-Big5-Solaris"));
    }

    @Override
    public String historicalName() {
        return "Big5_Solaris";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof Big5 || charset instanceof Big5_Solaris;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends Big5.Encoder {
        @Override
        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            if (n == 0) {
                switch (c) {
                    case '\u7881': {
                        n = 63958;
                        break;
                    }
                    case '\u92b9': {
                        n = 63959;
                        break;
                    }
                    case '\u88cf': {
                        n = 63960;
                        break;
                    }
                    case '\u58bb': {
                        n = 63961;
                        break;
                    }
                    case '\u6052': {
                        n = 63962;
                        break;
                    }
                    case '\u7ca7': {
                        n = 63963;
                        break;
                    }
                    case '\u5afa': {
                        n = 63964;
                    }
                }
            }
            return n;
        }

        private Encoder(Charset charset) {
            super(charset);
        }
    }

    private static class Decoder
    extends Big5.Decoder {
        @Override
        protected char decodeDouble(int n, int n2) {
            int n3 = super.decodeDouble(n, n2);
            if (n3 == 65533 && n == 249) {
                switch (n2) {
                    case 214: {
                        n3 = 30849;
                        break;
                    }
                    case 215: {
                        n3 = 37561;
                        break;
                    }
                    case 216: {
                        n3 = 35023;
                        break;
                    }
                    case 217: {
                        n3 = 22715;
                        break;
                    }
                    case 218: {
                        n3 = 24658;
                        break;
                    }
                    case 219: {
                        n3 = 31911;
                        break;
                    }
                    case 220: {
                        n3 = 23290;
                    }
                }
            }
            return (char)n3;
        }

        private Decoder(Charset charset) {
            super(charset);
        }
    }
}

