/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<PluginInformation> availablePlugins;

    protected void init(Collection<String> sites) {
        this.sites = sites;
        if (sites == null) {
            this.sites = Collections.emptySet();
        }
        this.availablePlugins = new LinkedList<PluginInformation>();
    }

    public ReadRemotePluginInformationTask(Collection<String> sites) {
        super(I18n.tr("Download plugin list..."), false);
        this.init(sites);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor monitor, Collection<String> sites) {
        super(I18n.tr("Download plugin list..."), monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        this.init(sites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File pluginDir, String site, CacheType type) {
        String name;
        try {
            URL url = new URL(site);
            StringBuilder sb = new StringBuilder();
            sb.append("site-");
            sb.append(url.getHost()).append("-");
            if (url.getPort() != -1) {
                sb.append(url.getPort()).append("-");
            }
            String path = url.getPath();
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append("_");
            }
            switch (type) {
                case PLUGIN_LIST: {
                    sb.append(".txt");
                    break;
                }
                case ICON_LIST: {
                    sb.append("-icons.zip");
                }
            }
            name = sb.toString();
        }
        catch (MalformedURLException e) {
            name = "site-unknown.txt";
        }
        return new File(pluginDir, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String downloadPluginList(String site, ProgressMonitor monitor) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", site));
            URL url = new URL(site);
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", url.getHost());
                this.connection.setRequestProperty("Accept-Charset", "utf-8");
            }
            in = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (MalformedURLException e) {
            if (this.canceled) {
                String string = null;
                return string;
            }
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (IOException e) {
            if (this.canceled) {
                String string = null;
                return string;
            }
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            monitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadPluginIcons(String site, File destFile, ProgressMonitor monitor) {
        InputStream in = null;
        FileOutputStream out = null;
        System.err.println("icons site: " + site);
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", site));
            URL url = new URL(site);
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", url.getHost());
            }
            in = this.connection.getInputStream();
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int read = in.read(buffer);
            while (read != -1) {
                ((OutputStream)out).write(buffer, 0, read);
                read = in.read(buffer);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (MalformedURLException e) {
            if (this.canceled) {
                return;
            }
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            e.printStackTrace();
            return;
        }
        finally {
            ReadRemotePluginInformationTask buffer = this;
            synchronized (buffer) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            monitor.finishTask();
        }
        for (PluginInformation pi : this.availablePlugins) {
            if (pi.icon != null || pi.iconPath == null) continue;
            pi.icon = ImageProvider.getIfAvailable(null, null, null, pi.name + ".jar/" + pi.iconPath, destFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePluginList(String site, String list) {
        PrintWriter writer = null;
        try {
            File pluginDir = Main.pref.getPluginsDirectory();
            if (!pluginDir.exists() && !pluginDir.mkdirs()) {
                System.err.println(I18n.tr("Warning: failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", pluginDir.toString(), site));
            }
            File cacheFile = this.createSiteCacheFile(pluginDir, site, CacheType.PLUGIN_LIST);
            this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", cacheFile.toString()));
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "utf-8"));
            writer.write(list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> plugins) {
        ArrayList<PluginInformation> ret = new ArrayList<PluginInformation>(plugins.size());
        HashSet<String> deprecatedPluginNames = new HashSet<String>(Arrays.asList(PluginHandler.DEPRECATED_PLUGINS));
        for (PluginInformation plugin : plugins) {
            if (deprecatedPluginNames.contains(plugin.name)) continue;
            ret.add(plugin);
        }
        return ret;
    }

    protected void parsePluginListDocument(String site, String doc) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", site));
            ByteArrayInputStream in = new ByteArrayInputStream(doc.getBytes("UTF-8"));
            List<PluginInformation> pis = new PluginListParser().parse(in);
            this.availablePlugins.addAll(this.filterDeprecatedPlugins(pis));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", site, e.toString()));
            e.printStackTrace();
        }
        catch (PluginListParseException e) {
            System.err.println(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", site, e.toString()));
            e.printStackTrace();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File pluginDir = Main.pref.getPluginsDirectory();
        LinkedList<File> siteCacheFiles = new LinkedList<File>();
        for (String location : PluginInformation.getPluginLocations()) {
            File[] f = new File(location).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches("^([0-9]+-)?site.*\\.txt$") || name.matches("^([0-9]+-)?site.*-icons\\.zip$");
                }
            });
            if (f == null || f.length <= 0) continue;
            siteCacheFiles.addAll(Arrays.asList(f));
        }
        for (String site : this.sites) {
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", site));
            String list = this.downloadPluginList(site, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            siteCacheFiles.remove(this.createSiteCacheFile(pluginDir, site, CacheType.PLUGIN_LIST));
            siteCacheFiles.remove(this.createSiteCacheFile(pluginDir, site, CacheType.ICON_LIST));
            if (list != null) {
                this.getProgressMonitor().worked(1);
                this.cachePluginList(site, list);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                this.parsePluginListDocument(site, list);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
            }
            this.downloadPluginIcons(site + "-icons.zip", this.createSiteCacheFile(pluginDir, site, CacheType.ICON_LIST), this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        for (File file : siteCacheFiles) {
            file.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailabePlugins() {
        return this.availablePlugins;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CacheType {
        PLUGIN_LIST,
        ICON_LIST;

    }
}

