/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OsmServerUserInfoReader
extends OsmServerReader {
    protected static String getAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    public static UserInfo buildFromXML(Document document) throws OsmDataParsingException {
        try {
            NodeList xmlNodeList;
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            UserInfo userInfo = new UserInfo();
            Node xmlNode = (Node)xpath.compile("/osm/user[1]").evaluate(document, XPathConstants.NODE);
            if (xmlNode == null) {
                throw new OsmDataParsingException(I18n.tr("XML tag <user> is missing."));
            }
            String v = OsmServerUserInfoReader.getAttribute(xmlNode, "id");
            if (v == null) {
                throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "id", "user"));
            }
            try {
                userInfo.setId(Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "id", "user", v));
            }
            v = OsmServerUserInfoReader.getAttribute(xmlNode, "display_name");
            userInfo.setDisplayName(v);
            v = OsmServerUserInfoReader.getAttribute(xmlNode, "account_created");
            if (v != null) {
                userInfo.setAccountCreated(DateUtils.fromString(v));
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/description[1]/text()").evaluate(document, XPathConstants.NODE)) != null) {
                userInfo.setDescription(xmlNode.getNodeValue());
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/home").evaluate(document, XPathConstants.NODE)) != null) {
                int zoom;
                double lon;
                double lat;
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "lat");
                if (v == null) {
                    throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lat", "home"));
                }
                try {
                    lat = Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lat", "home", v));
                }
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "lon");
                if (v == null) {
                    throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lon", "home"));
                }
                try {
                    lon = Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lon", "home", v));
                }
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "zoom");
                if (v == null) {
                    throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "zoom", "home"));
                }
                try {
                    zoom = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "zoom", "home", v));
                }
                userInfo.setHome(new LatLon(lat, lon));
                userInfo.setHomeZoom(zoom);
            }
            if ((xmlNodeList = (NodeList)xpath.compile("/osm/user[1]/languages[1]/lang").evaluate(document, XPathConstants.NODESET)) != null) {
                LinkedList<String> languages = new LinkedList<String>();
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    languages.add(xmlNodeList.item(i).getNodeValue());
                }
                userInfo.setLanguages(languages);
            }
            return userInfo;
        }
        catch (XPathException e) {
            throw new OsmDataParsingException(e);
        }
    }

    public OsmServerUserInfoReader() {
        this.setDoAuthenticate(true);
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public UserInfo fetchUserInfo(ProgressMonitor monitor) throws OsmTransferException {
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Reading user info ..."));
            InputStream in = this.getInputStream("user/details", monitor.createSubTaskMonitor(1, true));
            UserInfo userInfo = OsmServerUserInfoReader.buildFromXML(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in));
            return userInfo;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }
}

