/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResultProcessor {
    private Map<PrimitiveId, DiffResultEntry> diffResults = new HashMap<PrimitiveId, DiffResultEntry>();
    private Set<OsmPrimitive> processed;
    private Collection<OsmPrimitive> primitives;

    public DiffResultProcessor(Collection<OsmPrimitive> primitives) {
        if (primitives == null) {
            primitives = Collections.emptyList();
        }
        this.primitives = primitives;
        this.processed = new HashSet<OsmPrimitive>();
    }

    public void parse(String diffUploadResponse, ProgressMonitor progressMonitor) throws OsmDataParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(diffUploadResponse, "diffUploadResponse");
        try {
            progressMonitor.beginTask(I18n.tr("Parsing response from server..."));
            InputSource inputSource = new InputSource(new StringReader(diffUploadResponse));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new Parser());
        }
        catch (IOException e) {
            throw new OsmDataParsingException(e);
        }
        catch (ParserConfigurationException e) {
            throw new OsmDataParsingException(e);
        }
        catch (OsmDataParsingException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new OsmDataParsingException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OsmPrimitive> postProcess(Changeset cs, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("Postprocessing uploaded data ...");
            monitor.setTicksCount(this.primitives.size());
            monitor.setTicks(0);
            for (OsmPrimitive p : this.primitives) {
                monitor.worked(1);
                DiffResultEntry entry = this.diffResults.get(p.getPrimitiveId());
                if (entry == null) continue;
                this.processed.add(p);
                if (!p.isDeleted()) {
                    p.setOsmId(entry.new_id, entry.new_version);
                    p.setVisible(true);
                }
                if (cs == null || cs.isNew()) continue;
                p.setChangesetId(cs.getId());
            }
            Set<OsmPrimitive> set = this.processed;
            return set;
        }
        finally {
            monitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws OsmDataParsingException {
            throw new OsmDataParsingException(msg).rememberLocation(this.locator);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (!qName.equals("diffResult")) {
                    if (qName.equals("node") || qName.equals("way") || qName.equals("relation")) {
                        SimplePrimitiveId id = new SimplePrimitiveId(Long.parseLong(atts.getValue("old_id")), OsmPrimitiveType.fromApiTypeName(qName));
                        DiffResultEntry entry = new DiffResultEntry();
                        if (atts.getValue("new_id") != null) {
                            entry.new_id = Long.parseLong(atts.getValue("new_id"));
                        }
                        if (atts.getValue("new_version") != null) {
                            entry.new_version = Integer.parseInt(atts.getValue("new_version"));
                        }
                        DiffResultProcessor.this.diffResults.put(id, entry);
                    } else {
                        this.throwException(I18n.tr("Unexpected XML element with name ''{0}''", qName));
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new OsmDataParsingException(e).rememberLocation(this.locator);
            }
        }
    }

    private static class DiffResultEntry {
        public long new_id;
        public int new_version;

        private DiffResultEntry() {
        }
    }
}

