/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.CacheFiles;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    volatile boolean stop = false;
    List<ImageEntry> data;
    GeoImageLayer layer;
    MediaTracker tracker;
    CacheFiles cache;
    boolean cacheOff = Main.pref.getBoolean("geoimage.noThumbnailCache", false);

    public ThumbsLoader(GeoImageLayer layer) {
        this.layer = layer;
        this.data = new ArrayList<ImageEntry>(layer.data);
        if (!this.cacheOff) {
            this.cache = new CacheFiles("geoimage-thumbnails", false);
            this.cache.setExpire(-1, false);
            this.cache.setMaxSize(120, false);
        }
    }

    public void run() {
        System.err.println("Load Thumbnails");
        this.tracker = new MediaTracker(Main.map.mapView);
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.stop) {
                return;
            }
            System.err.print("fetching image " + i);
            this.data.get((int)i).thumbnail = this.loadThumb(this.data.get(i));
            if (Main.map == null || Main.map.mapView == null) continue;
            this.layer.updateOffscreenBuffer = true;
            Main.map.mapView.repaint();
        }
        try {
            this.layer.updateOffscreenBuffer = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Main.map.mapView.repaint();
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
            }
        }.start();
    }

    private BufferedImage loadThumb(ImageEntry entry) {
        BufferedImage cached;
        String cacheIdent = entry.getFile().toString() + ":" + 120;
        if (!this.cacheOff && (cached = this.cache.getImg(cacheIdent)) != null) {
            System.err.println(" from cache");
            return cached;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(entry.getFile().getPath());
        this.tracker.addImage(img, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            System.err.println(" InterruptedException");
            return null;
        }
        if (this.tracker.isErrorID(1) || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            System.err.println(" Invalid image");
            return null;
        }
        Rectangle targetSize = ImageDisplay.calculateDrawImageRectangle(new Rectangle(0, 0, img.getWidth(null), img.getHeight(null)), new Rectangle(0, 0, 120, 120));
        BufferedImage scaledBI = new BufferedImage(targetSize.width, targetSize.height, 1);
        Graphics2D g = scaledBI.createGraphics();
        while (!g.drawImage(img, 0, 0, targetSize.width, targetSize.height, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {}
        }
        g.dispose();
        this.tracker.removeImage(img);
        if (scaledBI.getWidth() <= 0 || scaledBI.getHeight() <= 0) {
            System.err.println(" Invalid image");
            return null;
        }
        if (!this.cacheOff) {
            this.cache.saveImg(cacheIdent, scaledBI);
        }
        System.err.println("");
        return scaledBI;
    }
}

