/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadStrategy;

public class UploadStrategySpecification {
    public static final int UNSPECIFIED_CHUNK_SIZE = -1;
    private UploadStrategy strategy;
    private int chunkSize;
    private MaxChangesetSizeExceededPolicy policy;
    private boolean closeChangesetAfterUpload;

    public UploadStrategySpecification() {
        this.strategy = UploadStrategy.DEFAULT_UPLOAD_STRATEGY;
        this.chunkSize = -1;
        this.policy = null;
        this.closeChangesetAfterUpload = true;
    }

    public UploadStrategySpecification(UploadStrategySpecification other) {
        if (other == null) {
            return;
        }
        this.strategy = other.strategy;
        this.chunkSize = other.chunkSize;
        this.policy = other.policy;
        this.closeChangesetAfterUpload = other.closeChangesetAfterUpload;
    }

    public UploadStrategy getStrategy() {
        return this.strategy;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public static int getUnspecifiedChunkSize() {
        return -1;
    }

    public MaxChangesetSizeExceededPolicy getPolicy() {
        return this.policy;
    }

    public UploadStrategySpecification setStrategy(UploadStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public UploadStrategySpecification setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public UploadStrategySpecification setPolicy(MaxChangesetSizeExceededPolicy policy) {
        this.policy = policy;
        return this;
    }

    public UploadStrategySpecification setCloseChangesetAfterUpload(boolean closeChangesetAfterUpload) {
        this.closeChangesetAfterUpload = closeChangesetAfterUpload;
        return this;
    }

    public boolean isCloseChangesetAfterUpload() {
        return this.closeChangesetAfterUpload;
    }

    public int getNumRequests(int numObjects) {
        if (numObjects <= 0) {
            return 0;
        }
        switch (this.strategy) {
            case INDIVIDUAL_OBJECTS_STRATEGY: {
                return numObjects;
            }
            case SINGLE_REQUEST_STRATEGY: {
                return 1;
            }
            case CHUNKED_DATASET_STRATEGY: {
                if (this.chunkSize == -1) {
                    return 0;
                }
                return (int)Math.ceil((double)numObjects / (double)this.chunkSize);
            }
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.chunkSize;
        result = 31 * result + (this.closeChangesetAfterUpload ? 1231 : 1237);
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UploadStrategySpecification other = (UploadStrategySpecification)obj;
        if (this.chunkSize != other.chunkSize) {
            return false;
        }
        if (this.closeChangesetAfterUpload != other.closeChangesetAfterUpload) {
            return false;
        }
        if (this.policy == null ? other.policy != null : !this.policy.equals((Object)other.policy)) {
            return false;
        }
        return !(this.strategy == null ? other.strategy != null : !this.strategy.equals((Object)other.strategy));
    }
}

