/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableModel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetContentPanel
extends JPanel
implements PropertyChangeListener {
    private ChangesetContentTableModel model;
    private Changeset currentChangeset;
    private JTable tblContent;
    private DonwloadChangesetContentAction actDownloadContentAction;
    private ShowHistoryAction actShowHistory;
    private SelectInCurrentLayerAction actSelectInCurrentLayerAction;
    private ZoomInCurrentLayerAction actZoomInCurrentLayerAction;
    private HeaderPanel pnlHeader;

    protected void buildModels() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new ChangesetContentTableModel(selectionModel);
        this.actDownloadContentAction = new DonwloadChangesetContentAction();
        this.actDownloadContentAction.initProperties(this.currentChangeset);
        this.actShowHistory = new ShowHistoryAction();
        this.model.getSelectionModel().addListSelectionListener(this.actShowHistory);
        this.actSelectInCurrentLayerAction = new SelectInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actSelectInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actSelectInCurrentLayerAction);
        this.actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actZoomInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                MapView.removeEditLayerChangeListener(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
                MapView.removeEditLayerChangeListener(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
            }
        });
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.tblContent = new JTable(this.model, new ChangesetContentTableColumnModel(), this.model.getSelectionModel());
        this.tblContent.addMouseListener(new ChangesetContentTablePopupMenuLauncher());
        pnl.add((Component)new JScrollPane(this.tblContent), "Center");
        return pnl;
    }

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        tb.add(this.actDownloadContentAction);
        tb.add(this.actShowHistory);
        tb.add(this.actSelectInCurrentLayerAction);
        tb.add(this.actZoomInCurrentLayerAction);
        pnl.add(tb);
        return pnl;
    }

    protected void build() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.buildModels();
        this.pnlHeader = new HeaderPanel();
        this.add((Component)this.pnlHeader, "North");
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add((Component)this.buildContentPanel(), "Center");
    }

    public ChangesetContentPanel() {
        this.build();
    }

    public ChangesetContentTableModel getModel() {
        return this.model;
    }

    protected void setCurrentChangeset(Changeset cs) {
        this.currentChangeset = cs;
        if (cs == null) {
            this.model.populate(null);
        } else {
            this.model.populate(cs.getContent());
        }
        this.actDownloadContentAction.initProperties(cs);
        this.pnlHeader.setChangeset(cs);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        Changeset cs = (Changeset)evt.getNewValue();
        this.setCurrentChangeset(cs);
    }

    private static class HeaderPanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private Changeset current;
        private DownloadAction actDownload;

        protected void build() {
            this.setLayout(new FlowLayout(0));
            this.lblMessage = new JMultilineLabel(I18n.tr("The content of this changeset is not downloaded yet."));
            this.add(this.lblMessage);
            this.actDownload = new DownloadAction();
            this.add(new JButton(this.actDownload));
        }

        public HeaderPanel() {
            this.build();
        }

        public void setChangeset(Changeset cs) {
            this.setVisible(cs != null && cs.getContent() == null);
            this.current = cs;
        }

        private class DownloadAction
        extends AbstractAction {
            public DownloadAction() {
                this.putValue("Name", I18n.tr("Download now"));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
            }

            public void actionPerformed(ActionEvent evt) {
                if (HeaderPanel.this.current == null) {
                    return;
                }
                ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)HeaderPanel.this, HeaderPanel.this.current.getId());
                ChangesetCacheManager.getInstance().runDownloadTask(task);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ZoomInCurrentLayerAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.EditLayerChangeListener {
        public ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.putValue("ShortDescription", I18n.tr("Zoom to the corresponding primitives in the current data layer"));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToZoomTo(Collection<HistoryOsmPrimitive> primitives) {
            HelpAwareOptionPane.showOptionDialog(ChangesetContentPanel.this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", primitives.size(), Main.main.getEditLayer().getName()), I18n.tr("Nothing to zoom to"), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || Main.main.getEditLayer() == null) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive p : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive op = layer.data.getPrimitiveById(p.getPrimitiveId());
                if (op == null) continue;
                target.add(op);
            }
            if (target.isEmpty()) {
                this.alertNoPrimitivesToZoomTo(selected);
                return;
            }
            layer.data.setSelected(target);
            AutoScaleAction.zoomToSelection();
        }

        public void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectInCurrentLayerAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.EditLayerChangeListener {
        public SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.putValue("ShortDescription", I18n.tr("Select the corresponding primitives in the current data layer"));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToSelect(Collection<HistoryOsmPrimitive> primitives) {
            HelpAwareOptionPane.showOptionDialog(ChangesetContentPanel.this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", primitives.size(), Main.main.getEditLayer().getName()), I18n.tr("Nothing to select"), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || Main.main.getEditLayer() == null) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive p : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive op = layer.data.getPrimitiveById(p.getPrimitiveId());
                if (op == null) continue;
                target.add(op);
            }
            if (target.isEmpty()) {
                this.alertNoPrimitivesToSelect(selected);
                return;
            }
            layer.data.setSelected(target);
        }

        public void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.putValue("ShortDescription", I18n.tr("Download and show the history of the selected primitives"));
            this.updateEnabledState();
        }

        protected List<HistoryOsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<HistoryOsmPrimitive> primitives) {
            ArrayList<HistoryOsmPrimitive> ret = new ArrayList<HistoryOsmPrimitive>(primitives.size());
            for (HistoryOsmPrimitive p : primitives) {
                if (HistoryDataSet.getInstance().getHistory(p.getPrimitiveId()) != null) continue;
                ret.add(p);
            }
            return ret;
        }

        public void showHistory(final Collection<HistoryOsmPrimitive> primitives) {
            List<HistoryOsmPrimitive> toLoad = this.filterPrimitivesWithUnloadedHistory(primitives);
            if (!toLoad.isEmpty()) {
                HistoryLoadTask task = new HistoryLoadTask(ChangesetContentPanel.this);
                for (HistoryOsmPrimitive p : toLoad) {
                    task.add(p);
                }
                Main.worker.submit(task);
            }
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        for (HistoryOsmPrimitive p : primitives) {
                            History h = HistoryDataSet.getInstance().getHistory(p.getPrimitiveId());
                            if (h == null) continue;
                            HistoryBrowserDialogManager.getInstance().show(h);
                        }
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BugReportExceptionHandler.handleException(e);
                            }
                        });
                    }
                }
            };
            Main.worker.submit(r);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            if (selected.isEmpty()) {
                return;
            }
            this.showHistory(selected);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ChangesetContentTablePopupMenu
    extends JPopupMenu {
        public ChangesetContentTablePopupMenu() {
            this.add(ChangesetContentPanel.this.actDownloadContentAction);
            this.add(ChangesetContentPanel.this.actShowHistory);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
            this.add(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
        }
    }

    class ChangesetContentTablePopupMenuLauncher
    extends MouseAdapter {
        ChangesetContentTablePopupMenu menu;

        ChangesetContentTablePopupMenuLauncher() {
            this.menu = new ChangesetContentTablePopupMenu();
        }

        protected void launch(MouseEvent evt) {
            int row;
            if (!evt.isPopupTrigger()) {
                return;
            }
            if (!ChangesetContentPanel.this.model.hasSelectedPrimitives() && (row = ChangesetContentPanel.this.tblContent.rowAtPoint(evt.getPoint())) >= 0) {
                ChangesetContentPanel.this.model.setSelectedByIdx(row);
            }
            this.menu.show(ChangesetContentPanel.this.tblContent, evt.getPoint().x, evt.getPoint().y);
        }

        public void mouseClicked(MouseEvent evt) {
            this.launch(evt);
        }

        public void mousePressed(MouseEvent evt) {
            this.launch(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.launch(evt);
        }
    }

    class DonwloadChangesetContentAction
    extends AbstractAction {
        public DonwloadChangesetContentAction() {
            this.putValue("Name", I18n.tr("Download content"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
            this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (ChangesetContentPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)ChangesetContentPanel.this, ChangesetContentPanel.this.currentChangeset.getId());
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }

        public void initProperties(Changeset cs) {
            if (cs == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            if (cs.getContent() == null) {
                this.putValue("Name", I18n.tr("Download content"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server"));
            } else {
                this.putValue("Name", I18n.tr("Update content"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "updatechangesetcontent"));
                this.putValue("ShortDescription", I18n.tr("Update the changeset content from the OSM server"));
            }
        }
    }
}

