/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    public void load() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.removeAllElements();
        try {
            for (Preferences.Bookmark b : Main.pref.loadBookmarks()) {
                model.addElement(b);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", Main.pref.getBookmarksFile(), e.getMessage()), I18n.tr("Error"), 0);
        }
    }

    public void save() {
        try {
            LinkedList<Preferences.Bookmark> bookmarks = new LinkedList<Preferences.Bookmark>();
            for (Object o : ((DefaultListModel)this.getModel()).toArray()) {
                bookmarks.add((Preferences.Bookmark)o);
            }
            Main.pref.saveBookmarks(bookmarks);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not write bookmark.<br>{0}</html>", e.getMessage()), I18n.tr("Error"), 0);
        }
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon icon;

        public BookmarkCellRenderer() {
            this.setOpaque(true);
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.setIcon(this.icon);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Preferences.Bookmark b) {
            Bounds area = b.getArea();
            StringBuffer sb = new StringBuffer();
            sb.append("<html>min[latitude,longitude]=<strong>[").append(area.getMin().lat()).append(",").append(area.getMin().lon()).append("]</strong>").append("<br>").append("max[latitude,longitude]=<strong>[").append(area.getMax().lat()).append(",").append(area.getMax().lon()).append("]</strong>").append("</html>");
            return sb.toString();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Preferences.Bookmark b = (Preferences.Bookmark)value;
            this.renderColor(isSelected);
            this.setText(b.getName());
            this.setToolTipText(this.buildToolTipText(b));
            return this;
        }
    }
}

