/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePaintVisitor
extends AbstractVisitor
implements PaintVisitor {
    protected Graphics2D g;
    protected NavigatableComponent nc;
    public boolean inactive;
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color nodeColor;
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color incompleteColor;
    protected Color backgroundColor;
    protected Color highlightColor;
    protected Color taggedColor;
    protected Color connectionColor;
    protected Color taggedConnectionColor;
    protected boolean showDirectionArrow;
    protected boolean showRelevantDirectionsOnly;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected boolean fillTaggedNode;
    protected boolean fillConnectionNode;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int connectionNodeSize;
    protected int taggedNodeSize;
    protected int defaultSegmentWidth;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;
    protected Color currentColor = null;
    protected GeneralPath currentPath = new GeneralPath();
    DataSet ds;
    private Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);

    public void getColors() {
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.dfltWayColor = PaintColors.DEFAULT_WAY.get();
        this.relationColor = PaintColors.RELATION.get();
        this.untaggedWayColor = PaintColors.UNTAGGED_WAY.get();
        this.incompleteColor = PaintColors.INCOMPLETE_WAY.get();
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
    }

    protected void getSettings(boolean virtual) {
        MapPaintSettings settings = MapPaintSettings.INSTANCE;
        this.showDirectionArrow = settings.isShowDirectionArrow();
        this.showRelevantDirectionsOnly = settings.isShowRelevantDirectionsOnly();
        this.showHeadArrowOnly = settings.isShowHeadArrowOnly();
        this.showOrderNumber = settings.isShowOrderNumber();
        this.selectedNodeSize = settings.getSelectedNodeSize();
        this.unselectedNodeSize = settings.getUnselectedNodeSize();
        this.connectionNodeSize = settings.getConnectionNodeSize();
        this.taggedNodeSize = settings.getTaggedNodeSize();
        this.defaultSegmentWidth = settings.getDefaultSegmentWidth();
        this.fillSelectedNode = settings.isFillSelectedNode();
        this.fillUnselectedNode = settings.isFillUnselectedNode();
        this.fillConnectionNode = settings.isFillConnectionNode();
        this.fillTaggedNode = settings.isFillTaggedNode();
        this.virtualNodeSize = virtual ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void visitAll(DataSet data, boolean virtual, Bounds bounds) {
        BBox bbox = new BBox(bounds);
        this.ds = data;
        this.getSettings(virtual);
        for (Relation relation : data.searchRelations(bbox)) {
            if (relation.isDeleted() || this.ds.isSelected(relation) || relation.isFiltered()) continue;
            ((OsmPrimitive)relation).visit(this);
        }
        for (Way way : data.searchWays(bbox)) {
            if (way.isDeleted() || this.ds.isSelected(way) || way.isFiltered() || !way.isTagged()) continue;
            ((OsmPrimitive)way).visit(this);
        }
        this.displaySegments();
        for (Way way : data.searchWays(bbox)) {
            if (way.isDeleted() || this.ds.isSelected(way) || way.isFiltered() || way.isTagged()) continue;
            ((OsmPrimitive)way).visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (osmPrimitive.isDeleted()) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (Node node : data.searchNodes(bbox)) {
            if (node.isDeleted() || this.ds.isSelected(node) || node.isFiltered()) continue;
            ((OsmPrimitive)node).visit(this);
        }
        this.drawVirtualNodes(data.searchWays(bbox));
    }

    private static final int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    @Override
    public void visit(Node n) {
        if (n.isIncomplete()) {
            return;
        }
        if (n.isHighlighted()) {
            this.drawNode(n, this.highlightColor, this.selectedNodeSize, this.fillSelectedNode);
        } else {
            Color color = this.inactive || n.isDisabled() ? this.inactiveColor : (this.ds.isSelected(n) ? this.selectedColor : (n.isConnectionNode() ? (n.isTagged() ? this.taggedConnectionColor : this.connectionColor) : (n.isTagged() ? this.taggedColor : this.nodeColor)));
            int size = SimplePaintVisitor.max(this.ds.isSelected(n) ? this.selectedNodeSize : 0, n.isTagged() ? this.taggedNodeSize : 0, n.isConnectionNode() ? this.connectionNodeSize : 0, this.unselectedNodeSize);
            boolean fill = this.ds.isSelected(n) && this.fillSelectedNode || n.isTagged() && this.fillTaggedNode || n.isConnectionNode() && this.fillConnectionNode || this.fillUnselectedNode;
            this.drawNode(n, color, size, fill);
        }
    }

    public static boolean isLargeSegment(Point p1, Point p2, int space) {
        int yd;
        int xd = p1.x - p2.x;
        if (xd < 0) {
            xd = -xd;
        }
        if ((yd = p1.y - p2.y) < 0) {
            yd = -yd;
        }
        return xd + yd > space;
    }

    public void drawVirtualNodes(Collection<Way> ways) {
        if (this.virtualNodeSize != 0) {
            GeneralPath path = new GeneralPath();
            for (Way osm : ways) {
                if (!osm.isUsable() || osm.isFiltered() || osm.isDisabled()) continue;
                this.visitVirtual(path, osm);
            }
            this.g.setColor(this.nodeColor);
            this.g.draw(path);
        }
    }

    public void visitVirtual(GeneralPath path, Way w) {
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                if (this.isSegmentVisible(lastP, p) && SimplePaintVisitor.isLargeSegment(lastP, p, this.virtualNodeSpace)) {
                    int x = (p.x + lastP.x) / 2;
                    int y = (p.y + lastP.y) / 2;
                    path.moveTo(x - this.virtualNodeSize, y);
                    path.lineTo(x + this.virtualNodeSize, y);
                    path.moveTo(x, y - this.virtualNodeSize);
                    path.lineTo(x, y + this.virtualNodeSize);
                }
                lastP = p;
            }
        }
    }

    @Override
    public void visit(Way w) {
        boolean showOnlyHeadArrowOnly;
        if (w.isIncomplete() || w.getNodesCount() < 2) {
            return;
        }
        boolean showThisDirectionArrow = this.ds.isSelected(w) || this.showDirectionArrow && (!this.showRelevantDirectionsOnly || w.hasDirectionKeys());
        boolean bl = showOnlyHeadArrowOnly = showThisDirectionArrow && !this.ds.isSelected(w) && this.showHeadArrowOnly;
        Color wayColor = this.inactive || w.isDisabled() ? this.inactiveColor : (w.isHighlighted() ? this.highlightColor : (this.ds.isSelected(w) ? this.selectedColor : (!w.isTagged() ? this.untaggedWayColor : this.dfltWayColor)));
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            int orderNumber = 1;
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                this.drawSegment(lastP, p, wayColor, showOnlyHeadArrowOnly ? !it.hasNext() : showThisDirectionArrow);
                if (this.showOrderNumber) {
                    this.drawOrderNumber(lastP, p, orderNumber);
                }
                lastP = p;
                ++orderNumber;
            }
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isIncomplete()) {
            return;
        }
        Color col = this.inactive || r.isDisabled() ? this.inactiveColor : (this.ds.isSelected(r) ? this.selectedColor : this.relationColor);
        this.g.setColor(col);
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete() || m.getMember().isDeleted()) continue;
            if (m.isNode()) {
                Point p = this.nc.getPoint(m.getNode());
                if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) continue;
                this.g.drawOval(p.x - 3, p.y - 3, 6, 6);
                continue;
            }
            if (!m.isWay()) continue;
            GeneralPath path = new GeneralPath();
            boolean first = true;
            for (Node n : m.getWay().getNodes()) {
                if (n.isIncomplete() || n.isDeleted()) continue;
                Point p = this.nc.getPoint(n);
                if (first) {
                    path.moveTo(p.x, p.y);
                    first = false;
                    continue;
                }
                path.lineTo(p.x, p.y);
            }
            this.g.draw(this.relatedWayStroke.createStrokedShape(path));
        }
    }

    protected void drawOrderNumber(Point p1, Point p2, int orderNumber) {
        if (this.isSegmentVisible(p1, p2) && SimplePaintVisitor.isLargeSegment(p1, p2, this.segmentNumberSpace)) {
            String on = Integer.toString(orderNumber);
            int strlen = on.length();
            int x = (p1.x + p2.x) / 2 - 4 * strlen;
            int y = (p1.y + p2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && SimplePaintVisitor.isLargeSegment(p1, p2, this.virtualNodeSpace)) {
                y = (p1.y + p2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.displaySegments();
            Color c = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(x - 1, y - 12, 8 * strlen + 1, 14);
            this.g.setColor(c);
            this.g.drawString(on, x, y);
        }
    }

    public void drawNode(Node n, Color color, int size, boolean fill) {
        if (size > 1) {
            int radius = size / 2;
            Point p = this.nc.getPoint(n);
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (fill) {
                this.g.fillRect(p.x - radius, p.y - radius, size, size);
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            } else {
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            }
        }
    }

    protected void drawSegment(GeneralPath path, Point p1, Point p2, boolean showDirection) {
        boolean drawIt = false;
        if (Main.isOpenjdk) {
            Rectangle bounds = this.g.getClipBounds();
            bounds.grow(100, 100);
            LineClip clip = new LineClip();
            drawIt = clip.cohenSutherland(p1.x, p1.y, p2.x, p2.y, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
            p1 = clip.getP1();
            p2 = clip.getP2();
        } else {
            drawIt = this.isSegmentVisible(p1, p2);
        }
        if (drawIt) {
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            if (showDirection) {
                double l = 10.0 / p1.distance(p2);
                double sx = l * (double)(p1.x - p2.x);
                double sy = l * (double)(p1.y - p2.y);
                path.lineTo(p2.x + (int)Math.round(cosPHI * sx - sinPHI * sy), p2.y + (int)Math.round(sinPHI * sx + cosPHI * sy));
                path.moveTo(p2.x + (int)Math.round(cosPHI * sx + sinPHI * sy), p2.y + (int)Math.round(-sinPHI * sx + cosPHI * sy));
                path.lineTo(p2.x, p2.y);
            }
        }
    }

    protected void drawSegment(Point p1, Point p2, Color col, boolean showDirection) {
        if (col != this.currentColor) {
            this.displaySegments(col);
        }
        this.drawSegment(this.currentPath, p1, p2, showDirection);
    }

    protected boolean isSegmentVisible(Point p1, Point p2) {
        if (p1.x < 0 && p2.x < 0) {
            return false;
        }
        if (p1.y < 0 && p2.y < 0) {
            return false;
        }
        if (p1.x > this.nc.getWidth() && p2.x > this.nc.getWidth()) {
            return false;
        }
        return p1.y <= this.nc.getHeight() || p2.y <= this.nc.getHeight();
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle bounds = polygon.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            return false;
        }
        if (bounds.x > this.nc.getWidth()) {
            return false;
        }
        if (bounds.y > this.nc.getHeight()) {
            return false;
        }
        if (bounds.x + bounds.width < 0) {
            return false;
        }
        return bounds.y + bounds.height >= 0;
    }

    @Override
    public void setGraphics(Graphics2D g) {
        this.g = g;
    }

    @Override
    public void setNavigatableComponent(NavigatableComponent nc) {
        this.nc = nc;
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color newColor) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            this.g.draw(this.currentPath);
            this.currentPath = new GeneralPath();
            this.currentColor = newColor;
        }
    }

    @Override
    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }
}

