/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Way
extends OsmPrimitive {
    private Node[] nodes = new Node[0];
    private BBox bbox;
    public boolean isMappaintArea = false;
    public Integer mappaintDrawnAreaCode = 0;

    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodes(List<Node> nodes) {
        boolean locked = this.writeLock();
        try {
            for (Node node : this.nodes) {
                node.removeReferrer(this);
            }
            this.nodes = nodes == null ? new Node[0] : nodes.toArray(new Node[nodes.size()]);
            for (Node node : this.nodes) {
                node.addReferrer(this);
            }
            this.clearCached();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public int getNodesCount() {
        return this.nodes.length;
    }

    public Node getNode(int index) {
        return this.nodes[index];
    }

    public boolean containsNode(Node node) {
        if (node == null) {
            return false;
        }
        Node[] nodes = this.nodes;
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clearCached() {
        super.clearCached();
        this.isMappaintArea = false;
        this.mappaintDrawnAreaCode = 0;
    }

    public List<Pair<Node, Node>> getNodePairs(boolean sort) {
        Node[] nodes;
        ArrayList<Pair<Node, Node>> chunkSet = new ArrayList<Pair<Node, Node>>();
        if (this.isIncomplete()) {
            return chunkSet;
        }
        Node lastN = null;
        for (Node n : nodes = this.nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            Pair<Node, Node> np = new Pair<Node, Node>(lastN, n);
            if (sort) {
                Pair.sort(np);
            }
            chunkSet.add(np);
            lastN = n;
        }
        return chunkSet;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    protected Way(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Way() {
        super(0L, false);
    }

    public Way(Way original, boolean clearId) {
        super(original.getUniqueId(), true);
        this.cloneFrom(original);
        if (clearId) {
            this.clearOsmId();
        }
    }

    public Way(Way original) {
        this(original, false);
    }

    public Way(long id) throws IllegalArgumentException {
        super(id, false);
    }

    public Way(long id, int version) {
        super(id, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData data) {
        boolean locked = this.writeLock();
        try {
            super.load(data);
            WayData wayData = (WayData)data;
            ArrayList<Node> newNodes = new ArrayList<Node>(wayData.getNodes().size());
            for (Long nodeId : wayData.getNodes()) {
                Node node = (Node)this.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE);
                if (node != null) {
                    newNodes.add(node);
                    continue;
                }
                throw new AssertionError((Object)"Data consistency problem - way with missing node detected");
            }
            this.setNodes(newNodes);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public WayData save() {
        WayData data = new WayData();
        this.saveCommonAttributes(data);
        for (Node node : this.nodes) {
            data.getNodes().add(node.getUniqueId());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osm) {
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm);
            Way otherWay = (Way)osm;
            this.setNodes(otherWay.getNodes());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public String toString() {
        String nodesDesc = this.isIncomplete() ? "(incomplete)" : "nodes=" + Arrays.toString(this.nodes);
        return "{Way id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + nodesDesc + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (other == null || !(other instanceof Way)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Way w = (Way)other;
        if (this.getNodesCount() != w.getNodesCount()) {
            return false;
        }
        for (int i = 0; i < this.getNodesCount(); ++i) {
            if (this.getNode(i).hasEqualSemanticAttributes(w.getNode(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(OsmPrimitive o) {
        if (o instanceof Relation) {
            return 1;
        }
        return o instanceof Way ? Long.valueOf(this.getUniqueId()).compareTo(o.getUniqueId()) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node n) {
        if (this.isIncomplete()) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            int i;
            boolean closed = this.lastNode() == n && this.firstNode() == n;
            List<Node> copy = this.getNodes();
            while ((i = copy.indexOf(n)) >= 0) {
                copy.remove(i);
            }
            i = copy.size();
            if (closed && i > 2) {
                copy.add(copy.get(0));
            } else if (i >= 2 && i <= 3 && copy.get(0) == copy.get(i - 1)) {
                copy.remove(i - 1);
            }
            this.setNodes(copy);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodes(Collection<? extends OsmPrimitive> selection) {
        if (this.isIncomplete()) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            for (OsmPrimitive osmPrimitive : selection) {
                if (!(osmPrimitive instanceof Node)) continue;
                this.removeNode((Node)osmPrimitive);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node n) throws IllegalStateException {
        if (n == null) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", n.getId(), this.getId()));
            }
            this.clearCached();
            n.addReferrer(this);
            Node[] newNodes = new Node[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            newNodes[this.nodes.length] = n;
            this.nodes = newNodes;
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(int offs, Node n) throws IllegalStateException, IndexOutOfBoundsException {
        if (n == null) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", n.getId(), this.getId()));
            }
            this.clearCached();
            n.addReferrer(this);
            Node[] newNodes = new Node[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, offs);
            System.arraycopy(this.nodes, offs, newNodes, offs + 1, this.nodes.length - offs);
            newNodes[offs] = n;
            this.nodes = newNodes;
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean deleted) {
        boolean locked = this.writeLock();
        try {
            for (Node n : this.nodes) {
                if (deleted) {
                    n.removeReferrer(this);
                    continue;
                }
                n.addReferrer(this);
            }
            this.fireNodesChanged();
            super.setDeleted(deleted);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        Node[] nodes = this.nodes;
        return nodes.length >= 3 && nodes[nodes.length - 1] == nodes[0];
    }

    public Node lastNode() {
        Node[] nodes = this.nodes;
        if (this.isIncomplete() || nodes.length == 0) {
            return null;
        }
        return nodes[nodes.length - 1];
    }

    public Node firstNode() {
        Node[] nodes = this.nodes;
        if (this.isIncomplete() || nodes.length == 0) {
            return null;
        }
        return nodes[0];
    }

    public boolean isFirstLastNode(Node n) {
        Node[] nodes = this.nodes;
        if (this.isIncomplete() || nodes.length == 0) {
            return false;
        }
        return n == nodes[0] || n == nodes[nodes.length - 1];
    }

    @Override
    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    private void checkNodes() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            Node[] nodes;
            for (Node n : nodes = this.nodes) {
                if (n.getDataSet() != dataSet) {
                    throw new DataIntegrityProblemException("Nodes in way must be in the same dataset");
                }
                if (!n.isDeleted()) continue;
                throw new DataIntegrityProblemException("Deleted node referenced: " + this.toString());
            }
            if (Main.pref.getBoolean("debug.checkNullCoor", true)) {
                for (Node n : nodes) {
                    if (n.isIncomplete() || n.getCoor() != null && n.getEastNorth() != null) continue;
                    throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString() + n.get3892DebugInfo());
                }
            }
        }
    }

    private void fireNodesChanged() {
        this.checkNodes();
        if (this.getDataSet() != null) {
            this.getDataSet().fireWayNodesChanged(this);
        }
    }

    @Override
    public void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkNodes();
    }

    @Override
    public BBox getBBox() {
        if (this.getDataSet() == null) {
            return new BBox(this);
        }
        if (this.bbox == null) {
            this.bbox = new BBox(this);
        }
        return new BBox(this.bbox);
    }

    @Override
    public void updatePosition() {
        this.bbox = new BBox(this);
    }

    public boolean hasIncompleteNodes() {
        Node[] nodes;
        for (Node node : nodes = this.nodes) {
            if (!node.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !this.hasIncompleteNodes();
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && !this.hasIncompleteNodes();
    }
}

