/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    private static boolean debug = false;
    private static final boolean consistency_testing = false;
    private final Object split_lock = new Object();
    long last_out = -1L;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    private QBLevel root;
    private QBLevel search_cache;
    private int size;

    static void abort(String s) {
        throw new AssertionError((Object)s);
    }

    static void out(String s) {
        System.out.println(s);
    }

    void pout(String s) {
        long now = System.currentTimeMillis();
        if (now - this.last_out < 300L) {
            return;
        }
        this.last_out = now;
        System.out.print(s + "\r");
    }

    void pout(String s, int i, int total) {
        long now = System.currentTimeMillis();
        if (now - this.last_out < 300L && i + 1 < total) {
            return;
        }
        this.last_out = now;
        System.out.print(s + " " + (float)((double)(i + 1) * 100.0 / (double)total) + "% done    \r");
    }

    public QuadBuckets() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.split_lock;
        synchronized (object) {
            this.root = new QBLevel();
            this.search_cache = null;
            this.size = 0;
            if (debug) {
                QuadBuckets.out("QuadBuckets() cleared: " + this);
                QuadBuckets.out("root: " + this.root + " level: " + this.root.level + " bbox: " + this.root.bbox());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T n) {
        Object object = this.split_lock;
        synchronized (object) {
            this.root.add(n);
            ++this.size;
            return true;
        }
    }

    public void unsupported() {
        QuadBuckets.out("unsupported operation");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        for (OsmPrimitive o : this) {
            if (objects.contains(o) || this.remove((T)o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object o : objects) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends T> objects) {
        boolean changed = false;
        for (OsmPrimitive o : objects) {
            changed |= this.add((T)o);
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    private T convert(Object raw) {
        return (T)((OsmPrimitive)raw);
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(this.convert(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T o) {
        Object object = this.split_lock;
        synchronized (object) {
            this.search_cache = null;
            QBLevel bucket = this.root.findBucket(((OsmPrimitive)o).getBBox());
            if (bucket.remove_content(o)) {
                --this.size;
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean contains(Object o) {
        QBLevel bucket = this.root.findBucket(((OsmPrimitive)this.convert(o)).getBBox());
        return bucket != null && bucket.content != null && bucket.content.contains(o);
    }

    public ArrayList<T> toArrayList() {
        ArrayList<OsmPrimitive> a = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive n : this) {
            a.add(n);
        }
        if (debug) {
            QuadBuckets.out("returning array list with size: " + a.size());
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <A> A[] toArray(A[] template) {
        return this.toArrayList().toArray(template);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.split_lock;
        synchronized (object) {
            return this.size;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<T> search(BBox search_bbox) {
        if (debug) {
            QuadBuckets.out("qb root search at " + search_bbox);
            QuadBuckets.out("root bbox: " + this.root.bbox());
        }
        ArrayList ret = new ArrayList();
        boolean cache_searches = true;
        if (cache_searches) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (!this.search_cache.bbox().bounds(search_bbox)) {
                if (debug) {
                    QuadBuckets.out("bbox: " + search_bbox);
                }
                if (debug) {
                    QuadBuckets.out("search_cache: " + this.search_cache + " level: " + this.search_cache.level);
                    QuadBuckets.out("search_cache.bbox(): " + this.search_cache.bbox());
                }
                this.search_cache = this.search_cache.parent;
                if (!debug) continue;
                QuadBuckets.out("new search_cache: " + this.search_cache);
            }
        } else {
            this.search_cache = this.root;
        }
        QBLevel tmp = this.search_cache.parent;
        this.search_cache.search(search_bbox, ret);
        while (tmp != null) {
            tmp.search_contents(search_bbox, ret);
            tmp = tmp.parent;
        }
        if (debug) {
            QuadBuckets.out("search of QuadBuckets for " + search_bbox + " ret len: " + ret.size());
        }
        return ret;
    }

    public void printTree() {
        this.printTreeRecursive(this.root, 0);
    }

    private void printTreeRecursive(QBLevel level, int indent) {
        if (level == null) {
            this.printIndented(indent, "<empty child>");
            return;
        }
        this.printIndented(indent, level);
        if (level.hasContent()) {
            for (OsmPrimitive o : level.content) {
                this.printIndented(indent, o);
            }
        }
        if (level.children != null) {
            for (QBLevel child : level.children) {
                this.printTreeRecursive(child, indent + 2);
            }
        }
    }

    private void printIndented(int indent, Object msg) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println(msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuadBucketIterator
    implements Iterator<T> {
        QBLevel current_node;
        int content_index;
        int iterated_over;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        QBLevel next_content_node(QBLevel q) {
            QBLevel next;
            if (q == null) {
                return null;
            }
            QBLevel orig = q;
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                next = q.nextContentNode();
            }
            if (orig == next) {
                QuadBuckets.abort("got same leaf back leaf: " + q.isLeaf());
            }
            return next;
        }

        public QuadBucketIterator(QuadBuckets<T> qb) {
            if (debug) {
                QuadBuckets.out(this + " is a new iterator qb: " + qb + " size: " + qb.size());
            }
            this.current_node = qb.root.isLeaf() || qb.root.hasContent() ? qb.root : this.next_content_node(qb.root);
            if (debug) {
                QuadBuckets.out("\titerator first leaf: " + this.current_node);
            }
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                if (debug) {
                    QuadBuckets.out(this + " no hasNext(), but iterated over so far: " + this.iterated_over);
                }
                return false;
            }
            return true;
        }

        T peek() {
            if (this.current_node == null) {
                if (debug) {
                    QuadBuckets.out("null current leaf, nowhere to go");
                }
                return null;
            }
            while (this.current_node.content == null || this.content_index >= this.current_node.content.size()) {
                if (debug) {
                    QuadBuckets.out("moving to next leaf");
                }
                this.content_index = 0;
                this.current_node = this.next_content_node(this.current_node);
                if (this.current_node != null) continue;
            }
            if (this.current_node == null || this.current_node.content == null) {
                if (debug) {
                    QuadBuckets.out("late nowhere to go " + this.current_node);
                }
                return null;
            }
            return (OsmPrimitive)this.current_node.content.get(this.content_index);
        }

        @Override
        public T next() {
            Object ret = this.peek();
            ++this.content_index;
            if (debug) {
                QuadBuckets.out("iteration[" + this.iterated_over + "] " + this.content_index + " leaf: " + this.current_node);
            }
            ++this.iterated_over;
            if (ret == null && debug) {
                QuadBuckets.out(this + " no next node, but iterated over so far: " + this.iterated_over);
            }
            return ret;
        }

        @Override
        public void remove() {
            --this.content_index;
            Object object = this.peek();
            this.current_node.remove_content(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QBLevel {
        final int level;
        private final BBox bbox;
        final long quad;
        final QBLevel parent;
        public List<T> content;
        public QBLevel[] children;

        public String toString() {
            return super.toString() + "[" + this.level + "]: " + this.bbox();
        }

        public QBLevel() {
            this.level = 0;
            this.quad = 0L;
            this.parent = null;
            this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
        }

        public QBLevel(QBLevel parent, int parent_index) {
            this.parent = parent;
            this.level = parent.level + 1;
            int shift = (QuadTiling.NR_LEVELS - this.level) * 2;
            long mult = 1L;
            if (shift >= 30) {
                shift -= 30;
                mult = 0x40000000L;
            }
            long this_quadpart = mult * (long)(parent_index << shift);
            this.quad = parent.quad | this_quadpart;
            this.bbox = this.calculateBBox();
            if (debug) {
                QuadBuckets.out("new level[" + this.level + "] bbox[" + parent_index + "]: " + this.bbox() + " coor: " + this.coor() + " quadpart: " + Long.toHexString(this_quadpart) + " quad: " + Long.toHexString(this.quad));
            }
        }

        private BBox calculateBBox() {
            LatLon bottom_left = this.coor();
            double lat = bottom_left.lat() + this.parent.height() / 2.0;
            double lon = bottom_left.lon() + this.parent.width() / 2.0;
            LatLon top_right = new LatLon(lat, lon);
            return new BBox(bottom_left, top_right);
        }

        QBLevel findBucket(BBox bbox) {
            if (this.isLeaf()) {
                return this;
            }
            int index = this.get_index(bbox, this.level);
            if (index == -1) {
                return this;
            }
            if (this.children[index] == null) {
                this.children[index] = new QBLevel(this, index);
            }
            return this.children[index].findBucket(bbox);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove_content(T o) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                if (this.content == null) {
                    return false;
                }
                boolean ret = this.content.remove(o);
                if (this.content.size() == 0) {
                    this.content = null;
                }
                if (this.canRemove()) {
                    this.remove_from_parent();
                }
                return ret;
            }
        }

        QBLevel[] newChildren() {
            return (QBLevel[])Array.newInstance(this.getClass(), QuadTiling.TILES_PER_LEVEL);
        }

        int get_index(BBox bbox, int level) {
            int index = -1;
            for (LatLon c : bbox.points()) {
                if (debug) {
                    QuadBuckets.out("getting index for point: " + c);
                }
                if (index == -1) {
                    index = QuadTiling.index(c, level);
                    if (!debug) continue;
                    QuadBuckets.out("set initial index to: " + index);
                    continue;
                }
                int another_index = QuadTiling.index(c, level);
                if (debug) {
                    QuadBuckets.out("other point index: " + another_index);
                }
                if (another_index == index) continue;
                return -1;
            }
            return index;
        }

        void __split() {
            if (debug) {
                QuadBuckets.out("splitting " + this.bbox() + " level " + this.level + " with " + this.content.size() + " entries (my dimensions: " + this.bbox().width() + ", " + this.bbox().height() + ")");
            }
            List tmpcontent = this.content;
            this.content = null;
            this.children = this.newChildren();
            for (OsmPrimitive o : tmpcontent) {
                this.add(o);
            }
            if (!this.hasChildren()) {
                this.children[0] = new QBLevel(this, 0);
            }
        }

        boolean __add_content(T o) {
            boolean ret = false;
            if (this.content == null) {
                this.content = new ArrayList();
            }
            ret = this.content.add(o);
            if (debug && !this.isLeaf()) {
                QuadBuckets.this.pout("added " + o.getClass().getName() + " to non-leaf with size: " + this.content.size());
            }
            return ret;
        }

        boolean matches(T o, BBox search_bbox) {
            return ((OsmPrimitive)o).getBBox().intersects(search_bbox);
        }

        private void search_contents(BBox search_bbox, List<T> result) {
            if (debug) {
                QuadBuckets.out("searching contents (size: " + this.content == null ? "<null>" : this.content.size() + ") for " + search_bbox);
            }
            if (this.content == null) {
                return;
            }
            for (OsmPrimitive o : this.content) {
                if (!this.matches(o, search_bbox)) continue;
                result.add(o);
            }
            if (debug) {
                QuadBuckets.out("done searching quad " + Long.toHexString(this.quad));
            }
        }

        boolean isLeaf() {
            return this.children == null;
        }

        QBLevel next_sibling() {
            boolean found_me = false;
            if (this.parent == null) {
                return null;
            }
            if (this.parent.children == null) {
                return null;
            }
            int __nr = 0;
            for (QBLevel sibling : this.parent.children) {
                int nr = ++__nr - 1;
                if (sibling == null) {
                    if (!debug) continue;
                    QuadBuckets.out("[" + this.level + "] null child nr: " + nr);
                    continue;
                }
                if (sibling == this) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] I was child nr: " + nr);
                    }
                    found_me = true;
                    continue;
                }
                if (found_me) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] next sibling was child nr: " + nr);
                    }
                    return sibling;
                }
                if (!debug) continue;
                QuadBuckets.out("[" + this.level + "] nr: " + nr + " is before me, ignoring...");
            }
            return null;
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel nextSibling() {
            QBLevel next = this;
            QBLevel sibling = next.next_sibling();
            while (sibling == null) {
                if (debug) {
                    QuadBuckets.out("no siblings at level[" + next.level + "], moving to parent");
                }
                if ((next = next.parent) == null) break;
                sibling = next.next_sibling();
            }
            next = sibling;
            return next;
        }

        QBLevel firstChild() {
            QBLevel ret = null;
            for (QBLevel child : this.children) {
                if (child == null) continue;
                ret = child;
                break;
            }
            return ret;
        }

        QBLevel nextNode() {
            if (this.isLeaf()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel nextContentNode() {
            QBLevel next = this.nextNode();
            if (next == null) {
                return next;
            }
            if (next.hasContent()) {
                return next;
            }
            return next.nextContentNode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAdd(T o) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                this.__add_content(o);
                if (this.isLeaf() && this.content.size() > MAX_OBJECTS_PER_LEVEL && this.level < QuadTiling.NR_LEVELS) {
                    this.__split();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(T o) {
            Object object = QuadBuckets.this.split_lock;
            synchronized (object) {
                this.findBucket(((OsmPrimitive)o).getBBox()).doAdd(o);
            }
        }

        private void search(BBox search_bbox, List<T> result) {
            if (debug) {
                System.out.print("[" + this.level + "] qb bbox: " + this.bbox() + " ");
            }
            if (!this.bbox().intersects(search_bbox)) {
                if (debug) {
                    QuadBuckets.out("miss " + Long.toHexString(this.quad));
                }
                return;
            }
            if (this.hasContent()) {
                this.search_contents(search_bbox, result);
            }
            if (this.isLeaf()) {
                return;
            }
            if (debug) {
                QuadBuckets.out("hit " + this.quads());
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] not leaf, moving down");
            }
            for (int i = 0; i < this.children.length; ++i) {
                QBLevel q = this.children[i];
                if (debug) {
                    QuadBuckets.out("child[" + i + "]: " + q);
                }
                if (q == null) continue;
                if (debug) {
                    System.out.print(i + ": ");
                }
                q.search(search_bbox, result);
                if (!q.bbox().bounds(search_bbox)) continue;
                QuadBuckets.this.search_cache = q;
                if (!debug) break;
                QuadBuckets.out("break early");
                break;
            }
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        int index_of(QBLevel find_this) {
            if (this.isLeaf()) {
                return -1;
            }
            for (int i = 0; i < QuadTiling.TILES_PER_LEVEL; ++i) {
                if (this.children[i] != find_this) continue;
                return i;
            }
            return -1;
        }

        double width() {
            return this.bbox.width();
        }

        double height() {
            return this.bbox.height();
        }

        public BBox bbox() {
            return this.bbox;
        }

        LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }

        boolean hasChildren() {
            if (this.children == null) {
                return false;
            }
            for (QBLevel child : this.children) {
                if (child == null) continue;
                return true;
            }
            return false;
        }

        void remove_from_parent() {
            if (this.parent == null) {
                return;
            }
            int nr_siblings = 0;
            for (int i = 0; i < this.parent.children.length; ++i) {
                QBLevel sibling = this.parent.children[i];
                if (sibling != null) {
                    ++nr_siblings;
                }
                if (sibling != this) continue;
                if (!this.canRemove()) {
                    QuadBuckets.abort("attempt to remove non-empty child: " + this.content + " " + Arrays.toString(this.children));
                }
                this.parent.children[i] = null;
                --nr_siblings;
            }
            if (nr_siblings == 0) {
                this.parent.children = null;
            }
            if (this.parent.canRemove()) {
                this.parent.remove_from_parent();
            }
        }

        boolean canRemove() {
            if (this.content != null && this.content.size() > 0) {
                return false;
            }
            return !this.hasChildren();
        }
    }
}

