/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetCollection<T extends OsmPrimitive>
extends AbstractCollection<T> {
    private final Collection<? extends OsmPrimitive> primitives;
    private final Predicate<OsmPrimitive> predicate;

    public DatasetCollection(Collection<? extends OsmPrimitive> primitives, Predicate<OsmPrimitive> predicate) {
        this.primitives = primitives;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator(this.primitives.iterator());
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<? extends OsmPrimitive> iterator;
        private OsmPrimitive current;

        public FilterIterator(Iterator<? extends OsmPrimitive> iterator) {
            this.iterator = iterator;
        }

        private void findNext() {
            if (this.current == null) {
                while (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    if (!DatasetCollection.this.predicate.evaluate(this.current)) continue;
                    return;
                }
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.current != null;
        }

        @Override
        public T next() {
            this.findNext();
            OsmPrimitive old = this.current;
            this.current = null;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

