/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update data"), "updatedata", I18n.tr("Updates the objects in the active data layer from the server."), Shortcut.registerShortcut("file:updatedata", I18n.tr("Update data"), 85, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateData"));
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public void updateLayer(OsmDataLayer layer) {
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getEditLayer() == null) {
            return;
        }
        ArrayList<Area> areas = new ArrayList<Area>();
        for (DataSource ds : this.getEditLayer().data.dataSources) {
            areas.add(new Area(ds.bounds.asRect()));
        }
        for (i = 0; i < areas.size(); ++i) {
            for (int j = i + 1; j < areas.size(); ++j) {
                ((Area)areas.get(i)).subtract((Area)areas.get(j));
            }
        }
        for (i = areas.size() - 1; i > 0; --i) {
            for (int j = i - 1; j > 0; --j) {
                ((Area)areas.get(i)).subtract((Area)areas.get(j));
            }
        }
        ArrayList<Area> areasToDownload = new ArrayList<Area>();
        for (Area a : areas) {
            if (a.isEmpty()) continue;
            areasToDownload.add(a);
        }
        if (areasToDownload.isEmpty()) {
            new UpdateSelectionAction().updatePrimitives(this.getEditLayer().data.allPrimitives());
        } else {
            final PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Download data"));
            final Future<?> future = new DownloadOsmTaskList().download(false, (Collection<Area>)areasToDownload, (ProgressMonitor)monitor);
            Main.worker.submit(new Runnable(){

                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    monitor.close();
                }
            });
        }
    }
}

