/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    public SaveActionBase(String name, String iconName, String tooltip, Shortcut shortcut) {
        super(name, iconName, tooltip, shortcut);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.doSave();
    }

    public boolean doSave() {
        Layer layer = null;
        if (Main.isDisplayingMapView() && (Main.map.mapView.getActiveLayer() instanceof OsmDataLayer || Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            layer = Main.map.mapView.getActiveLayer();
        }
        if (layer == null) {
            return false;
        }
        return this.doSave(layer);
    }

    public boolean doSave(Layer layer) {
        if (layer == null) {
            return false;
        }
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        if (!this.checkSaveConditions(layer)) {
            return false;
        }
        File file = this.getFile(layer);
        if (file == null) {
            return false;
        }
        try {
            boolean exported = false;
            for (FileExporter exporter : ExtensionFileFilter.exporters) {
                if (!exporter.acceptFile(file, layer)) continue;
                exporter.exportData(file, layer);
                exported = true;
            }
            if (!exported) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No Exporter found! Nothing saved."), I18n.tr("Warning"), 2);
                return false;
            }
            layer.setName(file.getName());
            layer.setAssociatedFile(file);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).onPostSaveToFile();
            }
            Main.parent.repaint();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected abstract File getFile(Layer var1);

    public boolean checkSaveConditions(Layer layer) {
        ConflictCollection conflicts;
        if (layer instanceof OsmDataLayer && this.isDataSetEmpty((OsmDataLayer)layer)) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Empty document"), new String[]{I18n.tr("Save anyway"), I18n.tr("Cancel")});
            dialog.setContent(I18n.tr("The document contains no data."));
            dialog.setButtonIcons(new String[]{"save.png", "cancel.png"});
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                return false;
            }
        }
        if (layer instanceof GpxLayer && ((GpxLayer)layer).data == null) {
            return false;
        }
        if (layer instanceof OsmDataLayer && (conflicts = ((OsmDataLayer)layer).getConflicts()) != null && !conflicts.isEmpty()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Conflicts"), new String[]{I18n.tr("Reject Conflicts and Save"), I18n.tr("Cancel")});
            dialog.setContent(I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?"));
            dialog.setButtonIcons(new String[]{"save.png", "cancel.png"});
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                return false;
            }
        }
        return true;
    }

    public static File openFileDialog(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save OSM file"), "osm");
        }
        if (layer instanceof GpxLayer) {
            return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file"), "gpx");
        }
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer"), "lay");
    }

    private boolean isDataSetEmpty(OsmDataLayer layer) {
        for (OsmPrimitive osm : layer.data.allNonDeletedPrimitives()) {
            if (osm.isDeleted() && osm.isNewOrUndeleted()) continue;
            return false;
        }
        return true;
    }

    protected void updateEnabledState() {
        boolean check;
        if (Main.applet) {
            this.setEnabled(false);
            return;
        }
        boolean bl = check = Main.map != null && Main.map.mapView != null && Main.map.mapView.getActiveLayer() != null;
        if (!check) {
            this.setEnabled(false);
            return;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        this.setEnabled(layer instanceof OsmDataLayer || layer instanceof GpxLayer);
    }

    public static File createAndOpenSaveFileChooser(String title, String extension) {
        String fn;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        if (title != null) {
            fc.setDialogTitle(title);
        }
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter.applyChoosableExportFileFilters(fc, extension);
        int answer = fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        File file = fc.getSelectedFile();
        if (extension != null && (fn = file.getPath()).indexOf(46) == -1) {
            FileFilter ff = fc.getFileFilter();
            fn = ff instanceof ExtensionFileFilter ? fn + "." + ((ExtensionFileFilter)ff).getDefaultExtension() : fn + extension;
            file = new File(fn);
        }
        if (file == null || file.exists()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite"), new String[]{I18n.tr("Overwrite"), I18n.tr("Cancel")});
            dialog.setContent(I18n.tr("File exists. Overwrite?"));
            dialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                return null;
            }
        }
        return file;
    }
}

