/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class GpxExportAction
extends DiskAccessAction {
    public GpxExportAction() {
        super(I18n.tr("Export to GPX..."), "exportgpx", I18n.tr("Export the data to GPX file."), Shortcut.registerShortcut("file:exportgpx", I18n.tr("Export to GPX..."), 69, 2));
        this.putValue("help", HelpUtil.ht("/Action/GpxExport"));
    }

    protected GpxLayer getLayer() {
        if (!Main.isDisplayingMapView()) {
            return null;
        }
        if (Main.map.mapView.getActiveLayer() == null) {
            return null;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        if (!(layer instanceof GpxLayer)) {
            return null;
        }
        return (GpxLayer)layer;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        GpxLayer layer = this.getLayer();
        if (layer == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to export. Get some data first."), I18n.tr("Information"), 1);
            return;
        }
        this.export(layer);
    }

    public void export(Layer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        File file = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Export GPX file"), ".gpx");
        if (file == null) {
            return;
        }
        for (FileExporter exporter : ExtensionFileFilter.exporters) {
            if (!exporter.acceptFile(file, layer)) continue;
            try {
                exporter.exportData(file, layer);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void updateEnabledState() {
        boolean check;
        boolean bl = check = Main.isDisplayingMapView() && Main.map.mapView.getActiveLayer() != null;
        if (!check) {
            this.setEnabled(false);
            return;
        }
        Layer layer = Main.map.mapView.getActiveLayer();
        this.setEnabled(layer instanceof GpxLayer);
    }
}

