/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;

public class JSJavaMethod
extends JSJavaObject {
    private static final int FIELD_NAME = 0;
    private static final int FIELD_SIGNATURE = 1;
    private static final int FIELD_HOLDER = 2;
    private static final int FIELD_IS_PRIVATE = 3;
    private static final int FIELD_IS_PUBLIC = 4;
    private static final int FIELD_IS_PROTECTED = 5;
    private static final int FIELD_IS_PACKAGE_PRIVATE = 6;
    private static final int FIELD_IS_STATIC = 7;
    private static final int FIELD_IS_FINAL = 8;
    private static final int FIELD_IS_SYNCHRONIZED = 9;
    private static final int FIELD_IS_NATIVE = 10;
    private static final int FIELD_IS_ABSTRACT = 11;
    private static final int FIELD_IS_STRICT = 12;
    private static final int FIELD_IS_SYNTHETIC = 13;
    private static final int FIELD_IS_OBSOLETE = 14;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();

    public JSJavaMethod(Method m, JSJavaFactory fac) {
        super(m, fac);
    }

    public final Method getMethod() {
        return (Method)this.getOop();
    }

    public Object get(String name) {
        int fieldID = JSJavaMethod.getFieldID(name);
        Method method = this.getMethod();
        switch (fieldID) {
            case 0: {
                return method.getName().asString();
            }
            case 1: {
                return method.getSignature().asString();
            }
            case 2: {
                return this.getMethodHolder();
            }
            case 3: {
                return method.isPrivate();
            }
            case 4: {
                return method.isPublic();
            }
            case 5: {
                return method.isProtected();
            }
            case 6: {
                return method.isPackagePrivate();
            }
            case 7: {
                return method.isStatic();
            }
            case 8: {
                return method.isFinal();
            }
            case 9: {
                return method.isSynchronized();
            }
            case 10: {
                return method.isNative();
            }
            case 11: {
                return method.isAbstract();
            }
            case 12: {
                return method.isStrict();
            }
            case 13: {
                return method.isSynthetic();
            }
            case 14: {
                return method.isObsolete();
            }
        }
        return super.get(name);
    }

    public Object[] getIds() {
        Object[] fieldNames = fields.keySet().toArray();
        Object[] superFields = super.getIds();
        Object[] res = new Object[fieldNames.length + superFields.length];
        System.arraycopy(fieldNames, 0, res, 0, fieldNames.length);
        System.arraycopy(superFields, 0, res, fieldNames.length, superFields.length);
        return res;
    }

    public boolean has(String name) {
        if (JSJavaMethod.getFieldID(name) != -1) {
            return true;
        }
        return super.has(name);
    }

    public void put(String name, Object value) {
        if (JSJavaMethod.getFieldID(name) != -1) {
            return;
        }
        super.put(name, value);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Method ");
        buf.append(this.getMethod().externalNameAndSignature());
        return buf.toString();
    }

    private JSJavaObject getMethodHolder() {
        Klass k = this.getMethod().getMethodHolder();
        return this.factory.newJSJavaKlass(k).getJSJavaClass();
    }

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    static {
        JSJavaMethod.addField("name", 0);
        JSJavaMethod.addField("signature", 1);
        JSJavaMethod.addField("holder", 2);
        JSJavaMethod.addField("isPrivate", 3);
        JSJavaMethod.addField("isPublic", 4);
        JSJavaMethod.addField("isProtected", 5);
        JSJavaMethod.addField("isPackagePrivate", 6);
        JSJavaMethod.addField("isStatic", 7);
        JSJavaMethod.addField("isFinal", 8);
        JSJavaMethod.addField("isSynchronized", 9);
        JSJavaMethod.addField("isNative", 10);
        JSJavaMethod.addField("isAbstract", 11);
        JSJavaMethod.addField("isStrict", 12);
        JSJavaMethod.addField("isSynthetic", 13);
        JSJavaMethod.addField("isObsolete", 14);
    }
}

