/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.BaseIndexScaleDispAddress;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.x86.X86Register;
import sun.jvm.hotspot.asm.x86.X86SegmentRegister;

public class X86RegisterIndirectAddress
extends BaseIndexScaleDispAddress {
    private final X86SegmentRegister segReg;

    public X86RegisterIndirectAddress(X86SegmentRegister segReg, X86Register base, X86Register index, long disp, int scale) {
        super(base, index, disp, scale);
        this.segReg = segReg;
    }

    public X86RegisterIndirectAddress(X86SegmentRegister segReg, X86Register base, X86Register index, long disp) {
        super(base, index, disp, -1);
        this.segReg = segReg;
    }

    public String toString() {
        long disp;
        StringBuffer buf = new StringBuffer();
        if (this.segReg != null) {
            buf.append(this.segReg.toString());
            buf.append(":");
        }
        if ((disp = this.getDisplacement()) != 0L) {
            buf.append(disp);
        }
        Register base = this.getBase();
        Register index = this.getIndex();
        int scaleVal = this.getScale();
        scaleVal = 1 << scaleVal;
        if (base != null || index != null || scaleVal > 1) {
            buf.append('[');
        }
        if (base != null) {
            buf.append(base.toString());
            if (index != null) {
                buf.append("+");
                buf.append(index.toString());
            }
        } else if (index != null) {
            buf.append(index.toString());
        }
        if (scaleVal > 1) {
            buf.append(" * ");
            buf.append(Integer.toString(scaleVal));
        }
        if (base != null || index != null || scaleVal > 1) {
            buf.append(']');
        }
        return buf.toString();
    }
}

