/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCSpecialRegisterInstruction;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCWriteInstruction
extends SPARCSpecialRegisterInstruction {
    private final int specialReg;
    private final int asrRegNum;
    private final SPARCRegister rs1;
    private final ImmediateOrRegister operand2;

    public SPARCWriteInstruction(int specialReg, int asrRegNum, SPARCRegister rs1, ImmediateOrRegister operand2) {
        super("wr");
        this.specialReg = specialReg;
        this.asrRegNum = asrRegNum;
        this.rs1 = rs1;
        this.operand2 = operand2;
    }

    public int getSpecialRegister() {
        return this.specialReg;
    }

    public int getAncillaryRegister() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.specialReg == 4, "not an ancillary register");
        }
        return this.asrRegNum;
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.rs1.toString());
        buf.append(comma);
        if (this.operand2.isRegister()) {
            buf.append(this.operand2.toString());
        } else {
            Number number = ((Immediate)this.operand2).getNumber();
            buf.append("0x");
            buf.append(Integer.toHexString(number.intValue()));
        }
        buf.append(comma);
        if (this.specialReg == 4) {
            buf.append("%asr" + this.asrRegNum);
        } else {
            buf.append(SPARCWriteInstruction.getSpecialRegisterName(this.specialReg));
        }
        return buf.toString();
    }
}

