/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.BaseIndexScaleDispAddress;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;

public class SPARCRegisterIndirectAddress
extends BaseIndexScaleDispAddress {
    protected int addressSpace = -1;

    public SPARCRegisterIndirectAddress(SPARCRegister register, int offset) {
        super((Register)register, offset);
    }

    public SPARCRegisterIndirectAddress(SPARCRegister base, SPARCRegister index) {
        super((Register)base, index);
    }

    public int getAddressSpace() {
        return this.addressSpace;
    }

    public void setAddressSpace(int addressSpace) {
        this.addressSpace = addressSpace;
    }

    public String getAddressWithoutAsi() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.getBase().toString());
        Register register = this.getIndex();
        if (register != null) {
            buf.append(" + ");
            buf.append(register.toString());
        } else {
            long disp = this.getDisplacement();
            if (disp < 0L) {
                buf.append(" - 0x");
                disp = -disp;
            } else {
                buf.append(" + 0x");
            }
            buf.append(Long.toHexString(disp));
        }
        buf.append(']');
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getAddressWithoutAsi());
        if (this.addressSpace != -1) {
            buf.append(new Integer(this.addressSpace).toString());
        }
        return buf.toString();
    }
}

