/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CRLSelector;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CertImpl;

class CrlRevocationChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final TrustAnchor mAnchor;
    private final List<CertStore> mStores;
    private final String mSigProvider;
    private final Date mCurrentTime;
    private PublicKey mPrevPubKey;
    private boolean mCRLSignFlag;
    private HashSet<X509CRL> mPossibleCRLs;
    private HashSet<X509CRL> mApprovedCRLs;
    private final PKIXParameters mParams;
    private static final boolean[] mCrlSignUsage = new boolean[]{false, false, false, false, false, false, true};
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final long MAX_CLOCK_SKEW = 900000L;

    CrlRevocationChecker(TrustAnchor trustAnchor, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this(trustAnchor, pKIXParameters, null);
    }

    CrlRevocationChecker(TrustAnchor trustAnchor, PKIXParameters pKIXParameters, Collection<X509Certificate> collection) throws CertPathValidatorException {
        Date date;
        block3: {
            this.mAnchor = trustAnchor;
            this.mParams = pKIXParameters;
            this.mStores = new ArrayList<CertStore>(pKIXParameters.getCertStores());
            this.mSigProvider = pKIXParameters.getSigProvider();
            if (collection != null) {
                try {
                    this.mStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(collection)));
                }
                catch (Exception exception) {
                    if (debug == null) break block3;
                    debug.println("CrlRevocationChecker: error creating Collection CertStore: " + exception);
                }
            }
        }
        this.mCurrentTime = (date = pKIXParameters.getDate()) != null ? date : new Date();
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (!bl) {
            this.mPrevPubKey = this.mAnchor != null ? (this.mAnchor.getCAPublicKey() != null ? this.mAnchor.getCAPublicKey() : this.mAnchor.getTrustedCert().getPublicKey()) : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.mCRLSignFlag = true;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        this.verifyRevocationStatus(x509Certificate, this.mPrevPubKey, this.mCRLSignFlag, true);
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.mPrevPubKey);
        }
        this.mPrevPubKey = publicKey;
        this.mCRLSignFlag = CrlRevocationChecker.certCanSignCrl(x509Certificate);
    }

    public boolean check(X509Certificate x509Certificate, PublicKey publicKey, boolean bl) throws CertPathValidatorException {
        this.verifyRevocationStatus(x509Certificate, publicKey, bl, true);
        return CrlRevocationChecker.certCanSignCrl(x509Certificate);
    }

    static boolean certCanSignCrl(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            return blArray[6];
        }
        return false;
    }

    private void verifyRevocationStatus(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, boolean bl2) throws CertPathValidatorException {
        this.verifyRevocationStatus(x509Certificate, publicKey, bl, bl2, null);
    }

    private void verifyRevocationStatus(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, boolean bl2, Set<X509Certificate> set) throws CertPathValidatorException {
        Object object;
        Object object2;
        String string = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() ---checking " + string + "...");
        }
        if (set != null && set.contains(x509Certificate)) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        this.mPossibleCRLs = new HashSet();
        this.mApprovedCRLs = new HashSet();
        boolean[] blArray = new boolean[9];
        try {
            object2 = new X509CRLSelector();
            object2.setCertificateChecking(x509Certificate);
            CertPathHelper.setDateAndTime(object2, this.mCurrentTime, 900000L);
            for (CertStore object3 : this.mStores) {
                for (CRL cRL : object3.getCRLs((CRLSelector)object2)) {
                    this.mPossibleCRLs.add((X509CRL)cRL);
                }
            }
            object = DistributionPointFetcher.getInstance();
            this.mApprovedCRLs.addAll(((DistributionPointFetcher)object).getCRLs((X509CRLSelector)object2, bl, publicKey, this.mSigProvider, this.mStores, blArray, this.mAnchor));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() unexpected exception: " + exception.getMessage());
            }
            throw new CertPathValidatorException(exception);
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() crls.size() = " + this.mPossibleCRLs.size());
        }
        if (!this.mPossibleCRLs.isEmpty()) {
            this.mApprovedCRLs.addAll(this.verifyPossibleCRLs(this.mPossibleCRLs, x509Certificate, bl, publicKey, blArray));
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() approved crls.size() = " + this.mApprovedCRLs.size());
        }
        if (this.mApprovedCRLs.isEmpty() || !Arrays.equals(blArray, ALL_REASONS)) {
            if (bl2) {
                this.verifyWithSeparateSigningKey(x509Certificate, publicKey, bl, set);
                return;
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        if (debug != null) {
            object2 = x509Certificate.getSerialNumber();
            debug.println("starting the final sweep...");
            debug.println("CrlRevocationChecker.verifyRevocationStatus cert SN: " + ((BigInteger)object2).toString());
        }
        object2 = CRLReason.UNSPECIFIED;
        object = null;
        for (X509CRL x509CRL : this.mApprovedCRLs) {
            Set<String> set2;
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate);
            if (x509CRLEntry == null) continue;
            try {
                object = X509CRLEntryImpl.toImpl(x509CRLEntry);
            }
            catch (CRLException cRLException) {
                throw new CertPathValidatorException(cRLException);
            }
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus CRL entry: " + ((X509CRLEntryImpl)object).toString());
            }
            if ((set2 = ((X509CRLEntryImpl)object).getCriticalExtensionOIDs()) != null && !set2.isEmpty()) {
                set2.remove(PKIXExtensions.ReasonCode_Id.toString());
                set2.remove(PKIXExtensions.CertificateIssuer_Id.toString());
                if (!set2.isEmpty()) {
                    if (debug != null) {
                        debug.println("Unrecognized critical extension(s) in revoked CRL entry: " + set2);
                    }
                    throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                }
            }
            if ((object2 = ((X509CRLEntryImpl)object).getRevocationReason()) == null) {
                object2 = CRLReason.UNSPECIFIED;
            }
            CertificateRevokedException certificateRevokedException = new CertificateRevokedException(((X509CRLEntryImpl)object).getRevocationDate(), (CRLReason)((Object)object2), x509CRL.getIssuerX500Principal(), ((X509CRLEntryImpl)object).getExtensions());
            throw new CertPathValidatorException(((Throwable)certificateRevokedException).getMessage(), certificateRevokedException, null, -1, CertPathValidatorException.BasicReason.REVOKED);
        }
    }

    private void verifyWithSeparateSigningKey(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, Set<X509Certificate> set) throws CertPathValidatorException {
        String string = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyWithSeparateSigningKey() ---checking " + string + "...");
        }
        if (set != null && set.contains(x509Certificate)) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyWithSeparateSigningKey() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        if (!bl) {
            publicKey = null;
        }
        this.buildToNewKey(x509Certificate, publicKey, set);
    }

    private void buildToNewKey(X509Certificate x509Certificate, PublicKey publicKey, Set<X509Certificate> set) throws CertPathValidatorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PKIXBuilderParameters pKIXBuilderParameters;
        Set<TrustAnchor> set2;
        if (debug != null) {
            debug.println("CrlRevocationChecker.buildToNewKey() starting work");
        }
        HashSet<PublicKey> hashSet = new HashSet<PublicKey>();
        if (publicKey != null) {
            hashSet.add(publicKey);
        }
        RejectKeySelector rejectKeySelector = new RejectKeySelector(hashSet);
        rejectKeySelector.setSubject(x509Certificate.getIssuerX500Principal());
        rejectKeySelector.setKeyUsage(mCrlSignUsage);
        Set<TrustAnchor> set3 = set2 = this.mAnchor == null ? this.mParams.getTrustAnchors() : Collections.singleton(this.mAnchor);
        if (this.mParams instanceof PKIXBuilderParameters) {
            pKIXBuilderParameters = (PKIXBuilderParameters)this.mParams.clone();
            pKIXBuilderParameters.setTargetCertConstraints(rejectKeySelector);
            pKIXBuilderParameters.setPolicyQualifiersRejected(true);
            try {
                pKIXBuilderParameters.setTrustAnchors(set2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException);
            }
        }
        try {
            pKIXBuilderParameters = new PKIXBuilderParameters(set2, (CertSelector)rejectKeySelector);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
        pKIXBuilderParameters.setInitialPolicies(this.mParams.getInitialPolicies());
        pKIXBuilderParameters.setCertStores(this.mStores);
        pKIXBuilderParameters.setExplicitPolicyRequired(this.mParams.isExplicitPolicyRequired());
        pKIXBuilderParameters.setPolicyMappingInhibited(this.mParams.isPolicyMappingInhibited());
        pKIXBuilderParameters.setAnyPolicyInhibited(this.mParams.isAnyPolicyInhibited());
        pKIXBuilderParameters.setDate(this.mParams.getDate());
        pKIXBuilderParameters.setCertPathCheckers(this.mParams.getCertPathCheckers());
        pKIXBuilderParameters.setSigProvider(this.mParams.getSigProvider());
        pKIXBuilderParameters.setRevocationEnabled(false);
        if (Builder.USE_AIA) {
            block32: {
                object5 = null;
                try {
                    object5 = X509CertImpl.toImpl(x509Certificate);
                }
                catch (CertificateException certificateException) {
                    if (debug == null) break block32;
                    debug.println("CrlRevocationChecker.buildToNewKey: error decoding cert: " + certificateException);
                }
            }
            object4 = null;
            if (object5 != null) {
                object4 = ((X509CertImpl)object5).getAuthorityInfoAccessExtension();
            }
            if (object4 != null && (object3 = ((AuthorityInfoAccessExtension)object4).getAccessDescriptions()) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    AccessDescription accessDescription = object2.next();
                    object = URICertStore.getInstance(accessDescription);
                    if (object == null) continue;
                    if (debug != null) {
                        debug.println("adding AIAext CertStore");
                    }
                    pKIXBuilderParameters.addCertStore((CertStore)object);
                }
            }
        }
        object5 = null;
        try {
            object5 = CertPathBuilder.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        try {
            while (true) {
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() about to try build ...");
                }
                object4 = (PKIXCertPathBuilderResult)((CertPathBuilder)object5).build(pKIXBuilderParameters);
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() about to check revocation ...");
                }
                if (set == null) {
                    set = new HashSet<X509Certificate>();
                }
                set.add(x509Certificate);
                object3 = ((PKIXCertPathValidatorResult)object4).getTrustAnchor();
                object2 = ((TrustAnchor)object3).getCAPublicKey();
                if (object2 == null) {
                    object2 = ((TrustAnchor)object3).getTrustedCert().getPublicKey();
                }
                boolean bl = true;
                object = ((PKIXCertPathBuilderResult)object4).getCertPath().getCertificates();
                try {
                    for (int i = object.size() - 1; i >= 0; --i) {
                        X509Certificate x509Certificate2 = (X509Certificate)object.get(i);
                        if (debug != null) {
                            debug.println("CrlRevocationChecker.buildToNewKey() index " + i + " checking " + x509Certificate2);
                        }
                        this.verifyRevocationStatus(x509Certificate2, (PublicKey)object2, bl, true, set);
                        bl = CrlRevocationChecker.certCanSignCrl(x509Certificate2);
                        object2 = x509Certificate2.getPublicKey();
                    }
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    hashSet.add(((PKIXCertPathValidatorResult)object4).getPublicKey());
                    continue;
                }
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() got key " + ((PKIXCertPathValidatorResult)object4).getPublicKey());
                }
                PublicKey publicKey2 = ((PKIXCertPathValidatorResult)object4).getPublicKey();
                try {
                    this.verifyRevocationStatus(x509Certificate, publicKey2, true, false);
                    return;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    if (certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                        throw certPathValidatorException;
                    }
                    hashSet.add(publicKey2);
                    continue;
                }
                break;
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CertPathValidatorException(invalidAlgorithmParameterException);
        }
        catch (CertPathBuilderException certPathBuilderException) {
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private Collection<X509CRL> verifyPossibleCRLs(Set<X509CRL> set, X509Certificate x509Certificate, boolean bl, PublicKey publicKey, boolean[] blArray) throws CertPathValidatorException {
        try {
            Object object;
            Object object2;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("CRLRevocationChecker.verifyPossibleCRLs: Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            CRLDistributionPointsExtension cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension();
            List<Object> list = null;
            if (cRLDistributionPointsExtension == null) {
                object2 = (X500Name)x509CertImpl.getIssuerDN();
                object = new DistributionPoint(new GeneralNames().add(new GeneralName((GeneralNameInterface)object2)), null, null);
                list = Collections.singletonList(object);
            } else {
                list = (List<Object>)cRLDistributionPointsExtension.get("points");
            }
            object2 = new HashSet();
            object = DistributionPointFetcher.getInstance();
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !Arrays.equals(blArray, ALL_REASONS)) {
                DistributionPoint distributionPoint = (DistributionPoint)iterator.next();
                for (X509CRL x509CRL : set) {
                    if (!((DistributionPointFetcher)object).verifyCRL(x509CertImpl, distributionPoint, x509CRL, blArray, bl, publicKey, this.mSigProvider, this.mAnchor, this.mStores)) continue;
                    object2.add(x509CRL);
                }
            }
            return object2;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("Exception while verifying CRL: " + exception.getMessage());
                exception.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private static class RejectKeySelector
    extends X509CertSelector {
        private final Set<PublicKey> badKeySet;

        RejectKeySelector(Set<PublicKey> set) {
            this.badKeySet = set;
        }

        @Override
        public boolean match(Certificate certificate) {
            if (!super.match(certificate)) {
                return false;
            }
            if (this.badKeySet.contains(certificate.getPublicKey())) {
                if (debug != null) {
                    debug.println("RejectCertSelector.match: bad key");
                }
                return false;
            }
            if (debug != null) {
                debug.println("RejectCertSelector.match: returning true");
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RejectCertSelector: [\n");
            stringBuilder.append(super.toString());
            stringBuilder.append(this.badKeySet);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

