/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileRef;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.AccessController;
import java.security.Permission;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.nio.fs.AbstractPath;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixCopyFile;
import sun.nio.fs.UnixDirectoryStream;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixSecureDirectoryStream;
import sun.nio.fs.UnixUriUtils;

class UnixPath
extends AbstractPath {
    private static ThreadLocal<SoftReference<CharsetEncoder>> encoder = new ThreadLocal();
    private final UnixFileSystem fs;
    private final byte[] path;
    private volatile String stringValue;
    private int hash;
    private volatile int[] offsets;

    UnixPath(UnixFileSystem unixFileSystem, byte[] byArray) {
        this.fs = unixFileSystem;
        this.path = byArray;
    }

    UnixPath(UnixFileSystem unixFileSystem, String string) {
        this(unixFileSystem, UnixPath.encode(UnixPath.normalizeAndCheck(string)));
    }

    static String normalizeAndCheck(String string) {
        int n = string.length();
        if (n == 0) {
            throw new InvalidPathException(string, "Path is empty");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/' && n2 == 47) {
                return UnixPath.normalize(string, n, i - 1);
            }
            UnixPath.checkNotNul(string, c);
            n2 = c;
        }
        if (n2 == 47) {
            return UnixPath.normalize(string, n, n - 1);
        }
        return string;
    }

    private static void checkNotNul(String string, char c) {
        if (c == '\u0000') {
            throw new InvalidPathException(string, "Nul character not allowed");
        }
    }

    private static String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        for (n3 = n; n3 > 0 && string.charAt(n3 - 1) == '/'; --n3) {
        }
        if (n3 == 0) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (n2 > 0) {
            stringBuilder.append(string.substring(0, n2));
        }
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '/' && n4 == 47) continue;
            UnixPath.checkNotNul(string, c);
            stringBuilder.append(c);
            n4 = c;
        }
        return stringBuilder.toString();
    }

    private static byte[] encode(String string) {
        boolean bl;
        CharsetEncoder charsetEncoder;
        SoftReference<CharsetEncoder> softReference = encoder.get();
        CharsetEncoder charsetEncoder2 = charsetEncoder = softReference != null ? softReference.get() : null;
        if (charsetEncoder == null) {
            charsetEncoder = Charset.defaultCharset().newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            encoder.set(new SoftReference<CharsetEncoder>(charsetEncoder));
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[(int)((double)cArray.length * (double)charsetEncoder.maxBytesPerChar())];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        charsetEncoder.reset();
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (!coderResult.isUnderflow()) {
            bl = true;
        } else {
            coderResult = charsetEncoder.flush(byteBuffer);
            boolean bl2 = bl = !coderResult.isUnderflow();
        }
        if (bl) {
            throw new InvalidPathException(string, "Malformed input or input contains unmappable chacraters");
        }
        int n = byteBuffer.position();
        if (n != byArray.length) {
            byArray = Arrays.copyOf(byArray, n);
        }
        return byArray;
    }

    byte[] asByteArray() {
        return this.path;
    }

    byte[] getByteArrayForSysCalls() {
        if (this.getFileSystem().needToResolveAgainstDefaultDirectory()) {
            return UnixPath.resolve(this.getFileSystem().defaultDirectory(), this.path);
        }
        return this.path;
    }

    String getPathForExecptionMessage() {
        return this.toString();
    }

    String getPathForPermissionCheck() {
        if (this.getFileSystem().needToResolveAgainstDefaultDirectory()) {
            return new String(this.getByteArrayForSysCalls());
        }
        return this.toString();
    }

    private UnixPath checkPath(FileRef fileRef) {
        if (fileRef == null) {
            throw new NullPointerException();
        }
        if (!(fileRef instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)fileRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.path.length) {
                byte by;
                if ((by = this.path[n2++]) == 47) continue;
                ++n;
                while (n2 < this.path.length && this.path[n2] != 47) {
                    ++n2;
                }
            }
            int[] nArray = new int[n];
            n = 0;
            n2 = 0;
            while (n2 < this.path.length) {
                byte by = this.path[n2];
                if (by == 47) {
                    ++n2;
                    continue;
                }
                nArray[n++] = n2++;
                while (n2 < this.path.length && this.path[n2] != 47) {
                    ++n2;
                }
            }
            UnixPath unixPath = this;
            synchronized (unixPath) {
                if (this.offsets == null) {
                    this.offsets = nArray;
                }
            }
        }
    }

    @Override
    public UnixFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public UnixPath getRoot() {
        if (this.path[0] == 47) {
            return this.getFileSystem().rootDirectory();
        }
        return null;
    }

    @Override
    public UnixPath getName() {
        this.initOffsets();
        int n = this.offsets.length;
        if (n == 0) {
            return null;
        }
        if (n == 1 && this.path[0] != 47) {
            return this;
        }
        int n2 = this.offsets[n - 1];
        int n3 = this.path.length - n2;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.path, n2, byArray, 0, n3);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public UnixPath getParent() {
        this.initOffsets();
        int n = this.offsets.length;
        if (n == 0) {
            return null;
        }
        int n2 = this.offsets[n - 1] - 1;
        if (n2 <= 0) {
            return this.getRoot();
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.path, 0, byArray, 0, n2);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public UnixPath getName(int n) {
        this.initOffsets();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int n2 = this.offsets[n];
        int n3 = n == this.offsets.length - 1 ? this.path.length - n2 : this.offsets[n + 1] - n2 - 1;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.path, n2, byArray, 0, n3);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public UnixPath subpath(int n, int n2) {
        this.initOffsets();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (n2 > this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (n >= n2) {
            throw new IllegalArgumentException();
        }
        int n3 = this.offsets[n];
        int n4 = n2 == this.offsets.length ? this.path.length - n3 : this.offsets[n2] - n3 - 1;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.path, n3, byArray, 0, n4);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public boolean isAbsolute() {
        return this.path[0] == 47;
    }

    private static byte[] resolve(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (byArray2[0] == 47) {
            return byArray2;
        }
        if (byArray.length == 1 && byArray[0] == 47) {
            byArray3 = new byte[byArray2.length + 1];
            byArray3[0] = 47;
            System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        } else {
            byArray3 = new byte[byArray.length + 1 + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray3[byArray.length] = 47;
            System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        }
        return byArray3;
    }

    @Override
    public UnixPath resolve(Path path) {
        if (path == null) {
            return this;
        }
        byte[] byArray = this.checkPath((FileRef)path).path;
        if (byArray[0] == 47) {
            return (UnixPath)path;
        }
        byte[] byArray2 = UnixPath.resolve(this.path, byArray);
        return new UnixPath(this.getFileSystem(), byArray2);
    }

    @Override
    public UnixPath resolve(String string) {
        return this.resolve(new UnixPath(this.getFileSystem(), string));
    }

    UnixPath resolve(byte[] byArray) {
        return this.resolve(new UnixPath(this.getFileSystem(), byArray));
    }

    @Override
    public UnixPath relativize(Path path) {
        int n;
        int n2;
        int n3;
        UnixPath unixPath = this.checkPath(path);
        if (unixPath.equals(this)) {
            return null;
        }
        if (this.isAbsolute() != unixPath.isAbsolute()) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        int n4 = this.getNameCount();
        int n5 = n4 > (n3 = unixPath.getNameCount()) ? n3 : n4;
        for (n2 = 0; n2 < n5 && this.getName(n2).equals(unixPath.getName(n2)); ++n2) {
        }
        if (n2 < n3) {
            UnixPath unixPath2 = unixPath.subpath(n2, n3);
            if (n == 0) {
                return unixPath2;
            }
            byte[] byArray = new byte[n * 3 + unixPath2.path.length];
            int n6 = 0;
            for (n = n4 - n2; n > 0; --n) {
                byArray[n6++] = 46;
                byArray[n6++] = 46;
                byArray[n6++] = 47;
            }
            System.arraycopy(unixPath2.path, 0, byArray, n6, unixPath2.path.length);
            return new UnixPath(this.getFileSystem(), byArray);
        }
        byte[] byArray = new byte[n * 3 - 1];
        int n7 = 0;
        while (n > 0) {
            byArray[n7++] = 46;
            byArray[n7++] = 46;
            if (n > 1) {
                byArray[n7++] = 47;
            }
            --n;
        }
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public Path normalize() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getNameCount();
        if (n5 == 0) {
            return this;
        }
        boolean[] blArray = new boolean[n5];
        int[] nArray = new int[n5];
        int n6 = n5;
        boolean bl = false;
        boolean bl2 = this.path[0] == 47;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.offsets[n4];
            n2 = n4 == this.offsets.length - 1 ? this.path.length - n3 : this.offsets[n4 + 1] - n3 - 1;
            nArray[n4] = n2;
            if (this.path[n3] != 46) continue;
            if (n2 == 1) {
                blArray[n4] = true;
                --n6;
                continue;
            }
            if (this.path[n3 + 1] != 46) continue;
            bl = true;
        }
        if (bl) {
            do {
                n4 = n6;
                n3 = -1;
                for (n2 = 0; n2 < n5; ++n2) {
                    if (blArray[n2]) continue;
                    if (nArray[n2] != 2) {
                        n3 = n2;
                        continue;
                    }
                    n = this.offsets[n2];
                    if (this.path[n] != 46 || this.path[n + 1] != 46) {
                        n3 = n2;
                        continue;
                    }
                    if (n3 >= 0) {
                        blArray[n3] = true;
                        blArray[n2] = true;
                        n6 -= 2;
                        n3 = -1;
                        continue;
                    }
                    if (!bl2) continue;
                    boolean bl3 = false;
                    for (int i = 0; i < n2; ++i) {
                        if (blArray[i]) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    blArray[n2] = true;
                    --n6;
                }
            } while (n4 > n6);
        }
        if (n6 == n5) {
            return this;
        }
        if (n6 == 0) {
            return bl2 ? this.getFileSystem().rootDirectory() : null;
        }
        n4 = n6 - 1;
        if (bl2) {
            ++n4;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (blArray[n3]) continue;
            n4 += nArray[n3];
        }
        byte[] byArray = new byte[n4];
        n2 = 0;
        if (bl2) {
            byArray[n2++] = 47;
        }
        for (n = 0; n < n5; ++n) {
            if (blArray[n]) continue;
            System.arraycopy(this.path, this.offsets[n], byArray, n2, nArray[n]);
            n2 += nArray[n];
            if (--n6 <= 0) continue;
            byArray[n2++] = 47;
        }
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public boolean startsWith(Path path) {
        int n;
        UnixPath unixPath = this.checkPath(path);
        if (unixPath.path.length > this.path.length) {
            return false;
        }
        int n2 = this.getNameCount();
        int n3 = unixPath.getNameCount();
        if (n3 == 0 && this.isAbsolute()) {
            return true;
        }
        if (n3 > n2) {
            return false;
        }
        if (n3 == n2 && this.path.length != unixPath.path.length) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            Integer n4;
            Integer n5 = this.offsets[n];
            if (n5.equals(n4 = Integer.valueOf(unixPath.offsets[n]))) continue;
            return false;
        }
        for (n = 0; n < unixPath.path.length; ++n) {
            if (this.path[n] == unixPath.path[n]) continue;
            return false;
        }
        return n >= this.path.length || this.path[n] == 47;
    }

    @Override
    public boolean endsWith(Path path) {
        int n;
        UnixPath unixPath = this.checkPath(path);
        if (unixPath.path.length > this.path.length) {
            return false;
        }
        if (unixPath.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        int n2 = this.getNameCount();
        int n3 = unixPath.getNameCount();
        if (n3 > n2) {
            return false;
        }
        if (n3 == n2) {
            if (n2 == 0) {
                return true;
            }
            n = this.path.length;
            if (this.isAbsolute() && !unixPath.isAbsolute()) {
                --n;
            }
            if (unixPath.path.length != n) {
                return false;
            }
        } else if (unixPath.isAbsolute()) {
            return false;
        }
        n = this.offsets[n2 - n3];
        int n4 = unixPath.offsets[0];
        while (n4 < unixPath.path.length) {
            if (this.path[n++] == unixPath.path[n4++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Path path) {
        int n = this.path.length;
        int n2 = ((UnixPath)path).path.length;
        int n3 = Math.min(n, n2);
        byte[] byArray = this.path;
        byte[] byArray2 = ((UnixPath)path).path;
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = byArray2[i] & 0xFF;
            if (n4 == n5) continue;
            return n4 - n5;
        }
        return n - n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof UnixPath) {
            return this.compareTo((Path)object) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            for (int i = 0; i < this.path.length; ++i) {
                n = 31 * n + (this.path[i] & 0xFF);
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = new String(this.path);
        }
        return this.stringValue;
    }

    @Override
    public Iterator<Path> iterator() {
        this.initOffsets();
        return new Iterator<Path>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < UnixPath.this.offsets.length;
            }

            @Override
            public Path next() {
                if (this.i < UnixPath.this.offsets.length) {
                    UnixPath unixPath = UnixPath.this.getName(this.i);
                    ++this.i;
                    return unixPath;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    int openForAttributeAccess(boolean bl) throws IOException {
        int n = 0;
        if (!bl) {
            n |= 0x100;
        }
        try {
            return UnixNativeDispatcher.open(this, n, 0);
        }
        catch (UnixException unixException) {
            if (this.getFileSystem().isSolaris() && unixException.errno() == 22) {
                unixException.setError(62);
            }
            if (unixException.errno() == 62) {
                throw new FileSystemException(this.getPathForExecptionMessage(), null, unixException.getMessage() + " or unable to access attributes of symbolic link");
            }
            unixException.rethrowAsIOException(this);
            return -1;
        }
    }

    void checkRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.getPathForPermissionCheck());
        }
    }

    void checkWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.getPathForPermissionCheck());
        }
    }

    void checkDelete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.getPathForPermissionCheck());
        }
    }

    @Override
    public FileStore getFileStore() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            this.checkRead();
        }
        return this.getFileSystem().getFileStore(this);
    }

    @Override
    public void checkAccess(AccessMode ... accessModeArray) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (accessModeArray.length == 0) {
            bl = true;
        } else {
            block7: for (AccessMode accessMode : accessModeArray) {
                switch (accessMode) {
                    case READ: {
                        bl2 = true;
                        continue block7;
                    }
                    case WRITE: {
                        bl3 = true;
                        continue block7;
                    }
                    case EXECUTE: {
                        bl4 = true;
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)"Should not get here");
                    }
                }
            }
        }
        int n = 0;
        if (bl || bl2) {
            this.checkRead();
            n |= bl2 ? 4 : 0;
        }
        if (bl3) {
            this.checkWrite();
            n |= 2;
        }
        if (bl4) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkExec(this.getPathForPermissionCheck());
            }
            n |= 1;
        }
        try {
            UnixNativeDispatcher.access(this, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this);
        }
    }

    @Override
    void implDelete(boolean bl) throws IOException {
        this.checkDelete();
        UnixFileAttributes unixFileAttributes = null;
        try {
            unixFileAttributes = UnixFileAttributes.get(this, false);
            if (unixFileAttributes.isDirectory()) {
                UnixNativeDispatcher.rmdir(this);
            } else {
                UnixNativeDispatcher.unlink(this);
            }
        }
        catch (UnixException unixException) {
            if (!bl && unixException.errno() == 2) {
                return;
            }
            if (unixFileAttributes != null && unixFileAttributes.isDirectory() && (unixException.errno() == 17 || unixException.errno() == 66)) {
                throw new DirectoryNotEmptyException(this.getPathForExecptionMessage());
            }
            unixException.rethrowAsIOException(this);
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.checkRead();
        if (!UnixNativeDispatcher.supportsAtSysCalls()) {
            try {
                long l = UnixNativeDispatcher.opendir(this);
                return new UnixDirectoryStream(this, l, filter);
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 20) {
                    throw new NotDirectoryException(this.getPathForExecptionMessage());
                }
                unixException.rethrowAsIOException(this);
            }
        }
        int n = -1;
        int n2 = -1;
        long l = 0L;
        try {
            n = UnixNativeDispatcher.open(this, 0, 0);
            n2 = UnixNativeDispatcher.dup(n);
            l = UnixNativeDispatcher.fdopendir(n);
        }
        catch (UnixException unixException) {
            if (n != -1) {
                UnixNativeDispatcher.close(n);
            }
            if (n2 != -1) {
                UnixNativeDispatcher.close(n2);
            }
            if (unixException.errno() == 20) {
                throw new NotDirectoryException(this.getPathForExecptionMessage());
            }
            unixException.rethrowAsIOException(this);
        }
        return new UnixSecureDirectoryStream(this, l, n2, filter);
    }

    @Override
    public void implCopyTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        UnixPath unixPath = (UnixPath)path;
        UnixCopyFile.copy(this, unixPath, copyOptionArray);
    }

    @Override
    public void implMoveTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        UnixPath unixPath = (UnixPath)path;
        UnixCopyFile.move(this, unixPath, copyOptionArray);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> clazz, LinkOption ... linkOptionArray) {
        V v = this.getFileSystem().newFileAttributeView(clazz, this, linkOptionArray);
        if (v == null) {
            return null;
        }
        return v;
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(String string, LinkOption ... linkOptionArray) {
        return this.getFileSystem().newFileAttributeView(string, this, linkOptionArray);
    }

    @Override
    public Path createDirectory(FileAttribute<?> ... fileAttributeArray) throws IOException {
        this.checkWrite();
        int n = UnixFileModeAttribute.toUnixMode(511, fileAttributeArray);
        try {
            UnixNativeDispatcher.mkdir(this, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this);
        }
        return this;
    }

    @Override
    public SeekableByteChannel newByteChannel(Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        int n = UnixFileModeAttribute.toUnixMode(438, fileAttributeArray);
        try {
            return UnixChannelFactory.newFileChannel(this, set, n);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this);
            return null;
        }
    }

    @Override
    public boolean isSameFile(Path path) throws IOException {
        UnixFileAttributes unixFileAttributes;
        UnixFileAttributes unixFileAttributes2;
        if (this.equals(path)) {
            return true;
        }
        if (!(path instanceof UnixPath)) {
            return false;
        }
        UnixPath unixPath = (UnixPath)path;
        this.checkRead();
        unixPath.checkRead();
        try {
            unixFileAttributes2 = UnixFileAttributes.get(this, true);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this);
            return false;
        }
        try {
            unixFileAttributes = UnixFileAttributes.get(unixPath, true);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
            return false;
        }
        return unixFileAttributes2.isSameFile(unixFileAttributes);
    }

    @Override
    public Path createSymbolicLink(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.checkPath(path);
        if (fileAttributeArray.length > 0) {
            UnixFileModeAttribute.toUnixMode(0, fileAttributeArray);
            throw new UnsupportedOperationException("Initial file attributesnot supported when creating symbolic link");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("symbolic"));
            this.checkWrite();
        }
        try {
            UnixNativeDispatcher.symlink(unixPath.asByteArray(), this);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this);
        }
        return this;
    }

    @Override
    public Path createLink(Path path) throws IOException {
        UnixPath unixPath = this.checkPath(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("hard"));
            this.checkWrite();
            unixPath.checkWrite();
        }
        try {
            UnixNativeDispatcher.link(unixPath, this);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this, unixPath);
        }
        return this;
    }

    @Override
    public Path readSymbolicLink() throws IOException {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new FilePermission(this.getPathForPermissionCheck(), "readlink");
            AccessController.checkPermission((Permission)object);
        }
        try {
            object = UnixNativeDispatcher.readlink(this);
            return new UnixPath(this.getFileSystem(), (byte[])object);
        }
        catch (UnixException unixException) {
            if (unixException.errno() == 22) {
                throw new NotLinkException(this.getPathForExecptionMessage());
            }
            unixException.rethrowAsIOException(this);
            return null;
        }
    }

    @Override
    public UnixPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.dir");
        }
        return new UnixPath(this.getFileSystem(), UnixPath.resolve(this.getFileSystem().defaultDirectory(), this.path));
    }

    @Override
    public UnixPath toRealPath(boolean bl) throws IOException {
        UnixPath unixPath;
        this.checkRead();
        UnixPath unixPath2 = this.toAbsolutePath();
        if (bl) {
            try {
                byte[] byArray = UnixNativeDispatcher.realpath(unixPath2);
                return new UnixPath(this.getFileSystem(), byArray);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this);
            }
        }
        UnixPath unixPath3 = unixPath = this.getFileSystem().rootDirectory();
        for (int i = 0; i < unixPath2.getNameCount(); ++i) {
            UnixPath unixPath4 = unixPath2.getName(i);
            if (unixPath4.asByteArray().length == 1 && unixPath4.asByteArray()[0] == 46) continue;
            if (unixPath4.asByteArray().length == 2 && unixPath4.asByteArray()[0] == 46 && unixPath4.asByteArray()[1] == 46) {
                UnixFileAttributes unixFileAttributes = null;
                try {
                    unixFileAttributes = UnixFileAttributes.get(unixPath3, false);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(unixPath3);
                }
                if (!unixFileAttributes.isSymbolicLink()) {
                    if ((unixPath3 = unixPath3.getParent()) != null) continue;
                    unixPath3 = unixPath;
                    continue;
                }
            }
            unixPath3 = unixPath3.resolve(unixPath4);
        }
        return unixPath3;
    }

    @Override
    public boolean isHidden() {
        this.checkRead();
        UnixPath unixPath = this.getName();
        if (unixPath == null) {
            return false;
        }
        return unixPath.asByteArray()[0] == 46;
    }

    @Override
    public URI toUri() {
        return UnixUriUtils.toUri(this);
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        if (watchService == null) {
            throw new NullPointerException();
        }
        if (!(watchService instanceof AbstractWatchService)) {
            throw new ProviderMismatchException();
        }
        this.checkRead();
        return ((AbstractWatchService)watchService).register(this, kindArray, modifierArray);
    }
}

