/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousDatagramChannel;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.IllegalChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import sun.nio.ch.EPollPort;
import sun.nio.ch.Port;
import sun.nio.ch.SimpleAsynchronousDatagramChannelImpl;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.UnixAsynchronousServerSocketChannelImpl;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;

public class LinuxAsynchronousChannelProvider
extends AsynchronousChannelProvider {
    private static volatile EPollPort defaultPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EPollPort defaultEventPort() throws IOException {
        if (defaultPort != null) return defaultPort;
        Class<LinuxAsynchronousChannelProvider> clazz = LinuxAsynchronousChannelProvider.class;
        synchronized (LinuxAsynchronousChannelProvider.class) {
            if (defaultPort != null) return defaultPort;
            defaultPort = new EPollPort(this, ThreadPool.getDefault()).start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultPort;
        }
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(int n, ThreadFactory threadFactory) throws IOException {
        return new EPollPort(this, ThreadPool.create(n, threadFactory)).start();
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executorService, int n) throws IOException {
        return new EPollPort(this, ThreadPool.wrap(executorService, n)).start();
    }

    private Port toPort(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        if (asynchronousChannelGroup == null) {
            return this.defaultEventPort();
        }
        if (!(asynchronousChannelGroup instanceof EPollPort)) {
            throw new IllegalChannelGroupException();
        }
        return (Port)asynchronousChannelGroup;
    }

    @Override
    public AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new UnixAsynchronousServerSocketChannelImpl(this.toPort(asynchronousChannelGroup));
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new UnixAsynchronousSocketChannelImpl(this.toPort(asynchronousChannelGroup));
    }

    @Override
    public AsynchronousDatagramChannel openAsynchronousDatagramChannel(ProtocolFamily protocolFamily, AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new SimpleAsynchronousDatagramChannelImpl(protocolFamily, this.toPort(asynchronousChannelGroup));
    }
}

