/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.anon;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import sun.dyn.anon.ConstantPoolParser;
import sun.dyn.anon.ConstantPoolVisitor;
import sun.dyn.anon.InvalidConstantPoolFormatException;

public class ConstantPoolPatch {
    final ConstantPoolParser outer;
    final Object[] patchArray;
    private static final int CONSTANT_MemberRef_MASK = 11;
    private static final Map<Class<?>, Byte> CONSTANT_VALUE_CLASS_TAG;
    private static final Class[] CONSTANT_VALUE_CLASS;

    ConstantPoolPatch(ConstantPoolParser constantPoolParser) {
        this.outer = constantPoolParser;
        this.patchArray = new Object[constantPoolParser.getLength()];
    }

    public ConstantPoolPatch(byte[] byArray) throws InvalidConstantPoolFormatException {
        this(new ConstantPoolParser(byArray));
    }

    public ConstantPoolPatch(Class<?> clazz) throws IOException, InvalidConstantPoolFormatException {
        this(new ConstantPoolParser(clazz));
    }

    public ConstantPoolPatch(ConstantPoolPatch constantPoolPatch) {
        this.outer = constantPoolPatch.outer;
        this.patchArray = (Object[])constantPoolPatch.patchArray.clone();
    }

    public ConstantPoolParser getParser() {
        return this.outer;
    }

    public byte getTag(int n) {
        return this.outer.getTag(n);
    }

    public Object getPatch(int n) {
        String[] stringArray = this.patchArray[n];
        if (stringArray == null) {
            return null;
        }
        switch (this.getTag(n)) {
            case 9: 
            case 10: 
            case 11: {
                if (!(stringArray instanceof String)) break;
                stringArray = ConstantPoolPatch.stripSemis(2, (String)stringArray);
                break;
            }
            case 12: {
                if (!(stringArray instanceof String)) break;
                stringArray = ConstantPoolPatch.stripSemis(1, (String)stringArray);
            }
        }
        return stringArray;
    }

    public void clear() {
        Arrays.fill(this.patchArray, null);
    }

    public void clear(int n) {
        this.patchArray[n] = null;
    }

    public Object[] getPatches() {
        return (Object[])this.patchArray.clone();
    }

    public Object[] getOriginalCP() throws InvalidConstantPoolFormatException {
        return this.getOriginalCP(0, this.patchArray.length, -1);
    }

    public void putPatches(final Map<String, String> map, final Map<String, Object> map2, final Map<Object, Object> map3, boolean bl) throws InvalidConstantPoolFormatException {
        HashSet hashSet;
        HashSet hashSet2;
        HashSet hashSet3;
        if (bl) {
            hashSet3 = map == null ? null : new HashSet();
            hashSet2 = map2 == null ? null : new HashSet();
            hashSet = map3 == null ? null : new HashSet();
        } else {
            hashSet3 = null;
            hashSet2 = null;
            hashSet = null;
        }
        this.outer.parse(new ConstantPoolVisitor(){

            @Override
            public void visitUTF8(int n, byte by, String string) {
                ConstantPoolPatch.this.putUTF8(n, (String)map.get(string));
                if (hashSet3 != null) {
                    hashSet3.add(string);
                }
            }

            @Override
            public void visitConstantValue(int n, byte by, Object object) {
                ConstantPoolPatch.this.putConstantValue(n, by, map3.get(object));
                if (hashSet != null) {
                    hashSet.add(object);
                }
            }

            @Override
            public void visitConstantString(int n, byte by, String string, int n2) {
                if (by == 7) {
                    ConstantPoolPatch.this.putConstantValue(n, by, map2.get(string));
                    if (hashSet2 != null) {
                        hashSet2.add(string);
                    }
                } else {
                    assert (by == 8);
                    this.visitConstantValue(n, by, string);
                }
            }
        });
        if (hashSet3 != null) {
            map.keySet().removeAll(hashSet3);
        }
        if (hashSet2 != null) {
            map2.keySet().removeAll(hashSet2);
        }
        if (hashSet != null) {
            map3.keySet().removeAll(hashSet);
        }
    }

    Object[] getOriginalCP(final int n, final int n2, final int n3) throws InvalidConstantPoolFormatException {
        final Object[] objectArray = new Object[n2 - n];
        this.outer.parse(new ConstantPoolVisitor(){

            void show(int n4, byte by, Object object) {
                if (n4 < n || n4 >= n2) {
                    return;
                }
                if ((1 << by & n3) == 0) {
                    return;
                }
                objectArray[n4 - n] = object;
            }

            @Override
            public void visitUTF8(int n4, byte by, String string) {
                this.show(n4, by, string);
            }

            @Override
            public void visitConstantValue(int n4, byte by, Object object) {
                assert (by != 8);
                this.show(n4, by, object);
            }

            @Override
            public void visitConstantString(int n4, byte by, String string, int n22) {
                this.show(n4, by, string);
            }

            @Override
            public void visitMemberRef(int n4, byte by, String string, String string2, String string3, int n22, int n32) {
                this.show(n4, by, new String[]{string, string2, string3});
            }

            @Override
            public void visitDescriptor(int n4, byte by, String string, String string2, int n22, int n32) {
                this.show(n4, by, new String[]{string, string2});
            }
        });
        return objectArray;
    }

    void writeHead(OutputStream outputStream) throws IOException {
        this.outer.writePatchedHead(outputStream, this.patchArray);
    }

    void writeTail(OutputStream outputStream) throws IOException {
        this.outer.writeTail(outputStream);
    }

    private void checkConstantTag(byte by, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("invalid null constant value");
        }
        if (ConstantPoolPatch.classForTag(by) != object.getClass()) {
            throw new IllegalArgumentException("invalid constant value" + (by == 0 ? "" : " for tag " + ConstantPoolVisitor.tagName(by)) + " of class " + object.getClass());
        }
    }

    private void checkTag(int n, byte by) {
        byte by2 = this.outer.tags[n];
        if (by2 != by) {
            throw new IllegalArgumentException("invalid put operation for " + ConstantPoolVisitor.tagName(by) + " at index " + n + " found " + ConstantPoolVisitor.tagName(by2));
        }
    }

    private void checkTagMask(int n, int n2) {
        int n3;
        byte by = this.outer.tags[n];
        int n4 = n3 = (by & 0x1F) == by ? 1 << by : 0;
        if ((n3 & n2) == 0) {
            throw new IllegalArgumentException("invalid put operation at index " + n + " found " + ConstantPoolVisitor.tagName(by));
        }
    }

    private static void checkMemberName(String string) {
        if (string.indexOf(59) >= 0) {
            throw new IllegalArgumentException("memberName " + string + " contains a ';'");
        }
    }

    public void putUTF8(int n, String string) {
        if (string == null) {
            this.clear(n);
            return;
        }
        this.checkTag(n, (byte)1);
        this.patchArray[n] = string;
    }

    public void putConstantValue(int n, Object object) {
        if (object == null) {
            this.clear(n);
            return;
        }
        byte by = ConstantPoolPatch.tagForConstant(object.getClass());
        this.checkConstantTag(by, object);
        this.checkTag(n, by);
        this.patchArray[n] = object;
    }

    public void putConstantValue(int n, byte by, Object object) {
        if (object == null) {
            this.clear(n);
            return;
        }
        this.checkTag(n, by);
        if (by == 7 && object instanceof String) {
            ConstantPoolPatch.checkClassName((String)object);
        } else if (by != 8) {
            this.checkConstantTag(by, object);
        }
        this.checkTag(n, by);
        this.patchArray[n] = object;
    }

    public void putDescriptor(int n, String string, String string2) {
        this.checkTag(n, (byte)12);
        ConstantPoolPatch.checkMemberName(string);
        this.patchArray[n] = ConstantPoolPatch.addSemis(string, string2);
    }

    public void putMemberRef(int n, byte by, String string, String string2, String string3) {
        this.checkTagMask(by, 11);
        this.checkTag(n, by);
        ConstantPoolPatch.checkClassName(string);
        ConstantPoolPatch.checkMemberName(string2);
        if (string3.startsWith("(") == (by == 9)) {
            throw new IllegalArgumentException("bad signature: " + string3);
        }
        this.patchArray[n] = ConstantPoolPatch.addSemis(string, string2, string3);
    }

    static Class<?> classForTag(byte by) {
        if ((by & 0xFF) >= CONSTANT_VALUE_CLASS.length) {
            return null;
        }
        return CONSTANT_VALUE_CLASS[by];
    }

    static byte tagForConstant(Class<?> clazz) {
        Byte by = CONSTANT_VALUE_CLASS_TAG.get(clazz);
        return by == null ? (byte)0 : by;
    }

    private static void checkClassName(String string) {
        if (string.indexOf(47) >= 0 || string.indexOf(59) >= 0) {
            throw new IllegalArgumentException("invalid class name " + string);
        }
    }

    static String addSemis(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 5);
        stringBuilder.append(string);
        for (String string2 : stringArray) {
            stringBuilder.append(';').append(string2);
        }
        String string3 = stringBuilder.toString();
        assert (ConstantPoolPatch.stripSemis(stringArray.length, string3)[0].equals(string));
        assert (ConstantPoolPatch.stripSemis(stringArray.length, string3)[1].equals(stringArray[0]));
        assert (stringArray.length == 1 || ConstantPoolPatch.stripSemis(stringArray.length, string3)[2].equals(stringArray[1]));
        return string3;
    }

    static String[] stripSemis(int n, String string) {
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.indexOf(59, n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            stringArray[i] = string.substring(n2, n3);
            n2 = n3;
        }
        stringArray[n] = string.substring(n2);
        return stringArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("{");
        Object[] objectArray = null;
        for (int i = 0; i < this.patchArray.length; ++i) {
            if (this.patchArray[i] == null) continue;
            if (objectArray != null) {
                stringBuilder.append(", ");
            } else {
                try {
                    objectArray = this.getOriginalCP();
                }
                catch (InvalidConstantPoolFormatException invalidConstantPoolFormatException) {
                    objectArray = new Object[]{};
                }
            }
            String string = i < objectArray.length ? objectArray[i] : "?";
            stringBuilder.append((Object)string).append("=").append(this.patchArray[i]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static {
        Object[][] objectArrayArray;
        CONSTANT_VALUE_CLASS_TAG = new IdentityHashMap();
        CONSTANT_VALUE_CLASS = new Class[16];
        for (Object[] objectArray : objectArrayArray = new Object[][]{{Integer.class, (byte)3}, {Long.class, (byte)5}, {Float.class, (byte)4}, {Double.class, (byte)6}, {String.class, (byte)8}, {Class.class, (byte)7}}) {
            Class clazz = (Class)objectArray[0];
            Byte by = (Byte)objectArray[1];
            CONSTANT_VALUE_CLASS_TAG.put(clazz, by);
            ConstantPoolPatch.CONSTANT_VALUE_CLASS[by.byteValue()] = clazz;
        }
    }
}

