/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.dyn.Access;
import sun.dyn.MethodHandleNatives;
import sun.dyn.util.BytecodeSignature;

public final class MemberName
implements Member,
Cloneable {
    private Class<?> clazz;
    private String name;
    private Object type;
    private int flags;
    private Object vmtarget;
    private int vmindex = -99;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    static final String CONSTRUCTOR_NAME = "<init>";
    static final int RECOGNIZED_MODIFIERS = 65535;
    static final int IS_METHOD = 65536;
    static final int IS_CONSTRUCTOR = 131072;
    static final int IS_FIELD = 262144;
    static final int IS_TYPE = 524288;
    static final int SEARCH_SUPERCLASSES = 0x100000;
    static final int SEARCH_INTERFACES = 0x200000;
    static final int ALL_ACCESS = 7;
    static final int ALL_KINDS = 983040;
    static final int IS_INVOCABLE = 196608;
    static final int IS_FIELD_OR_METHOD = 327680;
    static final int SEARCH_ALL_SUPERS = 0x300000;

    @Override
    public Class<?> getDeclaringClass() {
        if (this.clazz == null && this.isResolved()) {
            this.expandFromVM();
        }
        return this.clazz;
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.expandFromVM();
            if (this.name == null) {
                return null;
            }
        }
        return this.name;
    }

    public MethodType getMethodType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (!this.isInvocable()) {
            throw MemberName.newIllegalArgumentException("not invocable, no method type");
        }
        if (this.type instanceof MethodType) {
            return (MethodType)this.type;
        }
        if (this.type instanceof String) {
            String string = (String)this.type;
            MethodType methodType = MethodType.fromBytecodeString(string, this.getClassLoader());
            this.type = methodType;
            return methodType;
        }
        if (this.type instanceof Object[]) {
            Object[] objectArray = (Object[])this.type;
            Class[] classArray = (Class[])objectArray[1];
            Class clazz = (Class)objectArray[0];
            MethodType methodType = MethodType.make(clazz, classArray);
            this.type = methodType;
            return methodType;
        }
        throw new InternalError("bad method type " + this.type);
    }

    public MethodType getInvocationType() {
        MethodType methodType = this.getMethodType();
        if (!this.isStatic()) {
            methodType = methodType.insertParameterType(0, this.clazz);
        }
        return methodType;
    }

    public Class<?>[] getParameterTypes() {
        return this.getMethodType().parameterArray();
    }

    public Class<?> getReturnType() {
        return this.getMethodType().returnType();
    }

    public Class<?> getFieldType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.isInvocable()) {
            throw MemberName.newIllegalArgumentException("not a field or nested class, no simple type");
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof String) {
            Class<?> clazz;
            String string = (String)this.type;
            MethodType methodType = MethodType.fromBytecodeString("()" + string, this.getClassLoader());
            this.type = clazz = methodType.returnType();
            return clazz;
        }
        throw new InternalError("bad field type " + this.type);
    }

    public Object getType() {
        return this.isInvocable() ? this.getMethodType() : this.getFieldType();
    }

    public String getSignature() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.type instanceof String) {
            return (String)this.type;
        }
        if (this.isInvocable()) {
            return BytecodeSignature.unparse(this.getMethodType());
        }
        return BytecodeSignature.unparse(this.getFieldType());
    }

    @Override
    public int getModifiers() {
        return this.flags & 0xFFFF;
    }

    private void setFlags(int n) {
        this.flags = n;
        assert (this.testAnyFlags(983040));
    }

    private boolean testFlags(int n, int n2) {
        return (this.flags & n) == n2;
    }

    private boolean testAllFlags(int n) {
        return this.testFlags(n, n);
    }

    private boolean testAnyFlags(int n) {
        return !this.testFlags(n, 0);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.flags);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.flags);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.flags);
    }

    public boolean isBridge() {
        return this.testAllFlags(65600);
    }

    public boolean isVarargs() {
        return this.testAllFlags(128) && this.isInvocable();
    }

    @Override
    public boolean isSynthetic() {
        return this.testAllFlags(4096);
    }

    public boolean isInvocable() {
        return this.testAnyFlags(196608);
    }

    public boolean isFieldOrMethod() {
        return this.testAnyFlags(327680);
    }

    public boolean isMethod() {
        return this.testAllFlags(65536);
    }

    public boolean isConstructor() {
        return this.testAllFlags(131072);
    }

    public boolean isField() {
        return this.testAllFlags(262144);
    }

    public boolean isType() {
        return this.testAllFlags(524288);
    }

    public boolean isPackage() {
        return !this.testAnyFlags(7);
    }

    private void init(Class<?> clazz, String string, Object object, int n) {
        string.toString();
        object.equals(object);
        this.clazz = clazz;
        this.name = string;
        this.type = object;
        this.setFlags(n);
        assert (!this.isResolved());
    }

    private void expandFromVM() {
        if (!this.isResolved()) {
            return;
        }
        if (this.type instanceof Object[]) {
            this.type = null;
        }
        MethodHandleNatives.expand(this);
    }

    private static int flagsMods(int n, int n2) {
        assert ((n & 0xFFFF) == 0);
        assert ((n2 & 0xFFFF0000) == 0);
        return n | n2;
    }

    public MemberName(Method method) {
        Object[] objectArray = new Object[]{method.getReturnType(), method.getParameterTypes()};
        this.init(method.getDeclaringClass(), method.getName(), objectArray, MemberName.flagsMods(65536, method.getModifiers()));
        MethodHandleNatives.init(this, method);
        assert (this.isResolved());
    }

    public MemberName(Constructor constructor) {
        Object[] objectArray = new Object[]{Void.TYPE, constructor.getParameterTypes()};
        this.init(constructor.getDeclaringClass(), CONSTRUCTOR_NAME, objectArray, MemberName.flagsMods(131072, constructor.getModifiers()));
        MethodHandleNatives.init(this, constructor);
        assert (this.isResolved());
    }

    public MemberName(Field field) {
        this.init(field.getDeclaringClass(), field.getName(), field.getType(), MemberName.flagsMods(262144, field.getModifiers()));
        MethodHandleNatives.init(this, field);
        assert (this.isResolved());
    }

    public MemberName(Class<?> clazz) {
        this.init(clazz.getDeclaringClass(), clazz.getSimpleName(), clazz, MemberName.flagsMods(524288, clazz.getModifiers()));
        this.vmindex = 0;
        assert (this.isResolved());
    }

    MemberName() {
    }

    protected MemberName clone() {
        try {
            return (MemberName)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public MemberName(Class<?> clazz, String string, Class<?> clazz2, int n) {
        this.init(clazz, string, clazz2, 0x40000 | n & 0xFFFF);
    }

    public MemberName(Class<?> clazz, String string, Class<?> clazz2) {
        this(clazz, string, clazz2, 0);
    }

    public MemberName(Class<?> clazz, String string, MethodType methodType, int n) {
        int n2 = string.equals(CONSTRUCTOR_NAME) ? 131072 : 65536;
        this.init(clazz, string, methodType, n2 | n & 0xFFFF);
    }

    public MemberName(Class<?> clazz, String string, MethodType methodType) {
        this(clazz, string, methodType, 0);
    }

    boolean isResolved() {
        return this.vmindex != -99;
    }

    public boolean hasReceiverTypeDispatch() {
        return this.isMethod() && this.getVMIndex(Access.TOKEN) >= 0;
    }

    public String toString() {
        if (this.isType()) {
            return this.type.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getDeclaringClass() != null) {
            stringBuilder.append(MemberName.getName(this.clazz));
            stringBuilder.append('.');
        }
        stringBuilder.append(this.getName());
        if (!this.isInvocable()) {
            stringBuilder.append('/');
        }
        stringBuilder.append(MemberName.getName(this.getType()));
        return stringBuilder.toString();
    }

    private static String getName(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return object.toString();
    }

    public int getVMIndex(Access access) {
        Access.check(access);
        if (!this.isResolved()) {
            throw this.newIllegalStateException("not resolved");
        }
        return this.vmindex;
    }

    private RuntimeException newIllegalStateException(String string) {
        return new IllegalStateException(string + ": " + this);
    }

    public static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    public static NoAccessException newNoAccessException(MemberName memberName, Class<?> clazz) {
        return MemberName.newNoAccessException("cannot access", memberName, clazz);
    }

    public static NoAccessException newNoAccessException(String string, MemberName memberName, Class<?> clazz) {
        string = string + ": " + memberName;
        if (clazz != null) {
            string = string + ", from " + clazz.getName();
        }
        return new NoAccessException(string);
    }

    public static Factory getFactory(Access access) {
        Access.check(access);
        return Factory.INSTANCE;
    }

    public static Factory getFactory() {
        return MemberName.getFactory(Access.getToken());
    }

    public static class Factory {
        static Factory INSTANCE = new Factory();
        private static int ALLOWED_FLAGS = 0x3F0000;

        private Factory() {
        }

        List<MemberName> getMembers(Class<?> clazz, String string, Object object, int n, Class<?> clazz2) {
            n &= ALLOWED_FLAGS;
            String string2 = null;
            if (object != null) {
                string2 = BytecodeSignature.unparse(object);
                n = string2.startsWith("(") ? (n &= 0xFFF3FFFF) : (n &= 0xFFF4FFFF);
            }
            int n2 = string == null ? 10 : (object == null ? 4 : 1);
            MemberName[] memberNameArray = Factory.newMemberBuffer(n2);
            int n3 = 0;
            ArrayList<MemberName[]> arrayList = null;
            while (true) {
                int n4;
                if ((n4 = MethodHandleNatives.getMembers(clazz, string, string2, n, clazz2, n3, memberNameArray)) <= memberNameArray.length) {
                    if (n4 < 0) break;
                    n3 += n4;
                    break;
                }
                n3 += memberNameArray.length;
                int n5 = n4 - memberNameArray.length;
                if (arrayList == null) {
                    arrayList = new ArrayList<MemberName[]>(1);
                }
                arrayList.add(memberNameArray);
                int n6 = memberNameArray.length;
                n6 = Math.max(n6, n5);
                n6 = Math.max(n6, n3 / 4);
                memberNameArray = Factory.newMemberBuffer(Math.min(8192, n6));
            }
            ArrayList<MemberName> arrayList2 = new ArrayList<MemberName>(n3);
            if (arrayList != null) {
                for (MemberName[] memberNameArray2 : arrayList) {
                    Collections.addAll(arrayList2, memberNameArray2);
                }
            }
            Collections.addAll(arrayList2, memberNameArray);
            if (object != null && object != string2) {
                Iterator<MemberName> iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    MemberName memberName = iterator.next();
                    if (object.equals(memberName.getType())) continue;
                    iterator.remove();
                }
            }
            return arrayList2;
        }

        boolean resolveInPlace(MemberName memberName, boolean bl, Class<?> clazz) {
            MethodHandleNatives.resolve(memberName, clazz);
            if (memberName.isResolved()) {
                return true;
            }
            int n = memberName.flags | (bl ? 0x300000 : 0);
            String string = memberName.getSignature();
            MemberName[] memberNameArray = new MemberName[]{memberName};
            int n2 = MethodHandleNatives.getMembers(memberName.getDeclaringClass(), memberName.getName(), string, n, clazz, 0, memberNameArray);
            if (n2 != 1) {
                return false;
            }
            return memberName.isResolved();
        }

        public MemberName resolveOrNull(MemberName memberName, boolean bl, Class<?> clazz) {
            MemberName memberName2 = memberName.clone();
            if (this.resolveInPlace(memberName2, bl, clazz)) {
                return memberName2;
            }
            return null;
        }

        public MemberName resolveOrFail(MemberName memberName, boolean bl, Class<?> clazz) {
            MemberName memberName2 = this.resolveOrNull(memberName, bl, clazz);
            if (memberName2 != null) {
                return memberName2;
            }
            throw MemberName.newNoAccessException(memberName, clazz);
        }

        public List<MemberName> getMethods(Class<?> clazz, boolean bl, Class<?> clazz2) {
            return this.getMethods(clazz, bl, null, null, clazz2);
        }

        public List<MemberName> getMethods(Class<?> clazz, boolean bl, String string, MethodType methodType, Class<?> clazz2) {
            int n = 0x10000 | (bl ? 0x300000 : 0);
            return this.getMembers(clazz, string, methodType, n, clazz2);
        }

        public List<MemberName> getConstructors(Class<?> clazz, Class<?> clazz2) {
            return this.getMembers(clazz, null, null, 131072, clazz2);
        }

        public List<MemberName> getFields(Class<?> clazz, boolean bl, Class<?> clazz2) {
            return this.getFields(clazz, bl, null, null, clazz2);
        }

        public List<MemberName> getFields(Class<?> clazz, boolean bl, String string, Class<?> clazz2, Class<?> clazz3) {
            int n = 0x40000 | (bl ? 0x300000 : 0);
            return this.getMembers(clazz, string, clazz2, n, clazz3);
        }

        public List<MemberName> getNestedTypes(Class<?> clazz, boolean bl, Class<?> clazz2) {
            int n = 0x80000 | (bl ? 0x300000 : 0);
            return this.getMembers(clazz, null, null, n, clazz2);
        }

        private static MemberName[] newMemberBuffer(int n) {
            MemberName[] memberNameArray = new MemberName[n];
            for (int i = 0; i < n; ++i) {
                memberNameArray[i] = new MemberName();
            }
            return memberNameArray;
        }
    }
}

