/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants,
Closeable {
    private long jzfile;
    private String name;
    private int total;
    private boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private ZipCoder zc;
    private Set<ZipFileInputStream> streams = new HashSet<ZipFileInputStream>();
    private Vector inflaters = new Vector();
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        this(file, n, Charset.forName("UTF-8"));
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int n, Charset charset) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
        this.jzfile = ZipFile.open(string, n, file.lastModified());
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    public ZipFile(String string, Charset charset) throws IOException {
        this(new File(string), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            byte[] byArray = ZipFile.getCommentBytes(this.jzfile);
            if (byArray == null) {
                return null;
            }
            return this.zc.toString(byArray, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l = ZipFile.getEntry(this.jzfile, this.zc.getBytes(string), true);
            if (l != 0L) {
                ZipEntry zipEntry = this.getZipEntry(string, l);
                ZipFile.freeEntry(this.jzfile, l);
                return zipEntry;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            throw new NullPointerException("entry");
        }
        long l = 0L;
        ZipFileInputStream zipFileInputStream = null;
        Closeable closeable = this;
        synchronized (closeable) {
            this.ensureOpen();
            l = !this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? ZipFile.getEntry(this.jzfile, this.zc.getBytesUTF8(zipEntry.name), false) : ZipFile.getEntry(this.jzfile, this.zc.getBytes(zipEntry.name), false);
            if (l == 0L) {
                return null;
            }
            zipFileInputStream = new ZipFileInputStream(l);
            this.streams.add(zipFileInputStream);
        }
        closeable = zipFileInputStream;
        switch (ZipFile.getEntryMethod(l)) {
            case 0: {
                return closeable;
            }
            case 8: {
                long l2 = ZipFile.getEntrySize(l) + 2L;
                if (l2 > 65536L) {
                    l2 = 8192L;
                }
                if (l2 <= 0L) {
                    l2 = 4096L;
                }
                return new InflaterInputStream((InputStream)closeable, this.getInflater(), (int)l2, (ZipFileInputStream)closeable){
                    private boolean isClosed;
                    private boolean eof;
                    final /* synthetic */ ZipFileInputStream val$zfin;
                    {
                        this.val$zfin = zipFileInputStream;
                        super(inputStream, inflater, n);
                        this.isClosed = false;
                    }

                    @Override
                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    @Override
                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }

                    @Override
                    public int available() throws IOException {
                        if (this.isClosed) {
                            return 0;
                        }
                        long l = this.val$zfin.size() - this.inf.getBytesWritten();
                        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int n = this.inflaters.size();
            if (n > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n - 1);
                return inflater;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            inflater.reset();
            this.inflaters.add(inflater);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new Enumeration<ZipEntry>(){
            private int i = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    return this.i < ZipFile.this.total;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZipEntry nextElement() throws NoSuchElementException {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    if (this.i >= ZipFile.this.total) {
                        throw new NoSuchElementException();
                    }
                    long l = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                    if (l == 0L) {
                        String string = ZipFile.this.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                        throw new ZipError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                    }
                    ZipEntry zipEntry = ZipFile.this.getZipEntry(null, l);
                    ZipFile.freeEntry(ZipFile.this.jzfile, l);
                    return zipEntry;
                }
            }
        };
    }

    private ZipEntry getZipEntry(String string, long l) {
        byte[] byArray;
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.flag = ZipFile.getEntryFlag(l);
        if (string != null) {
            zipEntry.name = string;
        } else {
            byArray = ZipFile.getEntryBytes(l, 0);
            zipEntry.name = !this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? this.zc.toStringUTF8(byArray, byArray.length) : this.zc.toString(byArray, byArray.length);
        }
        zipEntry.time = ZipFile.getEntryTime(l);
        zipEntry.crc = ZipFile.getEntryCrc(l);
        zipEntry.size = ZipFile.getEntrySize(l);
        zipEntry.csize = ZipFile.getEntryCSize(l);
        zipEntry.method = ZipFile.getEntryMethod(l);
        zipEntry.extra = ZipFile.getEntryBytes(l, 1);
        byArray = ZipFile.getEntryBytes(l, 2);
        zipEntry.comment = byArray == null ? null : (!this.zc.isUTF8() && (zipEntry.flag & 0x800) != 0 ? this.zc.toStringUTF8(byArray, byArray.length) : this.zc.toString(byArray, byArray.length));
        return zipEntry;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.closeRequested = true;
            if (this.streams.size() != 0) {
                Set<ZipFileInputStream> set = this.streams;
                this.streams = new HashSet<ZipFileInputStream>();
                for (ZipFileInputStream object : set) {
                    object.close();
                }
            }
            if (this.jzfile != 0L) {
                long l = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(l);
                Vector vector = this.inflaters;
                synchronized (vector) {
                    int n = this.inflaters.size();
                    for (int i = 0; i < n; ++i) {
                        Inflater inflater = (Inflater)this.inflaters.get(i);
                        inflater.end();
                    }
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private static native long open(String var0, int var1, long var2) throws IOException;

    private static native int getTotal(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
    }

    private class ZipFileInputStream
    extends InputStream {
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long l) {
            this.rem = ZipFile.getEntryCSize(l);
            this.size = ZipFile.getEntrySize(l);
            this.jzentry = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.rem == 0L) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.rem) {
                n2 = (int)this.rem;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                n2 = ZipFile.read(ZipFile.this.jzfile, this.jzentry, this.pos, byArray, n, n2);
            }
            if (n2 > 0) {
                this.pos += (long)n2;
                this.rem -= (long)n2;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long l) {
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            if (this.rem == 0L) {
                this.close();
            }
            return l;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.rem = 0L;
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
                ZipFile.this.streams.remove(this);
            }
        }
    }
}

