/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new FutureTask<T>(runnable, t);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> runnableFuture = this.newTaskFor(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(runnable, t);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> collection, boolean bl, long l) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException executionException;
        ArrayList arrayList;
        block18: {
            if (collection == null) {
                throw new NullPointerException();
            }
            int n = collection.size();
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            arrayList = new ArrayList(n);
            ExecutorCompletionService<T> executorCompletionService = new ExecutorCompletionService<T>(this);
            executionException = null;
            long l2 = bl ? System.nanoTime() : 0L;
            Iterator<Callable<T>> iterator = collection.iterator();
            arrayList.add(executorCompletionService.submit(iterator.next()));
            --n;
            int n2 = 1;
            while (true) {
                Object v;
                Future future;
                if ((future = executorCompletionService.poll()) == null) {
                    if (n > 0) {
                        --n;
                        arrayList.add(executorCompletionService.submit(iterator.next()));
                        ++n2;
                    } else {
                        if (n2 == 0) break;
                        if (bl) {
                            future = executorCompletionService.poll(l, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            long l3 = System.nanoTime();
                            l -= l3 - l2;
                            l2 = l3;
                        } else {
                            future = executorCompletionService.take();
                        }
                    }
                }
                if (future == null) continue;
                --n2;
                try {
                    v = future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    executionException = new ExecutionException(runtimeException);
                    continue;
                }
                return (T)v;
                break;
            }
            if (executionException != null) break block18;
            executionException = new ExecutionException();
        }
        throw executionException;
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(collection, true, timeUnit.toNanos(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        if (collection == null) {
            throw new NullPointerException();
        }
        ArrayList<RunnableFuture<T>> arrayList = new ArrayList<RunnableFuture<T>>(collection.size());
        boolean bl = false;
        try {
            for (Callable<T> object : collection) {
                RunnableFuture<T> runnableFuture = this.newTaskFor(object);
                arrayList.add(runnableFuture);
                this.execute(runnableFuture);
            }
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            bl = true;
            ArrayList<RunnableFuture<T>> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        if (collection == null || timeUnit == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        boolean bl = false;
        try {
            for (Callable<T> callable : collection) {
                arrayList.add(this.newTaskFor(callable));
            }
            long l3 = System.nanoTime();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.execute((Runnable)iterator.next());
                long l4 = System.nanoTime();
                l3 = l4;
                if ((l2 -= l4 - l3) > 0L) continue;
                ArrayList<Future<T>> arrayList2 = arrayList;
                return arrayList2;
            }
            for (Future object : arrayList) {
                if (object.isDone()) continue;
                if (l2 <= 0L) {
                    ArrayList<Future<T>> arrayList3 = arrayList;
                    return arrayList3;
                }
                try {
                    object.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    ArrayList<Future<T>> arrayList4 = arrayList;
                    if (!bl) {
                        for (Future future : arrayList) {
                            future.cancel(true);
                        }
                    }
                    return arrayList4;
                }
                long l5 = System.nanoTime();
                l2 -= l5 - l3;
                l3 = l5;
            }
            bl = true;
            ArrayList<Future<T>> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }
}

