/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;

class TempFileHelper {
    private TempFileHelper() {
    }

    private static File create(String string, String string2, FileAttribute[] fileAttributeArray, boolean bl) throws IOException {
        if (PermissionsHolder.hasPosixPermissions) {
            if (fileAttributeArray.length == 0) {
                fileAttributeArray = new FileAttribute[]{bl ? PermissionsHolder.directoryPermissions : PermissionsHolder.filePermissions};
            } else {
                boolean bl2 = false;
                for (int i = 0; i < fileAttributeArray.length; ++i) {
                    if (!fileAttributeArray[i].name().equals("posix:permissions")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[fileAttributeArray.length + 1];
                    System.arraycopy(fileAttributeArray, 0, fileAttributeArray2, 0, fileAttributeArray.length);
                    fileAttributeArray = fileAttributeArray2;
                    fileAttributeArray[fileAttributeArray.length - 1] = bl ? PermissionsHolder.directoryPermissions : PermissionsHolder.filePermissions;
                }
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        while (true) {
            File file = File.TempDirectory.location();
            File file2 = File.TempDirectory.generateFile(string, string2, file);
            try {
                if (bl) {
                    file2.toPath().createDirectory(fileAttributeArray);
                } else {
                    file2.toPath().createFile(fileAttributeArray);
                }
                return file2;
            }
            catch (InvalidPathException invalidPathException) {
                if (securityManager != null) {
                    throw new IllegalArgumentException("Invalid prefix or suffix");
                }
                throw invalidPathException;
            }
            catch (SecurityException securityException) {
                if (securityManager != null) {
                    throw new SecurityException("Unable to create temporary file");
                }
                throw securityException;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    static File createFile(String string, String string2, FileAttribute[] fileAttributeArray) throws IOException {
        return TempFileHelper.create(string, string2, fileAttributeArray, false);
    }

    static File createDirectory(String string, FileAttribute[] fileAttributeArray) throws IOException {
        return TempFileHelper.create(string, "", fileAttributeArray, true);
    }

    private static class PermissionsHolder {
        static final boolean hasPosixPermissions = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        static final FileAttribute<Set<PosixFilePermission>> filePermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        static final FileAttribute<Set<PosixFilePermission>> directoryPermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));

        private PermissionsHolder() {
        }
    }
}

