/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.NativeLibLoader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InputEvent
extends ComponentEvent {
    private static final Logger log = Logger.getLogger("java.awt.event.InputEvent");
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    private static final int[] BUTTON_DOWN_MASK = new int[]{1024, 2048, 4096, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
    static final int FIRST_HIGH_BIT = Integer.MIN_VALUE;
    static final int JDK_1_3_MODIFIERS = 63;
    static final int HIGH_MODIFIERS = Integer.MIN_VALUE;
    long when;
    int modifiers;
    private transient boolean canAccessSystemClipboard;
    static final long serialVersionUID = -2482525981698309786L;

    private static int[] getButtonDownMasks() {
        return Arrays.copyOf(BUTTON_DOWN_MASK, BUTTON_DOWN_MASK.length);
    }

    public static int getMaskForButton(int n) {
        if (n <= 0 || n > BUTTON_DOWN_MASK.length) {
            throw new IllegalArgumentException("button doesn't exist " + n);
        }
        return BUTTON_DOWN_MASK[n - 1];
    }

    private static native void initIDs();

    InputEvent(Component component, int n, long l, int n2) {
        super(component, n);
        this.when = l;
        this.modifiers = n2;
        this.canAccessSystemClipboard = this.canAccessSystemClipboard();
    }

    private boolean canAccessSystemClipboard() {
        boolean bl = false;
        if (!GraphicsEnvironment.isHeadless()) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSystemClipboardAccess();
                    bl = true;
                }
                catch (SecurityException securityException) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "InputEvent.canAccessSystemClipboard() got SecurityException ", securityException);
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers & 0x8000003F;
    }

    public int getModifiersEx() {
        return this.modifiers & 0xFFFFFFC0;
    }

    @Override
    public void consume() {
        this.consumed = true;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public static String getModifiersExText(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x100) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuilder.append("+");
        }
        if ((n & 0x80) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuilder.append("+");
        }
        if ((n & 0x200) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuilder.append("+");
        }
        if ((n & 0x40) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuilder.append("+");
        }
        if ((n & 0x2000) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            stringBuilder.append("+");
        }
        int n2 = 1;
        for (int n3 : BUTTON_DOWN_MASK) {
            if ((n & n3) != 0) {
                stringBuilder.append(Toolkit.getProperty("AWT.button" + n2, "Button" + n2));
                stringBuilder.append("+");
            }
            ++n2;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    static {
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            InputEvent.initIDs();
        }
    }
}

