/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ant.AntMessageImpl;
import fr.jayasoft.ivy.ant.IvyConfigure;
import fr.jayasoft.ivy.ant.IvyResolve;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class IvyTask
extends Task {
    public static final String ANT_PROJECT_CONTEXT_KEY = "ant-project";
    private Boolean _validate = null;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    protected boolean doValidate(Ivy ivy) {
        if (this._validate != null) {
            return this._validate;
        }
        return ivy.doValidate();
    }

    public boolean isValidate() {
        return this._validate == null ? true : this._validate;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    protected Ivy getIvyInstance() {
        this.ensureMessageInitialised();
        Object ref = this.getProject().getReference("ivy.instances");
        if (ref != null && !(ref instanceof Map)) {
            throw new BuildException("ivy problem with ant: ivy.instances reference is not a Map. Please do not sett ivy.instances reference in your ant project. current reference: " + ref + " class=" + ref.getClass() + " classloader=" + ref.getClass().getClassLoader());
        }
        Map instances = (Map)ref;
        if (instances == null || !instances.containsKey(Ivy.class)) {
            Message.verbose("no ivy instance found: auto configuring ivy");
            IvyConfigure configure = new IvyConfigure();
            configure.setProject(this.getProject());
            configure.execute();
            instances = (Map)this.getProject().getReference("ivy.instances");
            if (instances == null || !instances.containsKey(Ivy.class)) {
                throw new BuildException("ivy internal problem: impossible to get ivy instance after configure... maybe a classloader problem");
            }
        }
        return (Ivy)instances.get(Ivy.class);
    }

    protected void ensureMessageInitialised() {
        if (!Message.isInitialised()) {
            Message.init(new AntMessageImpl(this));
        }
    }

    protected void setIvyInstance(Ivy ivy) {
        this.getProject().addReference("ivy.instance", (Object)ivy);
        if (ivy != null) {
            Message.debug("setting ivy.instance on " + this.getProject() + ": " + ivy + " class=" + ivy.getClass().getName() + " classloader=" + ivy.getClass().getClassLoader());
            HashMap instances = (HashMap)this.getProject().getReference("ivy.instances");
            if (instances == null) {
                instances = new HashMap();
                this.getProject().addReference("ivy.instances", instances);
            }
            instances.put(ivy.getClass(), ivy);
        }
    }

    protected void setResolved(ResolveReport report, boolean keep) {
        ModuleDescriptor md = report.getModuleDescriptor();
        String[] confs = report.getConfigurations();
        if (keep) {
            this.getProject().addReference("ivy.resolved.report", (Object)report);
            this.getProject().addReference("ivy.resolved.configurations.ref", (Object)confs);
            this.getProject().addReference("ivy.resolved.descriptor", (Object)md);
        }
        String suffix = md.getModuleRevisionId().getModuleId().getOrganisation() + "." + md.getModuleRevisionId().getModuleId().getName();
        this.getProject().addReference("ivy.resolved.report." + suffix, (Object)report);
        this.getProject().addReference("ivy.resolved.descriptor." + suffix, (Object)md);
        this.getProject().addReference("ivy.resolved.configurations.ref." + suffix, (Object)confs);
    }

    protected void ensureResolved(boolean haltOnFailure, boolean useOrigin, String org, String module) {
        this.ensureResolved(haltOnFailure, useOrigin, true, org, module, null);
    }

    protected void ensureResolved(boolean haltOnFailure, boolean useOrigin, boolean transitive, String org, String module, String conf) {
        this.ensureMessageInitialised();
        Object[] confs = this.getConfsToResolve(org, module, conf, false);
        if (confs.length > 0) {
            IvyResolve resolve = this.createResolve(haltOnFailure, useOrigin);
            resolve.setTransitive(transitive);
            resolve.setConf(StringUtils.join(confs, ", "));
            resolve.execute();
        }
    }

    protected String[] getConfsToResolve(String org, String module, String conf, boolean strict) {
        ModuleDescriptor reference = (ModuleDescriptor)this.getResolvedDescriptor(org, module, strict);
        Message.debug("calculating configurations to resolve");
        if (reference == null) {
            Message.debug("module not yet resolved, all confs still need to be resolved");
            if (conf == null) {
                return new String[]{"*"};
            }
            return this.splitConfs(conf);
        }
        if (conf != null) {
            String[] rconfs = this.getResolvedConfigurations(org, module, strict);
            String[] confs = "*".equals(conf) ? reference.getConfigurationsNames() : this.splitConfs(conf);
            HashSet<String> rconfsSet = new HashSet<String>(Arrays.asList(rconfs));
            HashSet<String> confsSet = new HashSet<String>(Arrays.asList(confs));
            Message.debug("resolved configurations:   " + rconfsSet);
            Message.debug("asked configurations:      " + confsSet);
            confsSet.removeAll(rconfsSet);
            Message.debug("to resolve configurations: " + confsSet);
            return confsSet.toArray(new String[confsSet.size()]);
        }
        Message.debug("module already resolved, no configuration to resolve");
        return new String[0];
    }

    protected String[] getResolvedConfigurations(String org, String module, boolean strict) {
        return (String[])this.getReference("ivy.resolved.configurations.ref", org, module, strict);
    }

    protected Object getResolvedDescriptor(String org, String module) {
        return this.getResolvedDescriptor(org, module, false);
    }

    protected Object getResolvedDescriptor(String org, String module, boolean strict) {
        return this.getReference("ivy.resolved.descriptor", org, module, strict);
    }

    private Object getReference(String prefix, String org, String module, boolean strict) {
        Object reference = null;
        if (org != null && module != null) {
            reference = this.getProject().getReference(prefix + "." + org + "." + module);
        }
        if (!strict && reference == null) {
            reference = this.getProject().getReference(prefix);
        }
        return reference;
    }

    protected ResolveReport getResolvedReport(String org, String module) {
        return this.getResolvedReport(org, module, false);
    }

    protected ResolveReport getResolvedReport(String org, String module, boolean strict) {
        return (ResolveReport)this.getReference("ivy.resolved.report", org, module, strict);
    }

    protected IvyResolve createResolve(boolean haltOnFailure, boolean useOrigin) {
        Message.verbose("no resolved descriptor found: launching default resolve");
        IvyResolve resolve = new IvyResolve();
        resolve.setProject(this.getProject());
        resolve.setHaltonfailure(haltOnFailure);
        resolve.setUseOrigin(useOrigin);
        if (this._validate != null) {
            resolve.setValidate(this._validate);
        }
        return resolve;
    }

    protected boolean shouldResolve(String org, String module) {
        this.ensureMessageInitialised();
        if (org != null && module != null) {
            return false;
        }
        Object reference = this.getResolvedDescriptor(org, module);
        return reference == null;
    }

    protected String[] splitConfs(String conf) {
        String[] confs = conf.split(",");
        for (int i = 0; i < confs.length; ++i) {
            confs[i] = confs[i].trim();
        }
        return confs;
    }

    protected String mergeConfs(String[] conf) {
        return StringUtils.join(conf, ", ");
    }

    protected Date getPubDate(String date, Date def) {
        if (date != null) {
            if ("now".equalsIgnoreCase(date)) {
                return new Date();
            }
            try {
                return DATE_FORMAT.parse(date);
            }
            catch (Exception ex) {
                throw new BuildException("publication date provided in bad format. should be yyyyMMddHHmmss and not " + date);
            }
        }
        return def;
    }

    protected String getProperty(String value, Ivy ivy, String name) {
        if (value == null) {
            return this.getProperty(ivy, name);
        }
        value = ivy.substitute(value);
        Message.debug("parameter found as attribute value: " + name + "=" + value);
        return value;
    }

    protected String getProperty(Ivy ivy, String name) {
        String val = ivy.getVariable(name);
        if (val == null) {
            val = ivy.substitute(this.getProject().getProperty(name));
            if (val != null) {
                Message.debug("parameter found as ant project property: " + name + "=" + val);
            } else {
                Message.debug("parameter not found: " + name);
            }
        } else {
            val = ivy.substitute(val);
            Message.debug("parameter found as ivy variable: " + name + "=" + val);
        }
        return val;
    }

    public void setProject(Project project) {
        super.setProject(project);
        IvyContext.getContext().set(ANT_PROJECT_CONTEXT_KEY, project);
    }
}

