/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.Map;

public class MostlySingularMultiMap<K, V> {
    private final Map<K, Object> myMap = new THashMap();

    public void add(K key, V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value);
        } else if (current instanceof Object[]) {
            Object[] curArr = (Object[])current;
            int size = curArr.length;
            Object[] newArr = new Object[size + 1];
            System.arraycopy(curArr, 0, newArr, 0, size);
            newArr[size] = value;
            this.myMap.put(key, newArr);
        } else {
            this.myMap.put(key, new Object[]{current, value});
        }
    }

    public boolean processForKey(K key, Processor<V> p) {
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(Processor<V> p, Object v) {
        if (v instanceof Object[]) {
            for (Object o : (Object[])v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(Processor<V> p) {
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }
}

