/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.rt.execution.junit.ComparisonDetailsExtractor;
import com.intellij.rt.execution.junit.ExceptionPacketFactory;
import com.intellij.rt.execution.junit.KnownException;
import com.intellij.rt.execution.junit.PacketFactory;
import com.intellij.rt.execution.junit.TestMeter;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import junit.framework.TestListener;

public class TestResultsSender
implements TestListener {
    private final OutputObjectRegistry myRegistry;
    private final PacketProcessor myErr;
    private TestMeter myCurrentTestMeter;
    private Test myCurrentTest;

    public TestResultsSender(OutputObjectRegistry packetFactory, PacketProcessor segmentedErr) {
        this.myRegistry = packetFactory;
        this.myErr = segmentedErr;
    }

    public synchronized void addError(Test test, Throwable throwable) {
        try {
            Class<?> aClass = Class.forName("java.lang.AssertionError");
            if (aClass.isInstance(throwable)) {
                this.doAddFailure(test, (Error)throwable);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.stopMeter(test);
        this.prepareDefectPacket(test, throwable).send();
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertion) {
        this.doAddFailure(test, (Error)assertion);
    }

    private void doAddFailure(Test test, Error assertion) {
        this.stopMeter(test);
        TestResultsSender.createExceptionNotification(assertion).createPacket(this.myRegistry, (Object)test).send();
    }

    private static PacketFactory createExceptionNotification(Error assertion) {
        if (assertion instanceof KnownException) {
            return ((KnownException)((Object)assertion)).getPacketFactory();
        }
        if (assertion instanceof ComparisonFailure || assertion.getClass().getName().equals("org.junit.ComparisonFailure")) {
            return ComparisonDetailsExtractor.create(assertion);
        }
        return new ExceptionPacketFactory(6, (Throwable)assertion);
    }

    private Packet prepareDefectPacket(Test test, Throwable assertion) {
        return this.myRegistry.createPacket().setTestState((Object)test, 8).addThrowable(assertion);
    }

    public synchronized void endTest(Test test) {
        this.stopMeter(test);
        Packet packet = this.myRegistry.createPacket().setTestState((Object)test, 1);
        this.myCurrentTestMeter.writeTo(packet);
        packet.send();
        this.myRegistry.forget((Object)test);
    }

    private void stopMeter(Test test) {
        if (!test.equals(this.myCurrentTest)) {
            this.myCurrentTestMeter = new TestMeter();
            System.err.println("Wrong test finished. Last started: " + this.myCurrentTest + " stopped: " + test + "; " + test.getClass());
        }
        this.myCurrentTestMeter.stop();
    }

    private void switchOutput(Packet switchPacket) {
        switchPacket.send();
        switchPacket.sendThrough(this.myErr);
    }

    public synchronized void startTest(Test test) {
        this.myCurrentTest = test;
        this.myRegistry.createPacket().setTestState((Object)test, 3).send();
        this.switchOutput(this.myRegistry.createPacket().switchInputTo((Object)test));
        this.myCurrentTestMeter = new TestMeter();
    }
}

