/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.util.Icons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.intellij.lang.regexp.psi.impl.RegExpPropertyImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RegExpCompletionContributor
extends CompletionContributor {
    private static final Icon emptyIcon = new EmptyIcon(Icons.PROPERTY_ICON.getIconWidth(), Icons.PROPERTY_ICON.getIconHeight());

    public RegExpCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withText("\\I"), new CharacterClassesNameCompletionProvider());
        PsiElementPattern propertyPattern = PlatformPatterns.psiElement().withText("\\p");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern), new PropertyCompletionProvider());
        PsiElementPattern propertyNamePattern = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).afterLeaf((ElementPattern)propertyPattern));
        this.extend(CompletionType.BASIC, (ElementPattern)propertyNamePattern, new PropertyNameCompletionProvider());
        PsiElementPattern backSlashPattern = PlatformPatterns.psiElement().withText("\\\\I");
        this.extend(CompletionType.BASIC, (ElementPattern)backSlashPattern, new CharacterClassesNameCompletionProvider());
        PsiElementPattern propertyPattern2 = PlatformPatterns.psiElement().withText("\\\\p");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern2), new PropertyCompletionProvider());
        PsiElementPattern propertyNamePattern2 = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).afterLeaf((ElementPattern)propertyPattern2));
        this.extend(CompletionType.BASIC, (ElementPattern)propertyNamePattern2, new PropertyNameCompletionProvider());
        backSlashPattern = PlatformPatterns.psiElement().withText("\\\\");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)backSlashPattern), new CharacterClassesNameCompletionProvider());
        propertyPattern2 = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("p")).afterLeaf((ElementPattern)backSlashPattern);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern2), new PropertyCompletionProvider());
        propertyNamePattern2 = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).afterLeaf((ElementPattern)propertyPattern2));
        this.extend(CompletionType.BASIC, (ElementPattern)propertyNamePattern2, new PropertyNameCompletionProvider());
    }

    private static void addLookupElement(CompletionResultSet result, @NonNls String name, String type, Icon icon) {
        result.addElement(RegExpCompletionContributor.createLookupElement(name, type, icon));
    }

    private static LookupElement createLookupElement(String name, String type, Icon icon) {
        return LookupElementBuilder.create((String)name).setTypeText(type).setIcon(icon);
    }

    private static class CharacterClassesNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private CharacterClassesNameCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/RegExpCompletionContributor$CharacterClassesNameCompletionProvider.addCompletions must not be null");
            }
            if (result == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/lang/regexp/RegExpCompletionContributor$CharacterClassesNameCompletionProvider.addCompletions must not be null");
            }
            String[] completions = new String[]{"d", "D", "s", "S", "w", "W", "b", "B", "A", "G", "Z", "z", "Q", "E", "t", "n", "r", "f", "a", "e"};
            String[] completionsTypes = new String[]{"digit: [0-9]", "nondigit: [^0-9]", "whitespace [ \\t\\n\\x0B\\f\\r]", "non-whitespace [^\\s]", "word character [a-zA-Z_0-9]", "nonword character [^\\w]", "word boundary", "non-word boundary", "beginning of the input", "end of the previous match", "end of the input but for the final terminator, if any", "end of input", "Nothing, but quotes all characters until \\E", " \tNothing, but ends quoting started by \\Q", "tab character ('\\u0009')", "newline (line feed) character ('\\u000A')", "carriage-return character ('\\u000D')", "form-feed character ('\\u000C')", "alert (bell) character ('\\u0007')", "escape character ('\\u001B')"};
            for (int i = 0; i < completions.length; ++i) {
                RegExpCompletionContributor.addLookupElement(result, completions[i], completionsTypes[i], emptyIcon);
            }
            for (String[] stringArray : RegExpPropertyImpl.PROPERTY_NAMES) {
                RegExpCompletionContributor.addLookupElement(result, "p{" + stringArray[0] + "}", stringArray.length > 1 ? stringArray[1] : null, Icons.PROPERTY_ICON);
            }
        }
    }

    private static class PropertyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PropertyCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/RegExpCompletionContributor$PropertyCompletionProvider.addCompletions must not be null");
            }
            if (result == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/lang/regexp/RegExpCompletionContributor$PropertyCompletionProvider.addCompletions must not be null");
            }
            for (String[] stringArray : RegExpPropertyImpl.PROPERTY_NAMES) {
                RegExpCompletionContributor.addLookupElement(result, "{" + stringArray[0] + "}", stringArray.length > 1 ? stringArray[1] : null, Icons.PROPERTY_ICON);
            }
        }
    }

    private static class PropertyNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PropertyNameCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/RegExpCompletionContributor$PropertyNameCompletionProvider.addCompletions must not be null");
            }
            if (result == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/lang/regexp/RegExpCompletionContributor$PropertyNameCompletionProvider.addCompletions must not be null");
            }
            for (String[] stringArray : RegExpPropertyImpl.PROPERTY_NAMES) {
                result.addElement(TailTypeDecorator.withTail(RegExpCompletionContributor.createLookupElement(stringArray[0], null, emptyIcon), TailType.createSimpleTailType((char)'}')));
            }
        }
    }
}

