/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ReflectionCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.events.ElementChangedEvent;
import com.intellij.util.xml.events.ElementDefinedEvent;
import com.intellij.util.xml.events.ElementUndefinedEvent;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.ConvertAnnotationImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.DynamicGenericInfo;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.GetInvocation;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.SetInvocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomInvocationHandler<T extends AbstractDomChildDescriptionImpl>
extends UserDataHolderBase
implements InvocationHandler,
DomElement,
SemElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomInvocationHandler");
    public static final Method ACCEPT_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"accept", (Class[])new Class[]{DomElementVisitor.class});
    public static final Method ACCEPT_CHILDREN_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"acceptChildren", (Class[])new Class[]{DomElementVisitor.class});
    private final Type myAbstractType;
    private final Type myType;
    private final DomManagerImpl myManager;
    private final EvaluatedXmlName myTagName;
    private final T myChildDescription;
    private DomParentStrategy myParentStrategy;
    private volatile long myLastModCount;
    private final DomElement myProxy;
    private DomGenericInfoEx myGenericInfo;
    private final InvocationCache myInvocationCache;
    private final FactoryMap<JavaMethod, Converter> myScalarConverters = new FactoryMap<JavaMethod, Converter>(){

        protected Converter create(JavaMethod method) {
            Type returnType = method.getGenericReturnType();
            Type type = returnType == Void.TYPE ? method.getGenericParameterTypes()[0] : returnType;
            Class parameter = ReflectionUtil.substituteGenericType((Type)type, (Type)DomInvocationHandler.this.myType);
            LOG.assertTrue(parameter != null, (Object)(type + " " + DomInvocationHandler.this.myType));
            Converter converter = DomInvocationHandler.this.getConverter((AnnotatedElement)method, parameter);
            if (converter == null && type instanceof TypeVariable) {
                converter = DomInvocationHandler.this.getConverter((AnnotatedElement)DomInvocationHandler.this, DomUtil.getGenericValueParameter((Type)DomInvocationHandler.this.myType));
            }
            if (converter == null) {
                converter = DomInvocationHandler.this.myManager.getConverterManager().getConverterByClass(parameter);
            }
            if (converter == null) {
                LOG.error("No converter specified: String<->" + parameter.getName());
            }
            return converter;
        }
    };
    private final FactoryMap<JavaMethodSignature, Invocation> myAccessorInvocations = new ConcurrentFactoryMap<JavaMethodSignature, Invocation>(){

        protected Invocation create(JavaMethodSignature signature) {
            JavaMethod method = JavaMethod.getMethod(DomInvocationHandler.this.getRawType(), (JavaMethodSignature)signature);
            if (DomImplUtil.isTagValueGetter(method)) {
                return new GetInvocation(DomInvocationHandler.this.getScalarConverter(method));
            }
            if (DomImplUtil.isTagValueSetter(method)) {
                return new SetInvocation(DomInvocationHandler.this.getScalarConverter(method));
            }
            return null;
        }
    };

    protected DomInvocationHandler(Type type, DomParentStrategy parentStrategy, EvaluatedXmlName tagName, T childDescription, DomManagerImpl manager, boolean dynamic) {
        Class[] classArray;
        this.myManager = manager;
        this.myParentStrategy = parentStrategy;
        this.myTagName = tagName;
        this.myChildDescription = childDescription;
        this.myAbstractType = type;
        this.myLastModCount = manager.getPsiModificationCount();
        this.myType = this.narrowType(type);
        Class<?> rawType = this.getRawType();
        this.myInvocationCache = manager.getInvocationCache(rawType);
        Class<Object> implementation = manager.getImplementation(rawType);
        boolean isInterface = ReflectionCache.isInterface(rawType);
        if (implementation == null && !isInterface) {
            implementation = rawType;
        }
        if (isInterface) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = rawType;
        } else {
            classArray = ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        this.myProxy = AdvancedProxy.createProxy(this, implementation, classArray);
        this.refreshGenericInfo(dynamic);
    }

    protected Type narrowType(@NotNull Type nominalType) {
        if (nominalType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomInvocationHandler.narrowType must not be null");
        }
        return nominalType;
    }

    @Nullable
    public DomElement getParent() {
        this.checkIsValid();
        DomInvocationHandler handler = this.getParentHandler();
        return handler == null ? null : handler.getProxy();
    }

    protected final void checkIsValid() {
        if (!this.isValid()) {
            LOG.error(this.myType.toString() + " @" + this.hashCode() + "\nclass=" + ((Object)((Object)this)).getClass() + "\nxml=" + this.getXmlElement());
        }
    }

    @Nullable
    final DomInvocationHandler getParentHandler() {
        return this.getParentStrategy().getParentHandler();
    }

    @NotNull
    public final Type getDomElementType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getDomElementType must not return null");
        }
        return type;
    }

    final Type getAbstractType() {
        return this.myAbstractType;
    }

    @Nullable
    protected String getValue() {
        XmlTag tag = this.getXmlTag();
        return tag == null ? null : DomInvocationHandler.getTagValue(tag);
    }

    protected void setValue(final @Nullable String value) {
        final XmlTag tag = this.ensureTagExists();
        this.myManager.runChange(new Runnable(){

            @Override
            public void run() {
                DomInvocationHandler.setTagValue(tag, value);
            }
        });
        this.myManager.fireEvent((DomEvent)new ElementChangedEvent(this.getProxy()));
    }

    public void copyFrom(final DomElement other) {
        if (other == this.getProxy()) {
            return;
        }
        assert (other.getDomElementType().equals(this.myType));
        if (!DomUtil.hasXml((DomElement)other)) {
            this.undefine();
            return;
        }
        this.myManager.performAtomicChange(new Runnable(){

            @Override
            public void run() {
                DomInvocationHandler.this.ensureXmlElementExists();
                DomGenericInfoEx genericInfo = DomInvocationHandler.this.getGenericInfo();
                for (AttributeChildDescriptionImpl description : genericInfo.getAttributeChildrenDescriptions()) {
                    description.getDomAttributeValue(DomInvocationHandler.this).setStringValue(description.getDomAttributeValue(other).getStringValue());
                }
                for (AttributeChildDescriptionImpl description : genericInfo.getFixedChildrenDescriptions()) {
                    List list = description.getValues(DomInvocationHandler.this.getProxy());
                    List otherValues = description.getValues(other);
                    for (int i = 0; i < list.size(); ++i) {
                        DomElement otherValue = (DomElement)otherValues.get(i);
                        DomElement value = (DomElement)list.get(i);
                        if (!DomUtil.hasXml((DomElement)otherValue)) {
                            value.undefine();
                            continue;
                        }
                        value.copyFrom(otherValue);
                    }
                }
                for (AttributeChildDescriptionImpl description : genericInfo.getCollectionChildrenDescriptions()) {
                    for (DomElement value : description.getValues(DomInvocationHandler.this.getProxy())) {
                        value.undefine();
                    }
                    for (DomElement otherValue : description.getValues(other)) {
                        description.addValue(DomInvocationHandler.this.getProxy(), otherValue.getDomElementType()).copyFrom(otherValue);
                    }
                }
                String stringValue = DomManagerImpl.getDomInvocationHandler(other).getValue();
                if (StringUtil.isNotEmpty((String)stringValue)) {
                    DomInvocationHandler.this.setValue(stringValue);
                }
            }
        });
        if (!this.myManager.getSemService().isInsideAtomicChange()) {
            this.myManager.fireEvent((DomEvent)new ElementChangedEvent(this.myProxy));
        }
    }

    public <T extends DomElement> T createStableCopy() {
        XmlTag tag = this.getXmlTag();
        if (tag != null && tag.isPhysical()) {
            DomElement existing = this.myManager.getDomElement(tag);
            assert (existing != null) : existing + "\n---------\n" + tag.getParent().getText() + "\n-----------\n" + tag.getText();
            assert (this.getProxy().equals(existing)) : existing + "\n---------\n" + tag.getParent().getText() + "\n-----------\n" + tag.getText() + "\n----\n" + (Object)((Object)this) + " != " + (Object)((Object)DomManagerImpl.getDomInvocationHandler(existing));
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myManager.getProject()).createLazyPointer((PsiElement)tag);
            return this.myManager.createStableValue(new StableCopyFactory((SmartPsiElementPointer<XmlTag>)pointer, this.myType, ((Object)((Object)this)).getClass()));
        }
        return (T)this.createPathStableCopy();
    }

    protected DomElement createPathStableCopy() {
        throw new UnsupportedOperationException();
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        Object copy = this.myManager.createMockElement(this.getRawType(), this.getProxy().getModule(), physical);
        copy.copyFrom(this.getProxy());
        return (T)copy;
    }

    @NotNull
    public String getXmlElementNamespace() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "this operation should be performed on the DOM having a physical parent, your DOM may be not very fresh";
        XmlElement element = parent.getXmlElement();
        assert (element != null);
        String string = this.getXmlName().getNamespace(element, this.getFile());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getXmlElementNamespace must not return null");
        }
        return string;
    }

    @Nullable
    public String getXmlElementNamespaceKey() {
        return this.getXmlName().getXmlName().getNamespaceKey();
    }

    public final Module getModule() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getFile());
        return module != null ? module : (Module)DomUtil.getFile((DomElement)this).getUserData(DomManagerImpl.MOCK_ELEMENT_MODULE);
    }

    public XmlTag ensureTagExists() {
        this.checkIsValid();
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            return tag;
        }
        tag = this.setEmptyXmlTag();
        this.setXmlElement((XmlElement)tag);
        this.myManager.fireEvent((DomEvent)new ElementDefinedEvent(this.getProxy()));
        this.addRequiredChildren();
        this.myManager.cacheHandler(this.getCacheKey(), (XmlElement)tag, this);
        return this.getXmlTag();
    }

    public XmlElement getXmlElement() {
        return this.getParentStrategy().getXmlElement();
    }

    private DomParentStrategy getParentStrategy() {
        this.myParentStrategy = this.myParentStrategy.refreshStrategy(this);
        return this.myParentStrategy;
    }

    public XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    protected final XmlTag createChildTag(EvaluatedXmlName tagName) {
        String localName = tagName.getXmlName().getLocalName();
        if (localName.contains(":")) {
            try {
                return XmlElementFactory.getInstance((Project)this.myManager.getProject()).createTagFromText("<" + localName + "/>");
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        XmlElement element = this.getXmlElement();
        assert (element != null);
        return this.getXmlTag().createChildTag(localName, tagName.getNamespace(element, this.getFile()), "", false);
    }

    public boolean isValid() {
        ProgressManager.checkCanceled();
        DomParentStrategy parentStrategy = this.getParentStrategy();
        if (!parentStrategy.isValid()) {
            return false;
        }
        if (this.myLastModCount == this.myManager.getPsiModificationCount()) {
            return true;
        }
        XmlElement xmlElement = parentStrategy.getXmlElement();
        if (xmlElement != null) {
            SemService semService = SemService.getSemService((Project)this.myManager.getProject());
            return this.rememberValidity(this.equals(semService.getSemElement(DomManagerImpl.DOM_HANDLER_KEY, (PsiElement)xmlElement)));
        }
        DomInvocationHandler parent = this.getParentHandler();
        return this.rememberValidity(parent != null && parent.isValid());
    }

    private boolean rememberValidity(boolean isValid) {
        if (isValid) {
            this.myLastModCount = this.myManager.getPsiModificationCount();
        }
        return isValid;
    }

    @NotNull
    public final DomGenericInfoEx getGenericInfo() {
        DomGenericInfoEx domGenericInfoEx = this.myGenericInfo;
        if (domGenericInfoEx == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getGenericInfo must not return null");
        }
        return domGenericInfoEx;
    }

    protected abstract void undefineInternal();

    public final void undefine() {
        this.undefineInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteTag(XmlTag tag) {
        boolean changing = this.myManager.setChanging(true);
        try {
            tag.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    protected final void fireUndefinedEvent() {
        this.myManager.fireEvent((DomEvent)new ElementUndefinedEvent(this.getProxy()));
    }

    protected abstract XmlTag setEmptyXmlTag();

    protected void addRequiredChildren() {
        for (AbstractDomChildrenDescription description : this.getGenericInfo().getChildrenDescriptions()) {
            if (description instanceof DomAttributeChildDescription) {
                Required required = (Required)description.getAnnotation(Required.class);
                if (required == null || !required.value()) continue;
                ((DomElement)description.getValues(this.getProxy()).get(0)).ensureXmlElementExists();
                continue;
            }
            if (!(description instanceof DomFixedChildDescription)) continue;
            DomFixedChildDescription childDescription = (DomFixedChildDescription)description;
            List values = null;
            int count = childDescription.getCount();
            for (int i = 0; i < count; ++i) {
                Required required = (Required)childDescription.getAnnotation(i, Required.class);
                if (required == null || !required.value()) continue;
                if (values == null) {
                    values = description.getValues(this.getProxy());
                }
                ((DomElement)values.get(i)).ensureTagExists();
            }
        }
    }

    @NotNull
    public final String getXmlElementName() {
        String string = this.myTagName.getXmlName().getLocalName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getXmlElementName must not return null");
        }
        return string;
    }

    @NotNull
    public final EvaluatedXmlName getXmlName() {
        EvaluatedXmlName evaluatedXmlName = this.myTagName;
        if (evaluatedXmlName == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getXmlName must not return null");
        }
        return evaluatedXmlName;
    }

    public void accept(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        this.myManager.getVisitorDescription(visitor.getClass()).acceptElement(visitor, this.getProxy());
    }

    public void acceptChildren(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        DomElement element = this.getProxy();
        for (AbstractDomChildrenDescription description : this.getGenericInfo().getChildrenDescriptions()) {
            for (DomElement value : description.getValues(element)) {
                value.accept(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final Converter getScalarConverter(JavaMethod method) {
        Converter converter;
        FactoryMap<JavaMethod, Converter> factoryMap = this.myScalarConverters;
        synchronized (factoryMap) {
            converter = (Converter)this.myScalarConverters.get((Object)method);
        }
        assert (converter != null);
        Converter converter2 = converter;
        if (converter2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getScalarConverter must not return null");
        }
        return converter2;
    }

    public final T getChildDescription() {
        return this.myChildDescription;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        AbstractDomChildrenDescription childDescription = this.getChildDescription();
        if (childDescription != null && (annotation = childDescription.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        return this.getRawType().getAnnotation(annotationClass);
    }

    @Nullable
    private Converter getConverter(AnnotatedElement annotationProvider, Class parameter) {
        Resolve resolveAnnotation = (Resolve)annotationProvider.getAnnotation(Resolve.class);
        if (resolveAnnotation != null) {
            Class aClass = resolveAnnotation.value();
            if (!DomElement.class.equals((Object)aClass)) {
                return DomResolveConverter.createConverter((Class)aClass);
            }
            LOG.assertTrue(parameter != null, (Object)"You should specify @Resolve#value() parameter");
            return DomResolveConverter.createConverter((Class)parameter);
        }
        ConverterManager converterManager = this.myManager.getConverterManager();
        Convert convertAnnotation = (Convert)annotationProvider.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            if (convertAnnotation instanceof ConvertAnnotationImpl) {
                return ((ConvertAnnotationImpl)convertAnnotation).getConverter();
            }
            return converterManager.getConverterInstance(convertAnnotation.value());
        }
        return null;
    }

    @NotNull
    public final DomElement getProxy() {
        DomElement domElement = this.myProxy;
        if (domElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getProxy must not return null");
        }
        return domElement;
    }

    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = DomUtil.getFile((DomElement)this);
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getFile must not return null");
        }
        return xmlFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DomNameStrategy getNameStrategy() {
        DomNameStrategy domNameStrategy;
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy != null) {
            domNameStrategy = strategy;
            if (domNameStrategy == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getNameStrategy must not return null");
            return domNameStrategy;
        }
        DomInvocationHandler handler = this.getParentHandler();
        domNameStrategy = handler == null ? DomNameStrategy.HYPHEN_STRATEGY : handler.getNameStrategy();
        if (domNameStrategy != null) return domNameStrategy;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getNameStrategy must not return null");
    }

    protected boolean isAttribute() {
        return false;
    }

    @NotNull
    public ElementPresentation getPresentation() {
        ElementPresentation elementPresentation = new ElementPresentation(){

            public String getElementName() {
                return ElementPresentationManager.getElementName((Object)DomInvocationHandler.this.getProxy());
            }

            public String getTypeName() {
                return ElementPresentationManager.getTypeNameForObject((Object)DomInvocationHandler.this.getProxy());
            }

            public Icon getIcon() {
                return ElementPresentationManager.getIcon((Object)DomInvocationHandler.this.getProxy());
            }
        };
        if (elementPresentation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getPresentation must not return null");
        }
        return elementPresentation;
    }

    public final GlobalSearchScope getResolveScope() {
        return DomUtil.getFile((DomElement)this).getResolveScope();
    }

    private static <T extends DomElement> T _getParentOfType(Class<T> requiredClass, DomElement element) {
        while (element != null && !requiredClass.isInstance(element)) {
            element = element.getParent();
        }
        return (T)element;
    }

    public final <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return DomInvocationHandler._getParentOfType(requiredClass, strict ? this.getParent() : this.getProxy());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    final IndexedElementInvocationHandler getFixedChild(Pair<FixedChildDescriptionImpl, Integer> info) {
        IndexedElementInvocationHandler indexedElementInvocationHandler;
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)info.first;
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(description.getXmlName());
        XmlTag tag = this.getXmlTag();
        int index = (Integer)info.second;
        if (tag != null) {
            LOG.assertTrue(tag.isValid());
            List<XmlTag> tags = DomImplUtil.findSubTags(tag.getSubTags(), evaluatedXmlName, this.getFile());
            if (tags.size() > index) {
                indexedElementInvocationHandler = (IndexedElementInvocationHandler)this.myManager.getSemService().getSemElement(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (PsiElement)tags.get(index));
                if (indexedElementInvocationHandler == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getFixedChild must not return null");
                return indexedElementInvocationHandler;
            }
        }
        if ((indexedElementInvocationHandler = new IndexedElementInvocationHandler(evaluatedXmlName, description, index, new VirtualDomParentStrategy(this), this.myManager, "")) != null) return indexedElementInvocationHandler;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getFixedChild must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    final AttributeChildInvocationHandler getAttributeChild(AttributeChildDescriptionImpl description) {
        AttributeChildInvocationHandler attributeChildInvocationHandler;
        this.checkIsValid();
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(description.getXmlName());
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            String ns = evaluatedXmlName.getNamespace((XmlElement)tag, this.getFile());
            XmlAttribute attribute = tag.getAttribute(description.getXmlName().getLocalName(), ns.equals(tag.getNamespace()) ? null : ns);
            if (attribute != null) {
                attributeChildInvocationHandler = (AttributeChildInvocationHandler)this.myManager.getSemService().getSemElement(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (PsiElement)attribute);
                if (attributeChildInvocationHandler == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getAttributeChild must not return null");
                return attributeChildInvocationHandler;
            }
        }
        if ((attributeChildInvocationHandler = new AttributeChildInvocationHandler(evaluatedXmlName, description, this.myManager, new VirtualDomParentStrategy(this))) != null) return attributeChildInvocationHandler;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getAttributeChild must not return null");
    }

    @Nullable
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.doInvoke(JavaMethodSignature.getSignature((Method)method), args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @Nullable
    private Object doInvoke(JavaMethodSignature signature, Object ... args) throws Throwable {
        Invocation invocation = this.myInvocationCache.getInvocation(signature);
        if (invocation == null && (invocation = (Invocation)this.myAccessorInvocations.get((Object)signature)) == null) {
            JavaMethod javaMethod = JavaMethod.getMethod(this.getRawType(), (JavaMethodSignature)signature);
            invocation = this.myGenericInfo.createInvocation(javaMethod);
            this.myInvocationCache.putInvocation(signature, invocation);
        }
        return invocation.invoke(this, args);
    }

    private static void setTagValue(XmlTag tag, String value) {
        tag.getValue().setText(value);
    }

    private static String getTagValue(XmlTag tag) {
        return tag.getValue().getTrimmedText();
    }

    public final String toString() {
        if (ReflectionCache.isAssignable(GenericValue.class, this.getRawType())) {
            return ((GenericValue)this.getProxy()).getStringValue();
        }
        return this.myType.toString() + " @" + this.hashCode();
    }

    protected final Class<?> getRawType() {
        return ReflectionUtil.getRawType((Type)this.myType);
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)this.getXmlElement();
    }

    @Nullable
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomInvocationHandler.recomputeXmlElement must not be null");
        }
        return null;
    }

    protected final void detach() {
        this.setXmlElement(null);
    }

    final SemKey getCacheKey() {
        if (this instanceof AttributeChildInvocationHandler) {
            return DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY;
        }
        if (this instanceof DomRootInvocationHandler) {
            return DomManagerImpl.DOM_HANDLER_KEY;
        }
        if (this instanceof IndexedElementInvocationHandler) {
            return DomManagerImpl.DOM_INDEXED_HANDLER_KEY;
        }
        if (this.getChildDescription() instanceof CustomDomChildrenDescription) {
            return DomManagerImpl.DOM_CUSTOM_HANDLER_KEY;
        }
        return DomManagerImpl.DOM_COLLECTION_HANDLER_KEY;
    }

    protected final void setXmlElement(XmlElement element) {
        this.refreshGenericInfo(element != null && !this.isAttribute());
        this.myParentStrategy = element == null ? this.myParentStrategy.clearXmlElement() : this.myParentStrategy.setXmlElement(element);
    }

    private void refreshGenericInfo(boolean dynamic) {
        StaticGenericInfo staticInfo = this.myManager.getStaticGenericInfo(this.myType);
        this.myGenericInfo = dynamic ? new DynamicGenericInfo(this, staticInfo, this.myManager.getProject()) : staticInfo;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        DomManagerImpl domManagerImpl = this.myManager;
        if (domManagerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.getManager must not return null");
        }
        return domManagerImpl;
    }

    public final DomElement addCollectionChild(CollectionChildDescriptionImpl description, Type type, int index) throws IncorrectOperationException {
        EvaluatedXmlName name = this.createEvaluatedXmlName(description.getXmlName());
        XmlTag tag = this.addEmptyTag(name, index);
        CollectionElementInvocationHandler handler = new CollectionElementInvocationHandler(type, tag, description, this);
        this.myManager.fireEvent((DomEvent)new ElementChangedEvent(this.getProxy()));
        this.getManager().getTypeChooserManager().getTypeChooser(description.getType()).distinguishTag(tag, type);
        handler.addRequiredChildren();
        return handler.getProxy();
    }

    protected final void createFixedChildrenTags(EvaluatedXmlName tagName, FixedChildDescriptionImpl description, int count) {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < count) {
            this.getFixedChild((Pair<FixedChildDescriptionImpl, Integer>)Pair.create((Object)description, (Object)(count - 1))).ensureTagExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlTag addEmptyTag(EvaluatedXmlName tagName, int index) throws IncorrectOperationException {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < index) {
            index = subTags.size();
        }
        boolean changing = this.myManager.setChanging(true);
        try {
            XmlTag newTag = this.createChildTag(tagName);
            if (index == 0) {
                if (subTags.isEmpty()) {
                    XmlTag xmlTag = (XmlTag)tag.add((PsiElement)newTag);
                    return xmlTag;
                }
                XmlTag xmlTag = (XmlTag)tag.addBefore((PsiElement)newTag, (PsiElement)subTags.get(0));
                return xmlTag;
            }
            XmlTag xmlTag = (XmlTag)tag.addAfter((PsiElement)newTag, (PsiElement)subTags.get(index - 1));
            return xmlTag;
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    @NotNull
    public final EvaluatedXmlName createEvaluatedXmlName(XmlName xmlName) {
        EvaluatedXmlName evaluatedXmlName = this.getXmlName().evaluateChildName(xmlName);
        if (evaluatedXmlName == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomInvocationHandler.createEvaluatedXmlName must not return null");
        }
        return evaluatedXmlName;
    }

    public List<? extends DomElement> getCollectionChildren(AbstractCollectionChildDescription description, NotNullFunction<DomInvocationHandler, List<XmlTag>> tagsGetter) {
        XmlTag tag = this.getXmlTag();
        if (tag == null) {
            return Collections.emptyList();
        }
        this.checkIsValid();
        List subTags = (List)tagsGetter.fun((Object)this);
        if (subTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomElement> elements = new ArrayList<DomElement>(subTags.size());
        for (XmlTag subTag : subTags) {
            SemKey<CollectionElementInvocationHandler> key = description instanceof CustomDomChildrenDescription ? DomManagerImpl.DOM_CUSTOM_HANDLER_KEY : DomManagerImpl.DOM_COLLECTION_HANDLER_KEY;
            DomInvocationHandler semElement = (DomInvocationHandler)this.myManager.getSemService().getSemElement(key, (PsiElement)subTag);
            if (semElement == null) {
                this.myManager.getSemService().getSemElement(key, (PsiElement)subTag);
                LOG.error("No child for subTag '" + subTag.getName() + "' in tag '" + tag.getName() + "' using key " + key);
                continue;
            }
            elements.add(semElement.getProxy());
        }
        return Collections.unmodifiableList(elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        DomInvocationHandler that = (DomInvocationHandler)((Object)o);
        if (!this.myChildDescription.equals(that.myChildDescription)) {
            return false;
        }
        return this.getParentStrategy().equals(that.getParentStrategy());
    }

    public int hashCode() {
        return this.myChildDescription.hashCode();
    }

    private static class StableCopyFactory<T extends DomElement>
    implements NullableFactory<T> {
        private final SmartPsiElementPointer<XmlTag> myPointer;
        private final Type myType;
        private final Class<? extends DomInvocationHandler> myHandlerClass;

        public StableCopyFactory(SmartPsiElementPointer<XmlTag> pointer, Type type, Class<? extends DomInvocationHandler> aClass) {
            this.myPointer = pointer;
            this.myType = type;
            this.myHandlerClass = aClass;
        }

        public T create() {
            XmlTag tag = (XmlTag)this.myPointer.getElement();
            if (tag == null || !tag.isValid()) {
                return null;
            }
            DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (element == null || !element.getDomElementType().equals(this.myType)) {
                return null;
            }
            DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
            if (handler == null || !((Object)((Object)handler)).getClass().equals(this.myHandlerClass)) {
                return null;
            }
            return (T)element;
        }
    }
}

