/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.OutputFiltersDialog;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class ToolEditorDialog
extends DialogWrapper {
    private final JTextField myNameField = new JTextField();
    private final JTextField myDescriptionField = new JTextField();
    private final ComboBox myGroupCombo = new ComboBox(-1);
    private final JCheckBox myShowInMainMenuCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.main.checkbox", new Object[0]));
    private final JCheckBox myShowInEditorCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.editor.checkbox", new Object[0]));
    private final JCheckBox myShowInProjectTreeCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.project.checkbox", new Object[0]));
    private final JCheckBox myShowInSearchResultsPopupCheckbox = new JCheckBox(ToolsBundle.message("tools.menu.search.checkbox", new Object[0]));
    private final JCheckBox myUseConsoleCheckbox = new JCheckBox(ToolsBundle.message("tools.open.console.checkbox", new Object[0]));
    private final JCheckBox mySynchronizedAfterRunCheckbox = new JCheckBox(ToolsBundle.message("tools.synchronize.files.checkbox", new Object[0]));
    private boolean myEnabled;
    private final JTextField myTfCommandWorkingDirectory = new JTextField();
    private final JTextField myTfCommand = new JTextField();
    private final JTextField myParametersField = new JTextField();
    private JButton myInsertWorkingDirectoryMacroButton;
    private JButton myInsertCommandMacroButton;
    private JButton myInsertParametersMacroButton;
    private final JButton myOutputFiltersButton;
    private final JPanel mySimpleProgramPanel = this.createCommandPane();
    private FilterInfo[] myOutputFilters;
    private final Project myProject;

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)new JLabel(ToolsBundle.message("tools.name.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.insets = new Insets(5, 10, 0, 10);
        constr.fill = 2;
        constr.anchor = 17;
        panel.add((Component)this.myNameField, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.insets = new Insets(5, 10, 0, 0);
        panel.add((Component)new JLabel(ToolsBundle.message("tools.group.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 3;
        constr.gridy = 0;
        constr.weightx = 0.7;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        panel.add((Component)this.myGroupCombo, constr);
        this.myGroupCombo.setEditable(true);
        this.myGroupCombo.setFont(this.myNameField.getFont());
        Dimension comboSize = this.myNameField.getPreferredSize();
        this.myGroupCombo.setMinimumSize(comboSize);
        this.myGroupCombo.setPreferredSize(comboSize);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 17;
        constr.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)new JLabel(ToolsBundle.message("tools.description.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.gridwidth = 3;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        panel.add((Component)this.myDescriptionField, constr);
        JPanel panel0 = new JPanel(new GridBagLayout());
        constr = new GridBagConstraints();
        constr.gridheight = 2;
        panel0.add((Component)this.getShowInPanel(), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.weightx = 1.0;
        constr.anchor = 12;
        constr.fill = 2;
        constr.insets = new Insets(5, 10, 0, 0);
        panel0.add((Component)this.myUseConsoleCheckbox, constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.anchor = 12;
        constr.fill = 2;
        constr.insets = new Insets(0, 10, 0, 0);
        panel0.add((Component)this.mySynchronizedAfterRunCheckbox, constr);
        panel0.add(this.myOutputFiltersButton);
        constr = new GridBagConstraints();
        constr.gridy = 4;
        constr.gridwidth = 4;
        constr.fill = 2;
        constr.weightx = 1.0;
        constr.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)panel0, constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 6;
        constr.gridwidth = 2;
        constr.anchor = 17;
        constr.insets = new Insets(10, 0, 0, 0);
        panel.add(Box.createVerticalStrut(10), constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 7;
        constr.gridwidth = 4;
        constr.fill = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.anchor = 11;
        panel.add((Component)this.mySimpleProgramPanel, constr);
        return panel;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("preferences.externalToolsEdit");
    }

    public ToolEditorDialog(JComponent parent) {
        super((Component)parent, true);
        this.myOutputFiltersButton = new JButton(ToolsBundle.message("tools.filters.button", new Object[0]));
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)parent);
        this.myProject = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        MacroManager.getInstance().cacheMacrosPreview(dataContext);
        this.setTitle(ToolsBundle.message("tools.edit.title", new Object[0]));
        this.init();
        this.addListeners();
    }

    private JPanel createCommandPane() {
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.insets = new Insets(5, 0, 0, 10);
        constr.anchor = 17;
        pane.add((Component)new JLabel(ToolsBundle.message("tools.program.label", new Object[0])), constr);
        FixedSizeButton browseCommandButton = new FixedSizeButton((JComponent)this.myTfCommand);
        browseCommandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((Project)ToolEditorDialog.this.myProject, (FileChooserDescriptor)descriptor);
                if (files.length != 0) {
                    VirtualFile parent;
                    VirtualFile file = files[0];
                    ToolEditorDialog.this.myTfCommand.setText(file.getPresentableUrl());
                    String workingDirectory = ToolEditorDialog.this.myTfCommandWorkingDirectory.getText();
                    if ((workingDirectory == null || workingDirectory.length() == 0) && (parent = file.getParent()) != null && parent.isDirectory()) {
                        ToolEditorDialog.this.myTfCommandWorkingDirectory.setText(parent.getPresentableUrl());
                    }
                }
            }
        });
        JPanel _pane0 = new JPanel(new BorderLayout());
        _pane0.add((Component)this.myTfCommand, "Center");
        _pane0.add((Component)browseCommandButton, "East");
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)browseCommandButton, (JComponent)this.myTfCommand);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 0;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        constr.weightx = 1.0;
        pane.add((Component)_pane0, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 0;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        this.myInsertCommandMacroButton = new JButton(ToolsBundle.message("tools.insert.macro.button", new Object[0]));
        pane.add((Component)this.myInsertCommandMacroButton, constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 1;
        constr.insets = new Insets(5, 0, 0, 0);
        constr.anchor = 17;
        pane.add((Component)new JLabel(ToolsBundle.message("tools.parameters.label", new Object[0])), constr);
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 1;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        constr.weightx = 1.0;
        pane.add((Component)this.myParametersField, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 1;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        this.myInsertParametersMacroButton = new JButton(ToolsBundle.message("tools.insert.macro.button.a", new Object[0]));
        pane.add((Component)this.myInsertParametersMacroButton, constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 2;
        constr.insets = new Insets(5, 0, 5, 10);
        constr.anchor = 17;
        pane.add((Component)new JLabel(ToolsBundle.message("tools.working.directory.label", new Object[0])), constr);
        FixedSizeButton browseDirectoryButton = new FixedSizeButton((JComponent)this.myTfCommandWorkingDirectory);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)browseDirectoryButton, (JComponent)this.myTfCommandWorkingDirectory);
        browseDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((Project)ToolEditorDialog.this.myProject, (FileChooserDescriptor)descriptor);
                if (files.length != 0) {
                    ToolEditorDialog.this.myTfCommandWorkingDirectory.setText(files[0].getPresentableUrl());
                }
            }
        });
        JPanel _pane1 = new JPanel(new BorderLayout());
        _pane1.add((Component)this.myTfCommandWorkingDirectory, "Center");
        _pane1.add((Component)browseDirectoryButton, "East");
        constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = 2;
        constr.gridwidth = 1;
        constr.insets = new Insets(5, 10, 5, 0);
        constr.fill = 2;
        constr.anchor = 17;
        constr.weightx = 1.0;
        pane.add((Component)_pane1, constr);
        constr = new GridBagConstraints();
        constr.gridx = 2;
        constr.gridy = 2;
        constr.insets = new Insets(5, 10, 0, 0);
        constr.fill = 2;
        constr.anchor = 17;
        this.myInsertWorkingDirectoryMacroButton = new JButton(ToolsBundle.message("tools.insert.macro.button.c", new Object[0]));
        pane.add((Component)this.myInsertWorkingDirectoryMacroButton, constr);
        constr = new GridBagConstraints();
        constr.gridy = 3;
        constr.fill = 3;
        constr.weighty = 1.0;
        pane.add((Component)new JLabel(), constr);
        pane.setPreferredSize(new Dimension(600, 100));
        return pane;
    }

    private void addListeners() {
        this.myOutputFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFiltersDialog dialog = new OutputFiltersDialog(ToolEditorDialog.this.myOutputFiltersButton, ToolEditorDialog.this.getData().getOutputFilters());
                dialog.show();
                if (dialog.isOK()) {
                    ToolEditorDialog.access$402(ToolEditorDialog.this, dialog.getData());
                }
            }
        });
        this.myInsertCommandMacroButton.addActionListener(new InsertMacroActionListener(this.myTfCommand));
        this.myInsertParametersMacroButton.addActionListener(new InsertMacroActionListener(this.myParametersField));
        this.myInsertWorkingDirectoryMacroButton.addActionListener(new InsertMacroActionListener(this.myTfCommandWorkingDirectory));
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                ToolEditorDialog.this.handleOKButton();
            }
        });
    }

    private void handleOKButton() {
        this.setOKActionEnabled(this.myNameField.getText().trim().length() > 0);
    }

    public Tool getData() {
        Tool tool = new Tool();
        tool.setName(this.convertString(this.myNameField.getText()));
        tool.setDescription(this.convertString(this.myDescriptionField.getText()));
        tool.setGroup(this.myGroupCombo.getSelectedItem() != null ? this.convertString(this.myGroupCombo.getSelectedItem().toString()) : null);
        tool.setShownInMainMenu(this.myShowInMainMenuCheckbox.isSelected());
        tool.setShownInEditor(this.myShowInEditorCheckbox.isSelected());
        tool.setShownInProjectViews(this.myShowInProjectTreeCheckbox.isSelected());
        tool.setShownInSearchResultsPopup(this.myShowInSearchResultsPopupCheckbox.isSelected());
        tool.setUseConsole(this.myUseConsoleCheckbox.isSelected());
        tool.setFilesSynchronizedAfterRun(this.mySynchronizedAfterRunCheckbox.isSelected());
        tool.setEnabled(this.myEnabled);
        tool.setWorkingDirectory(this.toSystemIndependentFormat(this.myTfCommandWorkingDirectory.getText()));
        tool.setProgram(this.convertString(this.myTfCommand.getText()));
        tool.setParameters(this.convertString(this.myParametersField.getText()));
        tool.setOutputFilters(this.myOutputFilters);
        return tool;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.ToolEditorDialog";
    }

    void setData(Tool tool, String[] existingGroups) {
        this.myNameField.setText(tool.getName());
        this.myDescriptionField.setText(tool.getDescription());
        if (this.myGroupCombo.getItemCount() > 0) {
            this.myGroupCombo.removeAllItems();
        }
        for (int i = 0; i < existingGroups.length; ++i) {
            if (existingGroups[i] == null) continue;
            this.myGroupCombo.addItem((Object)existingGroups[i]);
        }
        this.myGroupCombo.setSelectedItem((Object)tool.getGroup());
        this.myShowInMainMenuCheckbox.setSelected(tool.isShownInMainMenu());
        this.myShowInEditorCheckbox.setSelected(tool.isShownInEditor());
        this.myShowInProjectTreeCheckbox.setSelected(tool.isShownInProjectViews());
        this.myShowInSearchResultsPopupCheckbox.setSelected(tool.isShownInSearchResultsPopup());
        this.myUseConsoleCheckbox.setSelected(tool.isUseConsole());
        this.mySynchronizedAfterRunCheckbox.setSelected(tool.synchronizeAfterExecution());
        this.myEnabled = tool.isEnabled();
        this.myTfCommandWorkingDirectory.setText(this.toCurrentSystemFormat(tool.getWorkingDirectory()));
        this.myTfCommand.setText(tool.getProgram());
        this.myParametersField.setText(tool.getParameters());
        this.myOutputFilters = tool.getOutputFilters();
        this.mySimpleProgramPanel.setVisible(true);
        this.handleOKButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private JPanel getShowInPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 2, 10, 3));
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)ToolsBundle.message("tools.menu.group", new Object[0])));
        panel.add(this.myShowInMainMenuCheckbox);
        panel.add(this.myShowInEditorCheckbox);
        panel.add(this.myShowInProjectTreeCheckbox);
        panel.add(this.myShowInSearchResultsPopupCheckbox);
        return panel;
    }

    private String convertString(String s) {
        if (s != null && s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    private String toSystemIndependentFormat(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.replace(File.separatorChar, '/');
    }

    private String toCurrentSystemFormat(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.replace('/', File.separatorChar);
    }

    static /* synthetic */ FilterInfo[] access$402(ToolEditorDialog x0, FilterInfo[] x1) {
        x0.myOutputFilters = x1;
        return x1;
    }

    private class InsertMacroActionListener
    implements ActionListener {
        private final JTextField myTextField;

        public InsertMacroActionListener(JTextField textField) {
            this.myTextField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacrosDialog dialog = new MacrosDialog(ToolEditorDialog.this.myProject);
            dialog.show();
            if (dialog.isOK() && dialog.getSelectedMacro() != null) {
                String macro = dialog.getSelectedMacro().getName();
                int position = this.myTextField.getCaretPosition();
                try {
                    this.myTextField.getDocument().insertString(position, "$" + macro + "$", null);
                    this.myTextField.setCaretPosition(position + macro.length() + 2);
                }
                catch (BadLocationException ignored) {
                    // empty catch block
                }
            }
            IdeFocusManager.findInstance().requestFocus((Component)this.myTextField, true);
        }
    }
}

