/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceRootNode
extends SliceNode {
    private final SliceUsage myRootUsage;

    public SliceRootNode(@NotNull Project project, @NotNull DuplicateMap targetEqualUsages, SliceUsage rootUsage) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceRootNode.<init> must not be null");
        }
        if (targetEqualUsages == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceRootNode.<init> must not be null");
        }
        super(project, new SliceUsage((PsiElement)rootUsage.getElement().getContainingFile(), rootUsage.params), targetEqualUsages);
        this.myRootUsage = rootUsage;
    }

    void switchToAllLeavesTogether(SliceUsage rootUsage) {
        SliceNode node = new SliceNode(this.getProject(), rootUsage, this.targetEqualUsages);
        this.myCachedChildren = Collections.singletonList(node);
    }

    @Override
    SliceRootNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceRootNode newNode = new SliceRootNode(this.getProject(), new DuplicateMap(), newUsage);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        return newNode;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        if (this.myCachedChildren == null) {
            this.switchToAllLeavesTogether(this.myRootUsage);
        }
        List list = this.myCachedChildren;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceRootNode.getChildren must not return null");
        }
        return list;
    }

    @Override
    public List<? extends AbstractTreeNode> getChildrenUnderProgress(ProgressIndicator progress) {
        return (List)this.getChildren();
    }

    protected boolean shouldUpdateData() {
        return super.shouldUpdateData();
    }

    @Override
    protected void update(PresentationData presentation) {
        if (presentation != null) {
            presentation.setChanged(presentation.isChanged() || this.changed);
            this.changed = false;
        }
    }

    @Override
    public void customizeCellRenderer(SliceUsageCellRenderer renderer, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
    }

    public SliceUsage getRootUsage() {
        return this.myRootUsage;
    }
}

