/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.resolver;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.Bottom;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.PsiExtendedTypeVisitor;
import com.intellij.refactoring.typeCook.deductive.PsiTypeVariableFactory;
import com.intellij.refactoring.typeCook.deductive.builder.Constraint;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.builder.Subtype;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class BindingFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeCook.deductive.resolver.BindingFactory");
    private final HashSet<PsiTypeVariable> myBoundVariables;
    private final Project myProject;
    private final PsiTypeVariableFactory myFactory;

    private PsiClass[] getGreatestLowerClasses(PsiClass aClass, PsiClass bClass) {
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)bClass, (boolean)true)) {
            return new PsiClass[]{aClass};
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)bClass, (PsiClass)aClass, (boolean)true)) {
            return new PsiClass[]{bClass};
        }
        LinkedHashSet<PsiClass> descendants = new LinkedHashSet<PsiClass>();
        new Object(){

            public void getGreatestLowerClasses(PsiClass aClass, PsiClass bClass, Set<PsiClass> descendants) {
                if (bClass.hasModifierProperty("final")) {
                    return;
                }
                if (aClass.isInheritor(bClass, true)) {
                    descendants.add(aClass);
                } else {
                    for (PsiClass bInheritor : ClassInheritorsSearch.search((PsiClass)bClass, (SearchScope)bClass.getUseScope(), (boolean)false)) {
                        this.getGreatestLowerClasses(bInheritor, aClass, descendants);
                    }
                }
            }
        }.getGreatestLowerClasses(aClass, bClass, descendants);
        return descendants.toArray(new PsiClass[descendants.size()]);
    }

    public Binding balance(PsiType x, PsiType y, final Balancer balancer, final HashSet<Constraint> constraints) {
        int indicator = (x instanceof PsiTypeVariable ? 1 : 0) + (y instanceof PsiTypeVariable ? 2 : 0);
        switch (indicator) {
            case 0: {
                if (x instanceof PsiWildcardType || y instanceof PsiWildcardType) {
                    PsiType xType = x instanceof PsiWildcardType ? ((PsiWildcardType)x).getBound() : x;
                    PsiType yType = y instanceof PsiWildcardType ? ((PsiWildcardType)y).getBound() : y;
                    switch ((x instanceof PsiWildcardType ? 1 : 0) + (y instanceof PsiWildcardType ? 2 : 0)) {
                        case 1: {
                            if (((PsiWildcardType)x).isExtends()) {
                                return null;
                            }
                            if (xType != null && !"java.lang.Object".equals(xType.getCanonicalText())) {
                                return null;
                            }
                            return this.create();
                        }
                        case 2: {
                            if (((PsiWildcardType)y).isExtends()) {
                                if (yType instanceof PsiTypeVariable) {
                                    PsiTypeVariable beta = this.myFactory.create();
                                    if (constraints != null) {
                                        constraints.add(new Subtype(beta, yType));
                                        if (x != null) {
                                            constraints.add(new Subtype(x, yType));
                                        }
                                    }
                                    return this.create();
                                }
                                if (constraints != null && xType != null && yType != null) {
                                    constraints.add(new Subtype(xType, yType));
                                }
                                return this.balance(xType, yType, balancer, constraints);
                            }
                            if (yType instanceof PsiTypeVariable) {
                                PsiTypeVariable beta = this.myFactory.create();
                                if (constraints != null) {
                                    if (x != null) {
                                        constraints.add(new Subtype(x, beta));
                                    }
                                    constraints.add(new Subtype(yType, beta));
                                }
                                return this.create();
                            }
                            if (constraints != null && yType != null && xType != null) {
                                constraints.add(new Subtype(yType, xType));
                            }
                            return this.balance(xType, yType, balancer, constraints);
                        }
                        case 3: {
                            switch ((((PsiWildcardType)x).isExtends() ? 0 : 1) + (((PsiWildcardType)y).isExtends() ? 0 : 2)) {
                                case 0: {
                                    if (constraints != null && xType != null && yType != null) {
                                        constraints.add(new Subtype(yType, xType));
                                    }
                                    return this.balance(xType, yType, balancer, constraints);
                                }
                                case 1: {
                                    if (constraints != null && xType != null && yType != null) {
                                        constraints.add(new Subtype(xType, yType));
                                    }
                                    return this.balance(xType, yType, balancer, constraints);
                                }
                                case 2: {
                                    return null;
                                }
                                case 3: {
                                    if (constraints != null && xType != null && yType != null) {
                                        constraints.add(new Subtype(xType, yType));
                                    }
                                    return this.balance(xType, yType, balancer, constraints);
                                }
                            }
                        }
                    }
                    return this.create();
                }
                if (x instanceof PsiArrayType || y instanceof PsiArrayType) {
                    PsiType xType = x instanceof PsiArrayType ? ((PsiArrayType)x).getComponentType() : x;
                    PsiType yType = y instanceof PsiArrayType ? ((PsiArrayType)y).getComponentType() : y;
                    return this.balance(xType, yType, balancer, constraints);
                }
                if (x instanceof PsiClassType && y instanceof PsiClassType) {
                    PsiClassType.ClassResolveResult resultX = Util.resolveType(x);
                    PsiClassType.ClassResolveResult resultY = Util.resolveType(y);
                    PsiClass xClass = resultX.getElement();
                    PsiClass yClass = resultY.getElement();
                    if (xClass == null || yClass == null) break;
                    PsiSubstitutor ySubst = resultY.getSubstitutor();
                    PsiSubstitutor xSubst = TypeConversionUtil.getClassSubstitutor((PsiClass)yClass, (PsiClass)xClass, (PsiSubstitutor)resultX.getSubstitutor());
                    if (xSubst == null) {
                        return null;
                    }
                    Binding b = this.create();
                    for (PsiTypeParameter aParm : xSubst.getSubstitutionMap().keySet()) {
                        PsiType yType;
                        PsiType xType = xSubst.substitute(aParm);
                        Binding b1 = this.unify(xType, yType = ySubst.substitute(aParm), new Unifier(){

                            @Override
                            public Binding unify(PsiType x, PsiType y) {
                                return BindingFactory.this.balance(x, y, balancer, constraints);
                            }
                        });
                        if (b1 == null) {
                            return null;
                        }
                        b = b.compose(b1);
                    }
                    return b;
                }
                if (y instanceof Bottom) {
                    return this.create();
                }
                return null;
            }
            case 1: {
                return balancer.varType((PsiTypeVariable)x, y);
            }
            case 2: {
                return balancer.typeVar(x, (PsiTypeVariable)y);
            }
            case 3: {
                return balancer.varVar((PsiTypeVariable)x, (PsiTypeVariable)y);
            }
        }
        return null;
    }

    private Binding unify(PsiType x, PsiType y, Unifier unifier) {
        int indicator = (x instanceof PsiTypeVariable ? 1 : 0) + (y instanceof PsiTypeVariable ? 2 : 0);
        switch (indicator) {
            case 0: {
                if (x instanceof PsiWildcardType || y instanceof PsiWildcardType) {
                    return unifier.unify(x, y);
                }
                if (x instanceof PsiArrayType || y instanceof PsiArrayType) {
                    PsiType xType = x instanceof PsiArrayType ? ((PsiArrayType)x).getComponentType() : x;
                    PsiType yType = y instanceof PsiArrayType ? ((PsiArrayType)y).getComponentType() : y;
                    return this.unify(xType, yType, unifier);
                }
                if (x instanceof PsiClassType && y instanceof PsiClassType) {
                    PsiClassType.ClassResolveResult resultX = Util.resolveType(x);
                    PsiClassType.ClassResolveResult resultY = Util.resolveType(y);
                    PsiClass xClass = resultX.getElement();
                    PsiClass yClass = resultY.getElement();
                    if (xClass == null || yClass == null) break;
                    PsiSubstitutor ySubst = resultY.getSubstitutor();
                    PsiSubstitutor xSubst = resultX.getSubstitutor();
                    if (!xClass.equals(yClass)) {
                        return null;
                    }
                    Binding b = this.create();
                    for (PsiTypeParameter aParm : xSubst.getSubstitutionMap().keySet()) {
                        PsiType yType;
                        PsiType xType = xSubst.substitute(aParm);
                        Binding b1 = this.unify(xType, yType = ySubst.substitute(aParm), unifier);
                        if (b1 == null) {
                            return null;
                        }
                        b = b.compose(b1);
                    }
                    return b;
                }
                if (y instanceof Bottom) {
                    return this.create();
                }
                return null;
            }
        }
        return unifier.unify(x, y);
    }

    public Binding riseWithWildcard(PsiType x, PsiType y, final HashSet<Constraint> constraints) {
        Binding binding = this.balance(x, y, new Balancer(){

            @Override
            public Binding varType(PsiTypeVariable x, PsiType y) {
                if (y instanceof Bottom) {
                    return BindingFactory.this.create();
                }
                if (y == null || y instanceof PsiWildcardType) {
                    return null;
                }
                PsiTypeVariable var = BindingFactory.this.myFactory.create();
                Binding binding = BindingFactory.this.create(x, (PsiType)PsiWildcardType.createSuper((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)var));
                binding.addTypeVariable(var);
                constraints.add(new Subtype(var, y));
                return binding;
            }

            @Override
            public Binding varVar(PsiTypeVariable x, PsiTypeVariable y) {
                int yi;
                int xi = x.getIndex();
                if (xi == (yi = y.getIndex())) {
                    return BindingFactory.this.create();
                }
                return BindingFactory.this.create(y, (PsiType)PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)x));
            }

            @Override
            public Binding typeVar(PsiType x, PsiTypeVariable y) {
                if (x == null) {
                    return BindingFactory.this.create(y, Bottom.BOTTOM);
                }
                if (x instanceof PsiWildcardType) {
                    return null;
                }
                PsiTypeVariable var = BindingFactory.this.myFactory.create();
                Binding binding = BindingFactory.this.create(y, (PsiType)PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)var));
                binding.addTypeVariable(var);
                constraints.add(new Subtype(x, var));
                return binding;
            }
        }, constraints);
        return binding != null ? binding.reduceRecursive() : null;
    }

    public Binding rise(PsiType x, PsiType y, HashSet<Constraint> constraints) {
        Binding binding = this.balance(x, y, new Balancer(){

            @Override
            public Binding varType(PsiTypeVariable x, PsiType y) {
                if (y instanceof Bottom || y instanceof PsiWildcardType) {
                    return BindingFactory.this.create();
                }
                return BindingFactory.this.create(x, y);
            }

            @Override
            public Binding varVar(PsiTypeVariable x, PsiTypeVariable y) {
                int yi;
                int xi = x.getIndex();
                if (xi < (yi = y.getIndex())) {
                    return BindingFactory.this.create(x, y);
                }
                if (yi < xi) {
                    return BindingFactory.this.create(y, x);
                }
                return BindingFactory.this.create();
            }

            @Override
            public Binding typeVar(PsiType x, PsiTypeVariable y) {
                if (x == null) {
                    return BindingFactory.this.create(y, Bottom.BOTTOM);
                }
                if (x instanceof PsiWildcardType) {
                    return BindingFactory.this.create();
                }
                return BindingFactory.this.create(y, x);
            }
        }, constraints);
        return binding != null ? binding.reduceRecursive() : null;
    }

    public Binding sink(PsiType x, PsiType y, HashSet<Constraint> constraints) {
        return this.balance(x, y, new Balancer(){

            @Override
            public Binding varType(PsiTypeVariable x, PsiType y) {
                return BindingFactory.this.create(x, y);
            }

            @Override
            public Binding varVar(PsiTypeVariable x, PsiTypeVariable y) {
                return BindingFactory.this.create(y, Bottom.BOTTOM);
            }

            @Override
            public Binding typeVar(PsiType x, PsiTypeVariable y) {
                return BindingFactory.this.create(y, Bottom.BOTTOM);
            }
        }, constraints);
    }

    public LinkedList<Pair<PsiType, Binding>> union(PsiType x, PsiType y) {
        LinkedList<Pair<PsiType, Binding>> list = new LinkedList<Pair<PsiType, Binding>>();
        new Object(){

            void union(PsiType x, PsiType y, LinkedList<Pair<PsiType, Binding>> list) {
                if (x instanceof PsiArrayType && y instanceof PsiArrayType) {
                    this.union(((PsiArrayType)x).getComponentType(), ((PsiArrayType)y).getComponentType(), list);
                } else if (x instanceof PsiClassType && y instanceof PsiClassType) {
                    PsiClassType.ClassResolveResult xResult = Util.resolveType(x);
                    PsiClassType.ClassResolveResult yResult = Util.resolveType(y);
                    PsiClass xClass = xResult.getElement();
                    PsiClass yClass = yResult.getElement();
                    PsiSubstitutor xSubst = xResult.getSubstitutor();
                    PsiSubstitutor ySubst = yResult.getSubstitutor();
                    if (xClass == null || yClass == null) {
                        return;
                    }
                    if (xClass.equals(yClass)) {
                        Binding risen = BindingFactory.this.rise(x, y, null);
                        if (risen == null) {
                            return;
                        }
                        list.addFirst((Pair<PsiType, Binding>)new Pair((Object)risen.apply(x), (Object)risen));
                    } else {
                        PsiClass[] descendants;
                        for (PsiClass descendant : descendants = BindingFactory.this.getGreatestLowerClasses(xClass, yClass)) {
                            PsiSubstitutor x2aSubst = TypeConversionUtil.getClassSubstitutor((PsiClass)xClass, (PsiClass)descendant, (PsiSubstitutor)xSubst);
                            PsiSubstitutor y2aSubst = TypeConversionUtil.getClassSubstitutor((PsiClass)yClass, (PsiClass)descendant, (PsiSubstitutor)ySubst);
                            LOG.assertTrue(x2aSubst != null && y2aSubst != null);
                            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)xClass.getProject()).getElementFactory();
                            this.union((PsiType)factory.createType(descendant, x2aSubst), (PsiType)factory.createType(descendant, y2aSubst), list);
                        }
                    }
                }
            }
        }.union(x, y, list);
        return list;
    }

    public LinkedList<Pair<PsiType, Binding>> intersect(PsiType x, PsiType y) {
        LinkedList<Pair<PsiType, Binding>> list = new LinkedList<Pair<PsiType, Binding>>();
        new Object(){

            void intersect(PsiType x, PsiType y, LinkedList<Pair<PsiType, Binding>> list) {
                block12: {
                    block10: {
                        block11: {
                            if (x instanceof PsiWildcardType || y instanceof PsiWildcardType) {
                                PsiType xType = x instanceof PsiWildcardType ? ((PsiWildcardType)x).getBound() : x;
                                PsiType yType = y instanceof PsiWildcardType ? ((PsiWildcardType)y).getBound() : y;
                                this.intersect(xType, yType, list);
                            }
                            if (!(x instanceof PsiArrayType) && !(y instanceof PsiArrayType)) break block10;
                            if (!(x instanceof PsiClassType) && !(y instanceof PsiClassType)) break block11;
                            try {
                                PsiElementFactory f = JavaPsiFacade.getInstance((Project)BindingFactory.this.myProject).getElementFactory();
                                PsiType keyType = x instanceof PsiClassType ? x : y;
                                PsiType object = f.createTypeFromText("java.lang.Object", null);
                                PsiType cloneable = f.createTypeFromText("java.lang.Cloneable", null);
                                PsiType serializable = f.createTypeFromText("java.io.Serializable", null);
                                this.intersect(keyType, object, list);
                                this.intersect(keyType, cloneable, list);
                                this.intersect(keyType, serializable, list);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error("Exception " + (Object)((Object)e));
                            }
                            break block12;
                        }
                        if (!(x instanceof PsiArrayType) || !(y instanceof PsiArrayType)) break block12;
                        this.intersect(((PsiArrayType)x).getComponentType(), ((PsiArrayType)y).getComponentType(), list);
                        break block12;
                    }
                    if (x instanceof PsiClassType && y instanceof PsiClassType) {
                        PsiClassType.ClassResolveResult xResult = Util.resolveType(x);
                        PsiClassType.ClassResolveResult yResult = Util.resolveType(y);
                        PsiClass xClass = xResult.getElement();
                        PsiClass yClass = yResult.getElement();
                        PsiSubstitutor xSubst = xResult.getSubstitutor();
                        PsiSubstitutor ySubst = yResult.getSubstitutor();
                        if (xClass == null || yClass == null) {
                            return;
                        }
                        if (xClass.equals(yClass)) {
                            Binding risen = BindingFactory.this.rise(x, y, null);
                            if (risen == null) {
                                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)xClass.getProject()).getElementFactory();
                                list.addFirst((Pair<PsiType, Binding>)new Pair((Object)Util.banalize((PsiType)factory.createType(xClass, factory.createRawSubstitutor((PsiTypeParameterListOwner)xClass))), (Object)BindingFactory.this.create()));
                            } else {
                                list.addFirst((Pair<PsiType, Binding>)new Pair((Object)risen.apply(x), (Object)risen));
                            }
                        } else {
                            PsiClass[] ancestors;
                            for (PsiClass ancestor : ancestors = GenericsUtil.getLeastUpperClasses((PsiClass)xClass, (PsiClass)yClass)) {
                                if ("java.lang.Object".equals(ancestor.getQualifiedName()) && ancestors.length > 1) continue;
                                PsiSubstitutor x2aSubst = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)ancestor, (PsiClass)xClass, (PsiSubstitutor)xSubst);
                                PsiSubstitutor y2aSubst = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)ancestor, (PsiClass)yClass, (PsiSubstitutor)ySubst);
                                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)xClass.getProject()).getElementFactory();
                                this.intersect((PsiType)factory.createType(ancestor, x2aSubst), (PsiType)factory.createType(ancestor, y2aSubst), list);
                            }
                        }
                    }
                }
            }
        }.intersect(x, y, list);
        return list;
    }

    public BindingFactory(ReductionSystem system) {
        this.myBoundVariables = system.getBoundVariables();
        this.myProject = system.getProject();
        this.myFactory = system.getVariableFactory();
    }

    public Binding create(PsiTypeVariable var, PsiType type) {
        return new BindingImpl(var, type);
    }

    public Binding create() {
        return new BindingImpl();
    }

    public HashSet<PsiTypeVariable> getBoundVariables() {
        return this.myBoundVariables;
    }

    static interface Unifier {
        public Binding unify(PsiType var1, PsiType var2);
    }

    static interface Balancer {
        public Binding varType(PsiTypeVariable var1, PsiType var2);

        public Binding varVar(PsiTypeVariable var1, PsiTypeVariable var2);

        public Binding typeVar(PsiType var1, PsiTypeVariable var2);
    }

    private class BindingImpl
    extends Binding {
        private final TIntObjectHashMap<PsiType> myBindings = new TIntObjectHashMap();
        private boolean myCyclic;

        BindingImpl(PsiTypeVariable var, PsiType type) {
            this.myCyclic = type instanceof PsiTypeVariable;
            this.myBindings.put(var.getIndex(), (Object)type);
        }

        BindingImpl(int index, PsiType type) {
            HashSet<PsiTypeVariable> cluster;
            this.myCyclic = type instanceof PsiTypeVariable;
            this.myBindings.put(index, (Object)type);
            if (type instanceof Bottom && (cluster = BindingFactory.this.myFactory.getClusterOf(index)) != null) {
                for (PsiTypeVariable var : cluster) {
                    this.myBindings.put(var.getIndex(), (Object)type);
                }
            }
        }

        BindingImpl() {
            this.myCyclic = false;
        }

        @Override
        public PsiType apply(PsiType type) {
            if (type instanceof PsiTypeVariable) {
                PsiType t = (PsiType)this.myBindings.get(((PsiTypeVariable)type).getIndex());
                return t == null ? type : t;
            }
            if (type instanceof PsiArrayType) {
                return this.apply(((PsiArrayType)type).getComponentType()).createArrayType();
            }
            if (type instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = Util.resolveType(type);
                PsiClass theClass = result.getElement();
                PsiSubstitutor aSubst = result.getSubstitutor();
                PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                if (theClass != null) {
                    for (PsiTypeParameter aParm : aSubst.getSubstitutionMap().keySet()) {
                        PsiType aType = aSubst.substitute(aParm);
                        theSubst = theSubst.put(aParm, this.apply(aType));
                    }
                    return JavaPsiFacade.getInstance((Project)theClass.getProject()).getElementFactory().createType(theClass, theSubst);
                }
                return type;
            }
            if (type instanceof PsiWildcardType) {
                PsiWildcardType wcType = (PsiWildcardType)type;
                PsiType bound = wcType.getBound();
                if (bound != null) {
                    PsiType abound = this.apply(bound);
                    if (abound instanceof PsiWildcardType) {
                        return null;
                    }
                    return wcType.isExtends() ? PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)abound) : PsiWildcardType.createSuper((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)abound);
                }
                return type;
            }
            return type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BindingImpl)) {
                return false;
            }
            BindingImpl binding = (BindingImpl)o;
            return this.myBindings.equals(binding.myBindings);
        }

        @Override
        public Binding compose(Binding b) {
            LOG.assertTrue(b instanceof BindingImpl);
            BindingImpl b1 = this;
            BindingImpl b2 = (BindingImpl)b;
            BindingImpl b3 = new BindingImpl();
            for (PsiTypeVariable boundVariable : BindingFactory.this.myBoundVariables) {
                int i = boundVariable.getIndex();
                PsiType b1i = (PsiType)b1.myBindings.get(i);
                PsiType b2i = (PsiType)b2.myBindings.get(i);
                int flag = (b1i == null ? 0 : 1) + (b2i == null ? 0 : 2);
                switch (flag) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        PsiType type = b2.apply(b1i);
                        if (type == null) {
                            return null;
                        }
                        b3.myBindings.put(i, (Object)type);
                        b3.myCyclic = type instanceof PsiTypeVariable;
                        break;
                    }
                    case 2: {
                        PsiType type = b1.apply(b2i);
                        if (type == null) {
                            return null;
                        }
                        b3.myBindings.put(i, (Object)type);
                        b3.myCyclic = type instanceof PsiTypeVariable;
                        break;
                    }
                    case 3: {
                        Binding common = BindingFactory.this.rise(b1i, b2i, null);
                        if (common == null) {
                            return null;
                        }
                        PsiType type = common.apply(b1i);
                        if (type == null) {
                            return null;
                        }
                        if (type == null) {
                            return null;
                        }
                        b3.myBindings.put(i, (Object)type);
                        b3.myCyclic = type instanceof PsiTypeVariable;
                    }
                }
            }
            return b3;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (PsiTypeVariable boundVariable : BindingFactory.this.myBoundVariables) {
                int i = boundVariable.getIndex();
                PsiType binding = (PsiType)this.myBindings.get(i);
                if (binding == null) continue;
                buffer.append("#").append(i).append(" -> ").append(binding.getPresentableText()).append("; ");
            }
            return buffer.toString();
        }

        private PsiType normalize(PsiType t) {
            if (t == null || t instanceof PsiTypeVariable) {
                return Bottom.BOTTOM;
            }
            if (t instanceof PsiWildcardType) {
                return ((PsiWildcardType)t).getBound();
            }
            return t;
        }

        @Override
        public int compare(Binding binding) {
            BindingImpl b2 = (BindingImpl)binding;
            BindingImpl b1 = this;
            int directoin = 3;
            boolean first = true;
            for (PsiTypeVariable boundVariable : BindingFactory.this.myBoundVariables) {
                PsiType y;
                int index = boundVariable.getIndex();
                PsiType x = this.normalize((PsiType)b1.myBindings.get(index));
                int comp = new Object(){

                    int compare(PsiType x, PsiType y) {
                        int kindY;
                        int[] kinds = new Object(){

                            private int classify(PsiType type) {
                                if (type == null) {
                                    return 0;
                                }
                                if (type instanceof PsiPrimitiveType) {
                                    return 1;
                                }
                                if (type instanceof PsiArrayType) {
                                    return 2;
                                }
                                if (type instanceof PsiClassType) {
                                    return 3;
                                }
                                return 4;
                            }

                            int[] classify2(PsiType x, PsiType y) {
                                return new int[]{this.classify(x), this.classify(y)};
                            }
                        }.classify2(x, y);
                        int kindX = kinds[0];
                        if (kindX + (kindY = kinds[1]) == 0) {
                            return 2;
                        }
                        if (kindX * kindY == 0) {
                            if (kindX == 0) {
                                return 1;
                            }
                            return 0;
                        }
                        if (kindX * kindY == 1) {
                            if (x.equals(y)) {
                                return 2;
                            }
                            return 3;
                        }
                        if (kindX != kindY) {
                            if (kindX == 4) {
                                return 1;
                            }
                            if (kindY == 4) {
                                return 0;
                            }
                            if (kindX + kindY == 5) {
                                try {
                                    int flag;
                                    PsiType type;
                                    PsiElementFactory f = JavaPsiFacade.getInstance((Project)BindingFactory.this.myProject).getElementFactory();
                                    PsiType cloneable = f.createTypeFromText("java.lang.Cloneable", null);
                                    PsiType object = f.createTypeFromText("java.lang.Object", null);
                                    PsiType serializable = f.createTypeFromText("java.io.Serializable", null);
                                    if (kindX == 3) {
                                        type = x;
                                        flag = 1;
                                    } else {
                                        type = y;
                                        flag = 0;
                                    }
                                    if (type.equals(object) || type.equals(cloneable) || type.equals(serializable)) {
                                        return flag;
                                    }
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                            return 3;
                        }
                        if (kindX == 2) {
                            return this.compare(((PsiArrayType)x).getComponentType(), ((PsiArrayType)y).getComponentType());
                        }
                        if (x.equals(y)) {
                            return 2;
                        }
                        PsiClassType.ClassResolveResult resultX = Util.resolveType(x);
                        PsiClassType.ClassResolveResult resultY = Util.resolveType(y);
                        PsiClass xClass = resultX.getElement();
                        PsiClass yClass = resultY.getElement();
                        PsiSubstitutor xSubst = resultX.getSubstitutor();
                        PsiSubstitutor ySubst = resultY.getSubstitutor();
                        if (xClass == null || yClass == null) {
                            return 3;
                        }
                        if (xClass.equals(yClass)) {
                            boolean first = true;
                            int direction = 2;
                            for (PsiTypeParameter p : xSubst.getSubstitutionMap().keySet()) {
                                PsiType yParm;
                                PsiType xParm = xSubst.substitute(p);
                                int comp = this.compare(xParm, yParm = ySubst.substitute(p));
                                if (comp == 3) {
                                    return 3;
                                }
                                if (first) {
                                    first = false;
                                    direction = comp;
                                }
                                if (direction == comp) continue;
                                return 3;
                            }
                            return direction;
                        }
                        if (InheritanceUtil.isCorrectDescendant((PsiClass)xClass, (PsiClass)yClass, (boolean)true)) {
                            return 0;
                        }
                        if (InheritanceUtil.isCorrectDescendant((PsiClass)yClass, (PsiClass)xClass, (boolean)true)) {
                            return 1;
                        }
                        return 3;
                    }
                }.compare(x, y = this.normalize((PsiType)b2.myBindings.get(index)));
                if (comp == 3) {
                    return 3;
                }
                if (first) {
                    first = false;
                    directoin = comp;
                }
                if (directoin != 2) {
                    if (comp == 2 || directoin == comp) continue;
                    return 3;
                }
                if (comp == 2) continue;
                directoin = comp;
            }
            return directoin;
        }

        @Override
        public boolean nonEmpty() {
            return this.myBindings.size() > 0;
        }

        @Override
        public boolean isCyclic() {
            return this.myCyclic;
        }

        @Override
        public Binding reduceRecursive() {
            PsiType type;
            int index;
            BindingImpl binding = (BindingImpl)BindingFactory.this.create();
            for (PsiTypeVariable var : BindingFactory.this.myBoundVariables) {
                index = var.getIndex();
                type = (PsiType)this.myBindings.get(index);
                if (type != null) {
                    class Verifier
                    extends PsiExtendedTypeVisitor<Void> {
                        boolean myFlag = false;

                        Verifier() {
                        }

                        @Override
                        public Void visitTypeVariable(PsiTypeVariable var) {
                            if (var.getIndex() == index) {
                                this.myFlag = true;
                            }
                            return null;
                        }
                    }
                    Verifier verifier = new Verifier();
                    type.accept((PsiTypeVisitor)verifier);
                    if (verifier.myFlag) {
                        this.myBindings.put(index, (Object)Bottom.BOTTOM);
                        binding.myBindings.put(index, (Object)Bottom.BOTTOM);
                        continue;
                    }
                    binding.myBindings.put(index, (Object)type);
                    continue;
                }
                binding.myBindings.put(index, (Object)type);
            }
            for (PsiTypeVariable var : BindingFactory.this.myBoundVariables) {
                index = var.getIndex();
                type = (PsiType)this.myBindings.get(index);
                if (type == null) continue;
                this.myBindings.put(index, (Object)binding.apply(type));
            }
            return this;
        }

        @Override
        public boolean binds(PsiTypeVariable var) {
            return this.myBindings.get(var.getIndex()) != null;
        }

        @Override
        public void merge(Binding b, boolean removeObject) {
            block0: for (PsiTypeVariable var : b.getBoundVariables()) {
                int index = var.getIndex();
                if (this.myBindings.get(index) != null) {
                    LOG.error("Oops... Binding conflict...");
                    continue;
                }
                PsiType type = b.apply(var);
                PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (GlobalSearchScope)GlobalSearchScope.allScope((Project)BindingFactory.this.myProject));
                if (removeObject && javaLangObject.equals((Object)type)) {
                    HashSet<PsiTypeVariable> cluster = BindingFactory.this.myFactory.getClusterOf(var.getIndex());
                    if (cluster == null) continue;
                    for (PsiTypeVariable war : cluster) {
                        PsiType wtype = b.apply(war);
                        if (javaLangObject.equals((Object)wtype)) continue;
                        this.myBindings.put(index, (Object)type);
                        continue block0;
                    }
                    continue;
                }
                this.myBindings.put(index, (Object)type);
            }
        }

        @Override
        public HashSet<PsiTypeVariable> getBoundVariables() {
            return BindingFactory.this.myBoundVariables;
        }

        @Override
        public int getWidth() {
            class MyProcecure
            implements TObjectProcedure<PsiType> {
                int width = 0;

                MyProcecure() {
                }

                public boolean execute(PsiType type) {
                    if (BindingImpl.this.substitute(type) != null) {
                        ++this.width;
                    }
                    return true;
                }

                public int getWidth() {
                    return this.width;
                }
            }
            MyProcecure procedure = new MyProcecure();
            this.myBindings.forEachValue((TObjectProcedure)procedure);
            return procedure.getWidth();
        }

        @Override
        public boolean isValid() {
            for (PsiTypeVariable var : BindingFactory.this.myBoundVariables) {
                PsiType type;
                if (var.isValidInContext(type = this.substitute(var))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addTypeVariable(PsiTypeVariable var) {
            BindingFactory.this.myBoundVariables.add(var);
        }

        @Override
        public PsiType substitute(PsiType t) {
            if (t instanceof PsiWildcardType) {
                PsiWildcardType wcType = (PsiWildcardType)t;
                PsiType bound = wcType.getBound();
                if (bound == null) {
                    return t;
                }
                PsiManager manager = PsiManager.getInstance((Project)BindingFactory.this.myProject);
                PsiType subst = this.substitute(bound);
                if (subst == null) {
                    return null;
                }
                return subst instanceof PsiWildcardType ? subst : (wcType.isExtends() ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)subst) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)subst));
            }
            if (t instanceof PsiTypeVariable) {
                PsiType b = this.apply(t);
                if (b instanceof Bottom || b instanceof PsiTypeVariable) {
                    return null;
                }
                return this.substitute(b);
            }
            if (t instanceof Bottom) {
                return null;
            }
            if (t instanceof PsiArrayType) {
                return this.substitute(((PsiArrayType)t).getComponentType()).createArrayType();
            }
            if (t instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)t).resolveGenerics();
                PsiClass aClass = result.getElement();
                PsiSubstitutor aSubst = result.getSubstitutor();
                if (aClass != null) {
                    PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                    for (PsiTypeParameter parm : aSubst.getSubstitutionMap().keySet()) {
                        PsiType type = aSubst.substitute(parm);
                        theSubst = theSubst.put(parm, this.substitute(type));
                    }
                    return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, theSubst);
                }
            }
            return t;
        }
    }
}

