/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaNameSuggestionProvider
implements NameSuggestionProvider {
    @Nullable
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, List<String> result) {
        PsiElement nameSuggestionContextParent;
        String initialName = UsageViewUtil.getShortName(element);
        SuggestedNameInfo info = JavaNameSuggestionProvider.suggestNamesForElement(element);
        String parameterName = null;
        String superMethodName = null;
        if (nameSuggestionContext != null && (nameSuggestionContextParent = nameSuggestionContext.getParent()) != null) {
            PsiElement parent3;
            PsiElement parentOfParent = nameSuggestionContextParent.getParent();
            if (parentOfParent instanceof PsiExpressionList) {
                PsiMethod method;
                PsiExpressionList expressionList = (PsiExpressionList)parentOfParent;
                PsiElement parent = expressionList.getParent();
                if (parent instanceof PsiCallExpression && (method = ((PsiCallExpression)parent).resolveMethod()) != null) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiExpression[] expressions = expressionList.getExpressions();
                    for (int i = 0; i < expressions.length; ++i) {
                        PsiExpression expression = expressions[i];
                        if (expression != nameSuggestionContextParent) continue;
                        if (i < parameters.length) {
                            parameterName = parameters[i].getName();
                        }
                        break;
                    }
                }
            } else if (parentOfParent instanceof PsiParameterList && (parent3 = parentOfParent.getParent()) instanceof PsiMethod) {
                String propName = PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)parent3));
                if (propName != null) {
                    parameterName = propName;
                }
                if (nameSuggestionContextParent instanceof PsiParameter) {
                    superMethodName = JavaNameSuggestionProvider.getSuperMethodName((PsiParameter)nameSuggestionContextParent, (PsiMethod)parent3);
                }
            }
        }
        String[] strings = info != null ? info.names : ArrayUtil.EMPTY_STRING_ARRAY;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(strings));
        String[] properlyCased = JavaNameSuggestionProvider.suggestProperlyCasedName(element);
        if (!list.contains(initialName)) {
            list.add(0, initialName);
        } else {
            int i = list.indexOf(initialName);
            list.remove(i);
            list.add(0, initialName);
        }
        if (properlyCased != null) {
            for (String properlyCasedSuggestion : properlyCased) {
                list.add(1, properlyCasedSuggestion);
            }
        }
        if (parameterName != null && !list.contains(parameterName)) {
            list.add(parameterName);
        }
        if (superMethodName != null && !list.contains(superMethodName)) {
            list.add(0, superMethodName);
        }
        ContainerUtil.removeDuplicates(list);
        result.addAll(list);
        return info;
    }

    @Nullable
    private static String getSuperMethodName(PsiParameter psiParameter, PsiMethod method) {
        PsiMethod[] superMethods;
        int index = method.getParameterList().getParameterIndex(psiParameter);
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            PsiParameterList superParameters = superMethod.getParameterList();
            if (index >= superParameters.getParametersCount()) continue;
            return superParameters.getParameters()[index].getName();
        }
        return null;
    }

    @Nullable
    public Collection<LookupElement> completeName(PsiElement element, PsiElement nameSuggestionContext, String prefix) {
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            VariableKind kind = JavaCodeStyleManager.getInstance((Project)element.getProject()).getVariableKind(var);
            LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
            JavaCompletionUtil.completeVariableNameForRefactoring(element.getProject(), set, prefix, var.getType(), kind);
            if (prefix.length() == 0) {
                ArrayList<String> suggestedNames = new ArrayList<String>();
                this.getSuggestedNames(element, nameSuggestionContext, suggestedNames);
                for (String suggestedName : suggestedNames) {
                    LookupItemUtil.addLookupItem(set, suggestedName);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String[] suggestProperlyCasedName(PsiElement psiElement) {
        if (!(psiElement instanceof PsiNamedElement)) {
            return null;
        }
        String name = ((PsiNamedElement)psiElement).getName();
        if (name == null) {
            return null;
        }
        if (psiElement instanceof PsiVariable) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject());
            VariableKind kind = codeStyleManager.getVariableKind((PsiVariable)psiElement);
            String prefix = codeStyleManager.getPrefixByVariableKind(kind);
            if (kind == VariableKind.STATIC_FINAL_FIELD) {
                String[] words = NameUtil.splitNameIntoWords((String)name);
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < words.length; ++i) {
                    String word = words[i];
                    if (i > 0) {
                        buffer.append('_');
                    }
                    buffer.append(word.toUpperCase());
                }
                return new String[]{buffer.toString()};
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtil.splitNameIntoWords((String)name)));
            if (name.startsWith(prefix)) {
                name = name.substring(prefix.length());
                result.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtil.splitNameIntoWords((String)name)));
            }
            result.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtil.splitNameIntoWords((String)name.toLowerCase())));
            return ArrayUtil.toStringArray(result);
        }
        return new String[]{name};
    }

    private static String suggestProperlyCasedName(String prefix, String[] words) {
        StringBuilder buffer = new StringBuilder(prefix);
        for (int i = 0; i < words.length; ++i) {
            boolean prefixRequiresCapitalization;
            String word = words[i];
            boolean bl = prefixRequiresCapitalization = prefix.length() > 0 && !StringUtil.endsWithChar((CharSequence)prefix, (char)'_');
            if (i > 0 || prefixRequiresCapitalization) {
                buffer.append(StringUtil.capitalize((String)word));
                continue;
            }
            buffer.append(StringUtil.decapitalize((String)word));
        }
        return buffer.toString();
    }

    @Nullable
    private static SuggestedNameInfo suggestNamesForElement(PsiElement element) {
        PsiIdentifier identifier;
        PsiVariable var = null;
        if (element instanceof PsiVariable) {
            var = (PsiVariable)element;
        } else if (element instanceof PsiIdentifier && (identifier = (PsiIdentifier)element).getParent() instanceof PsiVariable) {
            var = (PsiVariable)identifier.getParent();
        }
        if (var == null) {
            return null;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        VariableKind variableKind = codeStyleManager.getVariableKind(var);
        return codeStyleManager.suggestVariableName(variableKind, null, var.getInitializer(), var.getType());
    }
}

