/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Icons;
import javax.swing.Icon;

public class SchemaPrefix
extends RenameableFakePsiElement {
    private final XmlElement myParent;
    private final TextRange myRange;
    private final String myName;

    public SchemaPrefix(XmlElement parent, TextRange range, String name) {
        super((PsiElement)parent);
        this.myParent = parent;
        this.myRange = range;
        this.myName = name;
    }

    public String getTypeName() {
        return "XML Namespace Prefix";
    }

    public Icon getIcon() {
        return Icons.VARIABLE_ICON;
    }

    @Override
    public int getTextOffset() {
        return this.myParent.getTextRange().getStartOffset() + this.myRange.getStartOffset();
    }

    @Override
    public int getTextLength() {
        return this.myName.length();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public TextRange getTextRange() {
        return TextRange.from((int)this.getTextOffset(), (int)this.getTextLength());
    }
}

