/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedFileViewProvider
extends SingleRootFileViewProvider {
    private final Object LOCK;
    private Place myShreds;
    private Project myProject;
    private final Object myLock;
    private final DocumentWindow myDocumentWindow;
    private boolean physical;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InjectedFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFileWindow virtualFile, @NotNull Place shreds, @NotNull DocumentWindow documentWindow, @NotNull Language language) {
        if (psiManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider.<init> must not be null");
        }
        if (shreds == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider.<init> must not be null");
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider.<init> must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider.<init> must not be null");
        }
        super(psiManager, (VirtualFile)virtualFile, true, language);
        this.LOCK = new Object();
        this.myLock = new Object();
        this.physical = true;
        this.myDocumentWindow = documentWindow;
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds = shreds;
            this.myProject = ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)0)).host.getProject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rootChanged(PsiFile psiFile) {
        Place shreds;
        super.rootChanged(psiFile);
        if (!this.isPhysical()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            shreds = this.myShreds;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)this.myDocumentWindow;
        assert (documentWindow.getHostRanges().length == shreds.size());
        String[] changes = documentWindow.calculateMinEditSequence(psiFile.getNode().getText());
        assert (changes.length == shreds.size());
        for (int i = 0; i < changes.length; ++i) {
            String change = changes[i];
            if (change == null) continue;
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            PsiLanguageInjectionHost host = shred.host;
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            String newHostText = StringUtil.replaceSubstring((String)host.getText(), (TextRange)rangeInsideHost, (String)change);
            shred.host = host.updateText(newHostText);
        }
    }

    @Override
    public FileViewProvider clone() {
        final DocumentWindow oldDocumentWindow = ((VirtualFileWindow)this.getVirtualFile()).getDocumentWindow();
        Document hostDocument = oldDocumentWindow.getDelegate();
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        PsiFile hostFile = documentManager.getPsiFile(hostDocument);
        Language hostFileLanguage = this.getPsi(this.getBaseLanguage()).getContext().getContainingFile().getLanguage();
        PsiFile hostPsiFileCopy = (PsiFile)hostFile.copy();
        RangeMarker firstTextRange = oldDocumentWindow.getHostRanges()[0];
        PsiElement elementCopy = hostPsiFileCopy.getViewProvider().findElementAt(firstTextRange.getStartOffset(), hostFileLanguage);
        assert (elementCopy != null);
        final Ref provider = new Ref();
        InjectedLanguageUtil.enumerate(elementCopy, hostPsiFileCopy, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider$1.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider$1.visit must not be null");
                }
                Document document = documentManager.getCachedDocument(injectedPsi);
                if (document instanceof DocumentWindowImpl && oldDocumentWindow.areRangesEqual((DocumentWindow)((DocumentWindowImpl)document))) {
                    provider.set((Object)injectedPsi.getViewProvider());
                }
            }
        }, true);
        return (FileViewProvider)provider.get();
    }

    @Override
    @Nullable
    protected PsiFile getPsiInner(Language target) {
        PsiFile file = super.getPsiInner(target);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShreds(Place shreds) {
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds = new Place((List<PsiLanguageInjectionHost.Shred>)((Object)shreds));
            this.myProject = ((PsiLanguageInjectionHost.Shred)shreds.get((int)0)).host.getProject();
            ((DocumentWindowImpl)this.myDocumentWindow).setShreds(this.myShreds);
        }
    }

    boolean isValid() {
        return this.getShreds().isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisposed() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myProject.isDisposed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Place getShreds() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myShreds;
        }
    }

    public DocumentWindow getDocument() {
        return this.myDocumentWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEventSystemEnabled() {
        if (this.LOCK == null) {
            return true;
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.physical;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPhysical() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.physical;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performNonPhysically(Runnable runnable) {
        Object object = this.LOCK;
        synchronized (object) {
            this.physical = false;
            try {
                runnable.run();
            }
            finally {
                this.physical = true;
            }
        }
    }
}

