/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.util.containers.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JspContextManager {
    public static JspContextManager getInstance(Project project) {
        return (JspContextManager)project.getComponent(JspContextManager.class);
    }

    public abstract JspFile[] getSuitableContextFiles(@NotNull PsiFile var1);

    public abstract void setContextFile(@NotNull PsiFile var1, @Nullable JspFile var2, boolean var3);

    @Nullable
    public abstract JspFile getContextFile(@NotNull PsiFile var1);

    @Nullable
    public abstract JspFile getConfiguredContextFile(@NotNull PsiFile var1);

    @NotNull
    public JspFile getRootContextFile(@NotNull JspFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/jsp/JspContextManager.getRootContextFile must not be null");
        }
        JspFile rootContext = file;
        HashSet recursionPreventer = new HashSet();
        while (true) {
            recursionPreventer.add((Object)rootContext);
            JspFile context = this.getContextFile((PsiFile)rootContext);
            if (context == null || recursionPreventer.contains((Object)context)) break;
            rootContext = context;
        }
        JspFile jspFile = rootContext;
        if (jspFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/jsp/JspContextManager.getRootContextFile must not return null");
        }
        return jspFile;
    }
}

