/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.IndexPatternOccurrenceImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.text.CharSequenceSubSequence;
import gnu.trove.TIntArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndexPatternSearcher
implements QueryExecutor<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    public boolean execute(IndexPatternSearch.SearchParameters queryParameters, Processor<IndexPatternOccurrence> consumer) {
        int count;
        PsiFile file = queryParameters.getFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (file instanceof PsiBinaryFile || file instanceof PsiCompiledElement || virtualFile == null) {
            return true;
        }
        CacheManager cacheManager = ((PsiManagerEx)file.getManager()).getCacheManager();
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int n = count = patternProvider != null ? cacheManager.getTodoCount(virtualFile, patternProvider) : cacheManager.getTodoCount(virtualFile, queryParameters.getPattern());
        if (count == 0) {
            return true;
        }
        TIntArrayList commentStarts = new TIntArrayList();
        TIntArrayList commentEnds = new TIntArrayList();
        CharSequence chars = file.getViewProvider().getContents();
        IndexPatternSearcher.findCommentTokenRanges(file, chars, queryParameters.getRange(), commentStarts, commentEnds);
        for (int i = 0; i < commentStarts.size(); ++i) {
            int commentStart = commentStarts.get(i);
            int commentEnd = commentEnds.get(i);
            if (patternProvider != null) {
                for (IndexPattern pattern : patternProvider.getIndexPatterns()) {
                    if (IndexPatternSearcher.collectPatternMatches(pattern, chars, commentStart, commentEnd, file, queryParameters.getRange(), consumer)) continue;
                    return false;
                }
                continue;
            }
            if (IndexPatternSearcher.collectPatternMatches(queryParameters.getPattern(), chars, commentStart, commentEnd, file, queryParameters.getRange(), consumer)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findCommentTokenRanges(PsiFile file, CharSequence chars, TextRange range, TIntArrayList commentStarts, TIntArrayList commentEnds) {
        if (file instanceof PsiPlainTextFile) {
            FileType fType = file.getFileType();
            Object object = PsiLock.LOCK;
            synchronized (object) {
                if (fType instanceof AbstractFileType) {
                    Lexer lexer = SyntaxHighlighter.PROVIDER.create(fType, file.getProject(), file.getVirtualFile()).getHighlightingLexer();
                    IndexPatternSearcher.findComments(lexer, chars, range, COMMENT_TOKENS, commentStarts, commentEnds, null);
                } else {
                    commentStarts.add(0);
                    commentEnds.add(file.getTextLength());
                }
            }
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            ParserDefinition parserDefinition;
            Language lang = file.getLanguage();
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, (Project)file.getProject(), (VirtualFile)file.getVirtualFile());
            Lexer lexer = syntaxHighlighter.getHighlightingLexer();
            TokenSet commentTokens = null;
            IndexPatternBuilder builderForFile = null;
            for (IndexPatternBuilder builder : (IndexPatternBuilder[])Extensions.getExtensions(IndexPatternBuilder.EP_NAME)) {
                Lexer lexerFromBuilder = builder.getIndexingLexer(file);
                if (lexerFromBuilder == null) continue;
                lexer = lexerFromBuilder;
                commentTokens = builder.getCommentTokenSet(file);
                builderForFile = builder;
            }
            if (builderForFile == null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
                commentTokens = parserDefinition.getCommentTokens();
            }
            if (commentTokens != null) {
                IndexPatternSearcher.findComments(lexer, chars, range, commentTokens, commentStarts, commentEnds, builderForFile);
            }
        }
    }

    private static void findComments(Lexer lexer, CharSequence chars, TextRange range, TokenSet commentTokens, TIntArrayList commentStarts, TIntArrayList commentEnds, IndexPatternBuilder builderForFile) {
        IElementType tokenType;
        lexer.start(chars);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (range != null) {
                if (lexer.getTokenEnd() > range.getStartOffset()) {
                    if (lexer.getTokenStart() >= range.getEndOffset()) break;
                }
            } else {
                Language commentLang;
                ParserDefinition parserDefinition;
                boolean isComment;
                if (!(isComment = commentTokens.contains(tokenType)) && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(commentLang = tokenType.getLanguage())) != null) {
                    TokenSet langCommentTokens = parserDefinition.getCommentTokens();
                    isComment = langCommentTokens.contains(tokenType);
                }
                if (isComment) {
                    int startDelta = builderForFile != null ? builderForFile.getCommentStartDelta(lexer.getTokenType()) : 0;
                    int endDelta = builderForFile != null ? builderForFile.getCommentEndDelta(lexer.getTokenType()) : 0;
                    int start = lexer.getTokenStart() + startDelta;
                    int end = lexer.getTokenEnd() - endDelta;
                    assert (start <= end) : "Invalid comment range: " + new TextRange(start, end) + "; lexer token range=" + new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()) + "; delta=" + new TextRange(startDelta, endDelta) + "; lexer=" + lexer + "; builder=" + builderForFile + "; chars length:" + chars.length();
                    assert (end <= chars.length()) : "Invalid comment end: " + new TextRange(start, end) + "; lexer token range=" + new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()) + "; delta=" + new TextRange(startDelta, endDelta) + "; lexer=" + lexer + "; builder=" + builderForFile + "; chars length:" + chars.length();
                    commentStarts.add(start);
                    commentEnds.add(end);
                }
            }
            lexer.advance();
        }
    }

    private static boolean collectPatternMatches(IndexPattern indexPattern, CharSequence chars, int commentStart, int commentEnd, PsiFile file, TextRange range, Processor<IndexPatternOccurrence> consumer) {
        Pattern pattern = indexPattern.getPattern();
        if (pattern != null) {
            boolean found;
            ProgressManager.checkCanceled();
            CharSequenceSubSequence input = new CharSequenceSubSequence(chars, commentStart, commentEnd);
            Matcher matcher = pattern.matcher((CharSequence)input);
            while (found = matcher.find()) {
                int end;
                int start = matcher.start() + commentStart;
                if (start != (end = matcher.end() + commentStart) && (range == null || range.getStartOffset() <= start && end <= range.getEndOffset()) && !consumer.process((Object)new IndexPatternOccurrenceImpl(file, start, end, indexPattern))) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
        }
        return true;
    }
}

